/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.endpoints;

import com.google.gson.JsonElement;
import com.pubnub.api.PubNubError;
import com.pubnub.api.PubNubException;
import com.pubnub.api.endpoints.FetchMessages;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.models.consumer.PNBoundedPage;
import com.pubnub.api.models.consumer.history.HistoryMessageType;
import com.pubnub.api.models.consumer.history.PNFetchMessageItem;
import com.pubnub.api.models.consumer.history.PNFetchMessagesResult;
import com.pubnub.api.retry.RetryableEndpointGroup;
import com.pubnub.internal.EndpointCore;
import com.pubnub.internal.PubNubImpl;
import com.pubnub.internal.PubNubUtilKt;
import com.pubnub.internal.extension.IntKt;
import com.pubnub.internal.extension.JsonElementKt;
import com.pubnub.internal.models.server.FetchMessagesEnvelope;
import com.pubnub.internal.models.server.FetchMessagesPage;
import com.pubnub.internal.models.server.history.ServerFetchMessageItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Call;
import retrofit2.Response;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0002\u0018\u0000 /2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u00020\u0004:\u0001/BY\b\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\r\u0012\b\b\u0002\u0010\u000f\u001a\u00020\r\u0012\b\b\u0002\u0010\u0010\u001a\u00020\r\u0012\b\b\u0002\u0010\u0011\u001a\u00020\r\u00a2\u0006\u0004\b\u0012\u0010\u0013J\b\u0010\u001e\u001a\u00020\u001fH\u0014J\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0014J2\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00020\"2\"\u0010#\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0$j\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t`%H\u0014J\u0016\u0010&\u001a\u00020\u00032\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00020(H\u0014J\b\u0010)\u001a\u00020*H\u0016J\b\u0010+\u001a\u00020,H\u0014J\u001c\u0010-\u001a\u00020\u001f2\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0.H\u0002R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u000e\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0019R\u0014\u0010\u000f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0019R\u0014\u0010\u0010\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0019R\u0014\u0010\u0011\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0019\u00a8\u00060"}, d2={"Lcom/pubnub/internal/endpoints/FetchMessagesEndpoint;", "Lcom/pubnub/internal/EndpointCore;", "Lcom/pubnub/internal/models/server/FetchMessagesEnvelope;", "Lcom/pubnub/api/models/consumer/history/PNFetchMessagesResult;", "Lcom/pubnub/api/endpoints/FetchMessages;", "pubnub", "Lcom/pubnub/internal/PubNubImpl;", "channels", "", "", "page", "Lcom/pubnub/api/models/consumer/PNBoundedPage;", "includeUUID", "", "includeMeta", "includeMessageActions", "includeMessageType", "includeCustomMessageType", "<init>", "(Lcom/pubnub/internal/PubNubImpl;Ljava/util/List;Lcom/pubnub/api/models/consumer/PNBoundedPage;ZZZZZ)V", "getChannels", "()Ljava/util/List;", "getPage", "()Lcom/pubnub/api/models/consumer/PNBoundedPage;", "getIncludeUUID", "()Z", "getIncludeMeta", "getIncludeMessageActions", "getIncludeMessageType", "getIncludeCustomMessageType", "validateParams", "", "getAffectedChannels", "doWork", "Lretrofit2/Call;", "queryParams", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "createResponse", "input", "Lretrofit2/Response;", "operationType", "Lcom/pubnub/api/enums/PNOperationType$PNFetchMessagesOperation;", "getEndpointGroupName", "Lcom/pubnub/api/retry/RetryableEndpointGroup;", "addQueryParams", "", "Companion", "pubnub-kotlin-impl"})
@SourceDebugExtension(value={"SMAP\nFetchMessagesEndpoint.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FetchMessagesEndpoint.kt\ncom/pubnub/internal/endpoints/FetchMessagesEndpoint\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,157:1\n462#2:158\n412#2:159\n1246#3,2:160\n1557#3:162\n1628#3,3:163\n1249#3:166\n1#4:167\n*S KotlinDebug\n*F\n+ 1 FetchMessagesEndpoint.kt\ncom/pubnub/internal/endpoints/FetchMessagesEndpoint\n*L\n100#1:158\n100#1:159\n100#1:160,2\n101#1:162\n101#1:163,3\n100#1:166\n*E\n"})
public final class FetchMessagesEndpoint
extends EndpointCore<FetchMessagesEnvelope, PNFetchMessagesResult>
implements FetchMessages {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<String> channels;
    @NotNull
    private final PNBoundedPage page;
    private final boolean includeUUID;
    private final boolean includeMeta;
    private final boolean includeMessageActions;
    private final boolean includeMessageType;
    private final boolean includeCustomMessageType;
    private static final int SINGLE_CHANNEL_DEFAULT_MESSAGES = 100;
    private static final int SINGLE_CHANNEL_MAX_MESSAGES = 100;
    private static final int MULTIPLE_CHANNEL_DEFAULT_MESSAGES = 25;
    private static final int MULTIPLE_CHANNEL_MAX_MESSAGES = 25;
    private static final int DEFAULT_MESSAGES_WITH_ACTIONS = 25;
    private static final int MAX_MESSAGES_WITH_ACTIONS = 25;
    @NotNull
    public static final String INCLUDE_MESSAGE_TYPE_QUERY_PARAM = "include_message_type";
    @NotNull
    private static final String INCLUDE_CUSTOM_MESSAGE_TYPE = "include_custom_message_type";

    public FetchMessagesEndpoint(@NotNull PubNubImpl pubnub, @NotNull List<String> channels, @NotNull PNBoundedPage page, boolean includeUUID, boolean includeMeta, boolean includeMessageActions, boolean includeMessageType, boolean includeCustomMessageType) {
        Intrinsics.checkNotNullParameter((Object)pubnub, (String)"pubnub");
        Intrinsics.checkNotNullParameter(channels, (String)"channels");
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        super(pubnub);
        this.channels = channels;
        this.page = page;
        this.includeUUID = includeUUID;
        this.includeMeta = includeMeta;
        this.includeMessageActions = includeMessageActions;
        this.includeMessageType = includeMessageType;
        this.includeCustomMessageType = includeCustomMessageType;
    }

    public /* synthetic */ FetchMessagesEndpoint(PubNubImpl pubNubImpl, List list, PNBoundedPage pNBoundedPage, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            bl2 = false;
        }
        if ((n & 0x20) != 0) {
            bl3 = false;
        }
        if ((n & 0x40) != 0) {
            bl4 = false;
        }
        if ((n & 0x80) != 0) {
            bl5 = false;
        }
        this(pubNubImpl, list, pNBoundedPage, bl, bl2, bl3, bl4, bl5);
    }

    @NotNull
    public List<String> getChannels() {
        return this.channels;
    }

    @NotNull
    public PNBoundedPage getPage() {
        return this.page;
    }

    public boolean getIncludeUUID() {
        return this.includeUUID;
    }

    public boolean getIncludeMeta() {
        return this.includeMeta;
    }

    public boolean getIncludeMessageActions() {
        return this.includeMessageActions;
    }

    public boolean getIncludeMessageType() {
        return this.includeMessageType;
    }

    public boolean getIncludeCustomMessageType() {
        return this.includeCustomMessageType;
    }

    @Override
    protected void validateParams() {
        super.validateParams();
        if (this.getChannels().isEmpty()) {
            throw new PubNubException(PubNubError.CHANNEL_MISSING, null, 2, null);
        }
        if (this.getIncludeMessageActions() && this.getChannels().size() > 1) {
            throw new PubNubException(PubNubError.HISTORY_MESSAGE_ACTIONS_MULTIPLE_CHANNELS, null, 2, null);
        }
    }

    @Override
    @NotNull
    protected List<String> getAffectedChannels() {
        return this.getChannels();
    }

    @Override
    @NotNull
    protected Call<FetchMessagesEnvelope> doWork(@NotNull HashMap<String, String> queryParams) {
        Intrinsics.checkNotNullParameter(queryParams, (String)"queryParams");
        this.addQueryParams((Map<String, String>)queryParams);
        return !this.getIncludeMessageActions() ? this.getRetrofitManager().getHistoryService$pubnub_kotlin_impl().fetchMessages(this.getConfiguration().getSubscribeKey(), PubNubUtilKt.toCsv(this.getChannels()), (Map<String, String>)queryParams) : this.getRetrofitManager().getHistoryService$pubnub_kotlin_impl().fetchMessagesWithActions(this.getConfiguration().getSubscribeKey(), (String)CollectionsKt.first(this.getChannels()), (Map<String, String>)queryParams);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected PNFetchMessagesResult createResponse(@NotNull Response<FetchMessagesEnvelope> input) {
        PNBoundedPage pNBoundedPage;
        void $this$mapValuesTo$iv$iv;
        Intrinsics.checkNotNullParameter(input, (String)"input");
        Object object = input.body();
        Intrinsics.checkNotNull((Object)object);
        FetchMessagesEnvelope body = (FetchMessagesEnvelope)object;
        Map<String, List<ServerFetchMessageItem>> $this$mapValues$iv = body.getChannels();
        boolean $i$f$mapValues = false;
        Map<String, List<ServerFetchMessageItem>> map = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void $this$mapTo$iv$iv;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl2 = false;
            List value = (List)entry2.getValue();
            Iterable $this$map$iv = value;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Map map4;
                void serverMessageItem;
                ServerFetchMessageItem serverFetchMessageItem = (ServerFetchMessageItem)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl3 = false;
                Pair<JsonElement, PubNubError> pair = JsonElementKt.tryDecryptMessage(serverMessageItem.getMessage(), this.getConfiguration().getCryptoModule(), this.getPubnub().getMapper());
                JsonElement newMessage = (JsonElement)pair.component1();
                PubNubError error = (PubNubError)pair.component2();
                if (this.getIncludeMessageActions()) {
                    map4 = serverMessageItem.getActions();
                    if (map4 == null) {
                        map4 = MapsKt.emptyMap();
                    }
                } else {
                    map4 = serverMessageItem.getActions();
                }
                Map newActions = map4;
                String string = serverMessageItem.getUuid();
                JsonElement jsonElement = serverMessageItem.getMeta();
                long l = serverMessageItem.getTimetoken();
                HistoryMessageType historyMessageType = this.getIncludeMessageType() ? HistoryMessageType.Companion.of(serverMessageItem.getMessageType()) : null;
                String string2 = serverMessageItem.getCustomMessageType();
                collection.add(new PNFetchMessageItem(string, newMessage, jsonElement, Long.valueOf(l), newActions, historyMessageType, error, string2));
            }
            List list = (List)destination$iv$iv2;
            map3.put(k, list);
        }
        Map channelsMap = MapsKt.toMap((Map)destination$iv$iv);
        FetchMessagesPage fetchMessagesPage = body.getMore();
        if (fetchMessagesPage != null) {
            FetchMessagesPage it = fetchMessagesPage;
            boolean bl = false;
            pNBoundedPage = new PNBoundedPage(it.getStart(), it.getEnd(), it.getMax());
        } else {
            pNBoundedPage = null;
        }
        PNBoundedPage page = pNBoundedPage;
        return new PNFetchMessagesResult(channelsMap, page);
    }

    @NotNull
    public PNOperationType.PNFetchMessagesOperation operationType() {
        return PNOperationType.PNFetchMessagesOperation.INSTANCE;
    }

    @Override
    @NotNull
    protected RetryableEndpointGroup getEndpointGroupName() {
        return RetryableEndpointGroup.MESSAGE_PERSISTENCE;
    }

    private final void addQueryParams(Map<String, String> queryParams) {
        String string;
        String string2;
        Map<String, String> map;
        queryParams.put("max", String.valueOf(Companion.effectiveMax$pubnub_kotlin_impl(this.getPage().getLimit(), this.getIncludeMessageActions(), this.getChannels().size())));
        queryParams.put("include_uuid", String.valueOf(this.getIncludeUUID()));
        Long l = this.getPage().getStart();
        if (l != null) {
            long $this$addQueryParams_u24lambda_u243 = ((Number)l).longValue();
            boolean bl = false;
            map = queryParams;
            string2 = "start";
            string = String.valueOf($this$addQueryParams_u24lambda_u243);
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
            String string3 = string.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
            string = string3;
            map.put(string2, string);
        }
        Long l2 = this.getPage().getEnd();
        if (l2 != null) {
            long $this$addQueryParams_u24lambda_u244 = ((Number)l2).longValue();
            boolean bl = false;
            map = queryParams;
            string2 = "end";
            string = String.valueOf($this$addQueryParams_u24lambda_u244);
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
            String string4 = string.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
            string = string4;
            map.put(string2, string);
        }
        queryParams.put(INCLUDE_MESSAGE_TYPE_QUERY_PARAM, String.valueOf(this.getIncludeMessageType()));
        if (this.getIncludeMeta()) {
            queryParams.put("include_meta", "true");
        }
        queryParams.put(INCLUDE_CUSTOM_MESSAGE_TYPE, String.valueOf(this.getIncludeCustomMessageType()));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J)\u0010\u000e\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0005H\u0000\u00a2\u0006\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/pubnub/internal/endpoints/FetchMessagesEndpoint$Companion;", "", "<init>", "()V", "SINGLE_CHANNEL_DEFAULT_MESSAGES", "", "SINGLE_CHANNEL_MAX_MESSAGES", "MULTIPLE_CHANNEL_DEFAULT_MESSAGES", "MULTIPLE_CHANNEL_MAX_MESSAGES", "DEFAULT_MESSAGES_WITH_ACTIONS", "MAX_MESSAGES_WITH_ACTIONS", "INCLUDE_MESSAGE_TYPE_QUERY_PARAM", "", "INCLUDE_CUSTOM_MESSAGE_TYPE", "effectiveMax", "maximumPerChannel", "includeMessageActions", "", "numberOfChannels", "effectiveMax$pubnub_kotlin_impl", "(Ljava/lang/Integer;ZI)I", "pubnub-kotlin-impl"})
    public static final class Companion {
        private Companion() {
        }

        public final int effectiveMax$pubnub_kotlin_impl(@Nullable Integer maximumPerChannel, boolean includeMessageActions, int numberOfChannels) {
            Integer n;
            Integer n2;
            Integer n3;
            return includeMessageActions ? ((n3 = maximumPerChannel) != null && (n3 = IntKt.nonPositiveToNull(IntKt.limit(n3, 25))) != null ? n3 : 25) : (numberOfChannels == 1 ? ((n2 = maximumPerChannel) != null && (n2 = IntKt.nonPositiveToNull(IntKt.limit(n2, 100))) != null ? n2 : 100) : ((n = maximumPerChannel) != null && (n = IntKt.nonPositiveToNull(IntKt.limit(n, 25))) != null ? n : 25));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

