/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.endpoints.access;

import com.pubnub.api.PubNubError;
import com.pubnub.api.PubNubException;
import com.pubnub.api.endpoints.access.GrantToken;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.models.consumer.access_manager.v3.ChannelGrant;
import com.pubnub.api.models.consumer.access_manager.v3.ChannelGroupGrant;
import com.pubnub.api.models.consumer.access_manager.v3.PNGrantTokenResult;
import com.pubnub.api.models.consumer.access_manager.v3.UUIDGrant;
import com.pubnub.api.retry.RetryableEndpointGroup;
import com.pubnub.api.v2.PNConfiguration;
import com.pubnub.internal.EndpointCore;
import com.pubnub.internal.PubNubImpl;
import com.pubnub.internal.models.server.access_manager.v3.GrantTokenRequestBody;
import com.pubnub.internal.models.server.access_manager.v3.GrantTokenResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Call;
import retrofit2.Response;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u00020\u0004BU\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u0012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u000e\u0012\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u000e\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\f0\u000eH\u0014J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\f0\u000eH\u0014J\b\u0010\u001a\u001a\u00020\u001bH\u0014J2\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00020\u001d2\"\u0010\u001e\u001a\u001e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u001fj\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f` H\u0014J\u0016\u0010!\u001a\u00020\u00032\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00020#H\u0014J\b\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020'H\u0014J\b\u0010(\u001a\u00020)H\u0014R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/pubnub/internal/endpoints/access/GrantTokenEndpoint;", "Lcom/pubnub/internal/EndpointCore;", "Lcom/pubnub/internal/models/server/access_manager/v3/GrantTokenResponse;", "Lcom/pubnub/api/models/consumer/access_manager/v3/PNGrantTokenResult;", "Lcom/pubnub/api/endpoints/access/GrantToken;", "pubnub", "Lcom/pubnub/internal/PubNubImpl;", "ttl", "", "meta", "", "authorizedUUID", "", "channels", "", "Lcom/pubnub/api/models/consumer/access_manager/v3/ChannelGrant;", "channelGroups", "Lcom/pubnub/api/models/consumer/access_manager/v3/ChannelGroupGrant;", "uuids", "Lcom/pubnub/api/models/consumer/access_manager/v3/UUIDGrant;", "<init>", "(Lcom/pubnub/internal/PubNubImpl;ILjava/lang/Object;Ljava/lang/String;Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "getTtl", "()I", "getAffectedChannels", "getAffectedChannelGroups", "validateParams", "", "doWork", "Lretrofit2/Call;", "queryParams", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "createResponse", "input", "Lretrofit2/Response;", "operationType", "Lcom/pubnub/api/enums/PNOperationType;", "isAuthRequired", "", "getEndpointGroupName", "Lcom/pubnub/api/retry/RetryableEndpointGroup;", "pubnub-kotlin-impl"})
@SourceDebugExtension(value={"SMAP\nGrantTokenEndpoint.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GrantTokenEndpoint.kt\ncom/pubnub/internal/endpoints/access/GrantTokenEndpoint\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,73:1\n1557#2:74\n1628#2,3:75\n1557#2:78\n1628#2,3:79\n1#3:82\n*S KotlinDebug\n*F\n+ 1 GrantTokenEndpoint.kt\ncom/pubnub/internal/endpoints/access/GrantTokenEndpoint\n*L\n29#1:74\n29#1:75,3\n31#1:78\n31#1:79,3\n*E\n"})
public final class GrantTokenEndpoint
extends EndpointCore<GrantTokenResponse, PNGrantTokenResult>
implements GrantToken {
    private final int ttl;
    @Nullable
    private final Object meta;
    @Nullable
    private final String authorizedUUID;
    @NotNull
    private final List<ChannelGrant> channels;
    @NotNull
    private final List<ChannelGroupGrant> channelGroups;
    @NotNull
    private final List<UUIDGrant> uuids;

    public GrantTokenEndpoint(@NotNull PubNubImpl pubnub, int ttl, @Nullable Object meta, @Nullable String authorizedUUID, @NotNull List<? extends ChannelGrant> channels, @NotNull List<? extends ChannelGroupGrant> channelGroups, @NotNull List<? extends UUIDGrant> uuids) {
        Intrinsics.checkNotNullParameter((Object)pubnub, (String)"pubnub");
        Intrinsics.checkNotNullParameter(channels, (String)"channels");
        Intrinsics.checkNotNullParameter(channelGroups, (String)"channelGroups");
        Intrinsics.checkNotNullParameter(uuids, (String)"uuids");
        super(pubnub);
        this.ttl = ttl;
        this.meta = meta;
        this.authorizedUUID = authorizedUUID;
        this.channels = channels;
        this.channelGroups = channelGroups;
        this.uuids = uuids;
    }

    public int getTtl() {
        return this.ttl;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected List<String> getAffectedChannels() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.channels;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ChannelGrant channelGrant = (ChannelGrant)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected List<String> getAffectedChannelGroups() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.channelGroups;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ChannelGroupGrant channelGroupGrant = (ChannelGroupGrant)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        return (List)destination$iv$iv;
    }

    @Override
    protected void validateParams() {
        if (!PNConfiguration.Companion.isValid(this.getPubnub().getConfiguration().getSecretKey())) {
            throw new PubNubException(PubNubError.SECRET_KEY_MISSING, null, 2, null);
        }
        if (!PNConfiguration.Companion.isValid(this.getConfiguration().getSubscribeKey())) {
            throw new PubNubException(PubNubError.SUBSCRIBE_KEY_MISSING, null, 2, null);
        }
        if (CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)this.channels, (Iterable)this.channelGroups), (Iterable)this.uuids).isEmpty()) {
            PubNubError pubNubError = PubNubError.RESOURCES_MISSING;
            throw new PubNubException("At least one grant required", pubNubError, null, 0, null, null, null, null, null, null, null, 2044, null);
        }
    }

    @Override
    @NotNull
    protected Call<GrantTokenResponse> doWork(@NotNull HashMap<String, String> queryParams) {
        Intrinsics.checkNotNullParameter(queryParams, (String)"queryParams");
        GrantTokenRequestBody requestBody = GrantTokenRequestBody.Companion.of(this.getTtl(), this.channels, this.channelGroups, this.uuids, this.meta, this.authorizedUUID);
        return this.getRetrofitManager().getAccessManagerService$pubnub_kotlin_impl().grantToken(this.getConfiguration().getSubscribeKey(), requestBody, (Map<String, String>)queryParams);
    }

    @Override
    @NotNull
    protected PNGrantTokenResult createResponse(@NotNull Response<GrantTokenResponse> input) {
        Intrinsics.checkNotNullParameter(input, (String)"input");
        Object object = input.body();
        Intrinsics.checkNotNull((Object)object);
        String it = ((GrantTokenResponse)object).getData().getToken();
        boolean bl = false;
        return new PNGrantTokenResult(it);
    }

    @NotNull
    public PNOperationType operationType() {
        return (PNOperationType)PNOperationType.PNAccessManagerGrantToken.INSTANCE;
    }

    @Override
    protected boolean isAuthRequired() {
        return false;
    }

    @Override
    @NotNull
    protected RetryableEndpointGroup getEndpointGroupName() {
        return RetryableEndpointGroup.ACCESS_MANAGER;
    }
}

