/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.endpoints.access;

import com.pubnub.api.PubNubError;
import com.pubnub.api.PubNubException;
import com.pubnub.api.endpoints.access.RevokeToken;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.retry.RetryableEndpointGroup;
import com.pubnub.api.v2.PNConfiguration;
import com.pubnub.internal.EndpointCore;
import com.pubnub.internal.PubNubImpl;
import com.pubnub.internal.models.server.access_manager.v3.RevokeTokenResponse;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import retrofit2.Call;
import retrofit2.Response;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u00020\u0004B\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u000b\u001a\u00020\u0003H\u0014J2\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\r2\"\u0010\u000e\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u000fj\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b`\u0010H\u0014J\u0016\u0010\u0011\u001a\u00020\u00032\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u0013H\u0014J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0014J\b\u0010\u0018\u001a\u00020\u0019H\u0014J\u0010\u0010\u001a\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/pubnub/internal/endpoints/access/RevokeTokenEndpoint;", "Lcom/pubnub/internal/EndpointCore;", "Lcom/pubnub/internal/models/server/access_manager/v3/RevokeTokenResponse;", "", "Lcom/pubnub/api/endpoints/access/RevokeToken;", "pubnub", "Lcom/pubnub/internal/PubNubImpl;", "token", "", "<init>", "(Lcom/pubnub/internal/PubNubImpl;Ljava/lang/String;)V", "validateParams", "doWork", "Lretrofit2/Call;", "queryParams", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "createResponse", "input", "Lretrofit2/Response;", "operationType", "Lcom/pubnub/api/enums/PNOperationType;", "isAuthRequired", "", "getEndpointGroupName", "Lcom/pubnub/api/retry/RetryableEndpointGroup;", "repairEncoding", "pubnub-kotlin-impl"})
public final class RevokeTokenEndpoint
extends EndpointCore<RevokeTokenResponse, Unit>
implements RevokeToken {
    @NotNull
    private final String token;

    public RevokeTokenEndpoint(@NotNull PubNubImpl pubnub, @NotNull String token) {
        Intrinsics.checkNotNullParameter((Object)pubnub, (String)"pubnub");
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        super(pubnub);
        this.token = token;
    }

    @Override
    protected void validateParams() {
        super.validateParams();
        if (!PNConfiguration.Companion.isValid(this.getPubnub().getConfiguration().getSecretKey())) {
            throw new PubNubException(PubNubError.SECRET_KEY_MISSING, null, 2, null);
        }
        if (StringsKt.isBlank((CharSequence)this.token)) {
            throw new PubNubException(PubNubError.TOKEN_MISSING, null, 2, null);
        }
    }

    @Override
    @NotNull
    protected Call<RevokeTokenResponse> doWork(@NotNull HashMap<String, String> queryParams) {
        Intrinsics.checkNotNullParameter(queryParams, (String)"queryParams");
        return this.getRetrofitManager().getAccessManagerService$pubnub_kotlin_impl().revokeToken(this.getConfiguration().getSubscribeKey(), this.repairEncoding(this.token), (Map<String, String>)queryParams);
    }

    @Override
    protected void createResponse(@NotNull Response<RevokeTokenResponse> input) {
        Intrinsics.checkNotNullParameter(input, (String)"input");
    }

    @NotNull
    public PNOperationType operationType() {
        return (PNOperationType)PNOperationType.PNAccessManagerRevokeToken.INSTANCE;
    }

    @Override
    protected boolean isAuthRequired() {
        return false;
    }

    @Override
    @NotNull
    protected RetryableEndpointGroup getEndpointGroupName() {
        return RetryableEndpointGroup.ACCESS_MANAGER;
    }

    private final String repairEncoding(String token) {
        String string = URLEncoder.encode(token, "utf-8");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encode(...)");
        return StringsKt.replace$default((String)string, (String)"+", (String)"%20", (boolean)false, (int)4, null);
    }
}

