/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.endpoints.presence;

import com.google.gson.JsonElement;
import com.pubnub.api.PubNubError;
import com.pubnub.api.PubNubException;
import com.pubnub.api.endpoints.presence.GetState;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.models.consumer.presence.PNGetStateResult;
import com.pubnub.api.retry.RetryableEndpointGroup;
import com.pubnub.internal.EndpointCore;
import com.pubnub.internal.PubNubImpl;
import com.pubnub.internal.PubNubUtilKt;
import com.pubnub.internal.managers.MapperManager;
import com.pubnub.internal.models.server.Envelope;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import retrofit2.Call;
import retrofit2.Response;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\u0018\u00002\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0004\u0012\u00020\u00040\u00012\u00020\u0005B7\b\u0000\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\b\b\u0002\u0010\f\u001a\u00020\n\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0014J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0014J\b\u0010\u0016\u001a\u00020\u0017H\u0014J8\u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u00192\"\u0010\u001a\u001a\u001e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u001bj\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n`\u001cH\u0014J\u001c\u0010\u001d\u001a\u00020\u00042\u0012\u0010\u001e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u001fH\u0014J\b\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020#H\u0014J\u001c\u0010$\u001a\u00020\u00172\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0%H\u0002R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0014\u0010\f\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006&"}, d2={"Lcom/pubnub/internal/endpoints/presence/GetStateEndpoint;", "Lcom/pubnub/internal/EndpointCore;", "Lcom/pubnub/internal/models/server/Envelope;", "Lcom/google/gson/JsonElement;", "Lcom/pubnub/api/models/consumer/presence/PNGetStateResult;", "Lcom/pubnub/api/endpoints/presence/GetState;", "pubnub", "Lcom/pubnub/internal/PubNubImpl;", "channels", "", "", "channelGroups", "uuid", "<init>", "(Lcom/pubnub/internal/PubNubImpl;Ljava/util/List;Ljava/util/List;Ljava/lang/String;)V", "getChannels", "()Ljava/util/List;", "getChannelGroups", "getUuid", "()Ljava/lang/String;", "getAffectedChannels", "getAffectedChannelGroups", "validateParams", "", "doWork", "Lretrofit2/Call;", "queryParams", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "createResponse", "input", "Lretrofit2/Response;", "operationType", "Lcom/pubnub/api/enums/PNOperationType$PNGetState;", "getEndpointGroupName", "Lcom/pubnub/api/retry/RetryableEndpointGroup;", "addQueryParams", "", "pubnub-kotlin-impl"})
public final class GetStateEndpoint
extends EndpointCore<Envelope<JsonElement>, PNGetStateResult>
implements GetState {
    @NotNull
    private final List<String> channels;
    @NotNull
    private final List<String> channelGroups;
    @NotNull
    private final String uuid;

    public GetStateEndpoint(@NotNull PubNubImpl pubnub, @NotNull List<String> channels, @NotNull List<String> channelGroups, @NotNull String uuid) {
        Intrinsics.checkNotNullParameter((Object)pubnub, (String)"pubnub");
        Intrinsics.checkNotNullParameter(channels, (String)"channels");
        Intrinsics.checkNotNullParameter(channelGroups, (String)"channelGroups");
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        super(pubnub);
        this.channels = channels;
        this.channelGroups = channelGroups;
        this.uuid = uuid;
    }

    public /* synthetic */ GetStateEndpoint(PubNubImpl pubNubImpl, List list, List list2, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            string = pubNubImpl.getConfiguration().getUserId().getValue();
        }
        this(pubNubImpl, list, list2, string);
    }

    @NotNull
    public List<String> getChannels() {
        return this.channels;
    }

    @NotNull
    public List<String> getChannelGroups() {
        return this.channelGroups;
    }

    @NotNull
    public String getUuid() {
        return this.uuid;
    }

    @Override
    @NotNull
    protected List<String> getAffectedChannels() {
        return this.getChannels();
    }

    @Override
    @NotNull
    protected List<String> getAffectedChannelGroups() {
        return this.getChannelGroups();
    }

    @Override
    protected void validateParams() {
        super.validateParams();
        if (this.getChannels().isEmpty() && this.getChannelGroups().isEmpty()) {
            throw new PubNubException(PubNubError.CHANNEL_AND_GROUP_MISSING, null, 2, null);
        }
    }

    @Override
    @NotNull
    protected Call<Envelope<JsonElement>> doWork(@NotNull HashMap<String, String> queryParams) {
        Intrinsics.checkNotNullParameter(queryParams, (String)"queryParams");
        this.addQueryParams((Map<String, String>)queryParams);
        return this.getRetrofitManager().getPresenceService$pubnub_kotlin_impl().getState(this.getConfiguration().getSubscribeKey(), PubNubUtilKt.toCsv(this.getChannels()), this.getUuid(), (Map<String, String>)queryParams);
    }

    @Override
    @NotNull
    protected PNGetStateResult createResponse(@NotNull Response<Envelope<JsonElement>> input) {
        Intrinsics.checkNotNullParameter(input, (String)"input");
        HashMap stateMappings = new HashMap();
        if (this.getChannels().size() == 1 && this.getChannelGroups().isEmpty()) {
            Map map = stateMappings;
            Object object = CollectionsKt.first(this.getChannels());
            Object object2 = input.body();
            Intrinsics.checkNotNull((Object)object2);
            Object t = ((Envelope)object2).getPayload$pubnub_kotlin_impl();
            Intrinsics.checkNotNull(t);
            map.put(object, t);
        } else {
            MapperManager mapperManager = this.getPubnub().getMapper();
            Object object = input.body();
            Intrinsics.checkNotNull((Object)object);
            Object t = ((Envelope)object).getPayload$pubnub_kotlin_impl();
            Intrinsics.checkNotNull(t);
            Iterator<Map.Entry<String, JsonElement>> it = mapperManager.getObjectIterator((JsonElement)t);
            while (it.hasNext()) {
                Map.Entry<String, JsonElement> stateMapping = it.next();
                ((Map)stateMappings).put(stateMapping.getKey(), stateMapping.getValue());
            }
        }
        return new PNGetStateResult((Map)stateMappings);
    }

    @NotNull
    public PNOperationType.PNGetState operationType() {
        return PNOperationType.PNGetState.INSTANCE;
    }

    @Override
    @NotNull
    protected RetryableEndpointGroup getEndpointGroupName() {
        return RetryableEndpointGroup.PRESENCE;
    }

    private final void addQueryParams(Map<String, String> queryParams) {
        if (!((Collection)this.getChannelGroups()).isEmpty()) {
            queryParams.put("channel-group", PubNubUtilKt.toCsv(this.getChannelGroups()));
        }
    }
}

