/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.eventengine;

import com.pubnub.internal.eventengine.Cancel;
import com.pubnub.internal.eventengine.Effect;
import com.pubnub.internal.eventengine.EffectFactory;
import com.pubnub.internal.eventengine.EffectInvocation;
import com.pubnub.internal.eventengine.EffectInvocationType;
import com.pubnub.internal.eventengine.Managed;
import com.pubnub.internal.eventengine.ManagedEffect;
import com.pubnub.internal.eventengine.NonManaged;
import com.pubnub.internal.eventengine.Source;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003BC\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\u0016\u001a\u00020\u0015J\u0017\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00028\u0000H\u0000\u00a2\u0006\u0004\b\u0019\u0010\u001aR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0013\u00a8\u0006\u001b"}, d2={"Lcom/pubnub/internal/eventengine/EffectDispatcher;", "T", "Lcom/pubnub/internal/eventengine/EffectInvocation;", "", "effectFactory", "Lcom/pubnub/internal/eventengine/EffectFactory;", "effectSource", "Lcom/pubnub/internal/eventengine/Source;", "managedEffects", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/pubnub/internal/eventengine/ManagedEffect;", "executorService", "Ljava/util/concurrent/ExecutorService;", "<init>", "(Lcom/pubnub/internal/eventengine/EffectFactory;Lcom/pubnub/internal/eventengine/Source;Ljava/util/concurrent/ConcurrentHashMap;Ljava/util/concurrent/ExecutorService;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "start", "", "stop", "dispatch", "effectInvocation", "dispatch$pubnub_kotlin_impl", "(Lcom/pubnub/internal/eventengine/EffectInvocation;)V", "pubnub-kotlin-impl"})
public final class EffectDispatcher<T extends EffectInvocation> {
    @NotNull
    private final EffectFactory<T> effectFactory;
    @NotNull
    private final Source<T> effectSource;
    @NotNull
    private final ConcurrentHashMap<String, ManagedEffect> managedEffects;
    @NotNull
    private final ExecutorService executorService;
    private final Logger log;

    public EffectDispatcher(@NotNull EffectFactory<T> effectFactory, @NotNull Source<T> effectSource, @NotNull ConcurrentHashMap<String, ManagedEffect> managedEffects, @NotNull ExecutorService executorService) {
        Intrinsics.checkNotNullParameter(effectFactory, (String)"effectFactory");
        Intrinsics.checkNotNullParameter(effectSource, (String)"effectSource");
        Intrinsics.checkNotNullParameter(managedEffects, (String)"managedEffects");
        Intrinsics.checkNotNullParameter((Object)executorService, (String)"executorService");
        this.effectFactory = effectFactory;
        this.effectSource = effectSource;
        this.managedEffects = managedEffects;
        this.executorService = executorService;
        this.log = LoggerFactory.getLogger(EffectDispatcher.class);
    }

    public /* synthetic */ EffectDispatcher(EffectFactory effectFactory, Source source, ConcurrentHashMap concurrentHashMap, ExecutorService executorService, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            concurrentHashMap = new ConcurrentHashMap<String, ManagedEffect>();
        }
        if ((n & 8) != 0) {
            executorService = Executors.newSingleThreadExecutor();
        }
        this(effectFactory, source, concurrentHashMap, executorService);
    }

    public final void start() {
        this.executorService.submit(() -> EffectDispatcher.start$lambda$0(this));
    }

    public final void stop() {
        this.executorService.shutdownNow();
    }

    public final void dispatch$pubnub_kotlin_impl(@NotNull T effectInvocation) {
        Intrinsics.checkNotNullParameter(effectInvocation, (String)"effectInvocation");
        this.log.trace("Dispatching effect: " + effectInvocation);
        EffectInvocationType type = effectInvocation.getType();
        if (type instanceof Cancel) {
            ManagedEffect managedEffect = this.managedEffects.remove(((Cancel)type).getIdToCancel());
            if (managedEffect != null) {
                managedEffect.cancel();
            }
        } else if (type instanceof Managed) {
            ManagedEffect managedEffect = this.managedEffects.remove(effectInvocation.getId());
            if (managedEffect != null) {
                managedEffect.cancel();
            }
            Effect effect = this.effectFactory.create(effectInvocation);
            ManagedEffect managedEffect2 = effect instanceof ManagedEffect ? (ManagedEffect)effect : null;
            if (managedEffect2 == null) {
                return;
            }
            ManagedEffect managedEffect3 = managedEffect2;
            ((Map)this.managedEffects).put(effectInvocation.getId(), managedEffect3);
            managedEffect3.runEffect();
        } else if (type instanceof NonManaged) {
            Effect effect = this.effectFactory.create(effectInvocation);
            if (effect != null) {
                effect.runEffect();
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    private static final void start$lambda$0(EffectDispatcher this$0) {
        try {
            while (true) {
                EffectInvocation invocation = (EffectInvocation)this$0.effectSource.take();
                this$0.dispatch$pubnub_kotlin_impl(invocation);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return;
        }
    }
}

