/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.managers;

import com.pubnub.api.v2.PNConfiguration;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\f\u001a\u00020\nJ\b\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/pubnub/internal/managers/BasePathManager;", "", "config", "Lcom/pubnub/api/v2/PNConfiguration;", "<init>", "(Lcom/pubnub/api/v2/PNConfiguration;)V", "currentSubdomain", "", "MAX_SUBDOMAIN", "DEFAULT_SUBDOMAIN", "", "DEFAULT_BASE_PATH", "basePath", "incrementSubdomain", "", "pubnub-kotlin-impl"})
public final class BasePathManager {
    @NotNull
    private final PNConfiguration config;
    private int currentSubdomain;
    private final int MAX_SUBDOMAIN;
    @NotNull
    private final String DEFAULT_SUBDOMAIN;
    @NotNull
    private final String DEFAULT_BASE_PATH;

    public BasePathManager(@NotNull PNConfiguration config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
        this.currentSubdomain = 1;
        this.MAX_SUBDOMAIN = 20;
        this.DEFAULT_SUBDOMAIN = "ps";
        this.DEFAULT_BASE_PATH = "pndsn.com";
    }

    @NotNull
    public final String basePath() {
        StringBuilder stringBuilder;
        StringBuilder basePathBuilder = new StringBuilder("http").append(this.config.getSecure() ? "s" : "").append("://");
        if (PNConfiguration.Companion.isValid(this.config.getOrigin())) {
            stringBuilder = basePathBuilder.append(this.config.getOrigin());
        } else if (this.config.getCacheBusting()) {
            basePathBuilder.append("ps").append(this.currentSubdomain).append(".").append(this.DEFAULT_BASE_PATH);
            this.incrementSubdomain();
            stringBuilder = Unit.INSTANCE;
        } else {
            stringBuilder = basePathBuilder.append(this.DEFAULT_SUBDOMAIN).append(".").append(this.DEFAULT_BASE_PATH);
        }
        String string = basePathBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final void incrementSubdomain() {
        if (this.currentSubdomain == this.MAX_SUBDOMAIN) {
            this.currentSubdomain = 1;
        } else {
            int n = this.currentSubdomain;
            this.currentSubdomain = n + 1;
        }
    }
}

