/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.subscribe.eventengine.effect;

import com.pubnub.api.models.consumer.pubsub.PNEvent;
import com.pubnub.api.models.consumer.pubsub.PNMessageResult;
import com.pubnub.api.models.consumer.pubsub.PNPresenceEventResult;
import com.pubnub.api.models.consumer.pubsub.PNSignalResult;
import com.pubnub.api.models.consumer.pubsub.files.PNFileEventResult;
import com.pubnub.api.models.consumer.pubsub.message_actions.PNMessageActionResult;
import com.pubnub.api.models.consumer.pubsub.objects.PNObjectEventResult;
import com.pubnub.internal.eventengine.Effect;
import com.pubnub.internal.subscribe.eventengine.effect.MessagesConsumer;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\f\u00a8\u0006\u000f"}, d2={"Lcom/pubnub/internal/subscribe/eventengine/effect/EmitMessagesEffect;", "Lcom/pubnub/internal/eventengine/Effect;", "messagesConsumer", "Lcom/pubnub/internal/subscribe/eventengine/effect/MessagesConsumer;", "messages", "", "Lcom/pubnub/api/models/consumer/pubsub/PNEvent;", "<init>", "(Lcom/pubnub/internal/subscribe/eventengine/effect/MessagesConsumer;Ljava/util/List;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "runEffect", "", "pubnub-kotlin-impl"})
public final class EmitMessagesEffect
implements Effect {
    @NotNull
    private final MessagesConsumer messagesConsumer;
    @NotNull
    private final List<PNEvent> messages;
    private final Logger log;

    public EmitMessagesEffect(@NotNull MessagesConsumer messagesConsumer, @NotNull List<? extends PNEvent> messages) {
        Intrinsics.checkNotNullParameter((Object)messagesConsumer, (String)"messagesConsumer");
        Intrinsics.checkNotNullParameter(messages, (String)"messages");
        this.messagesConsumer = messagesConsumer;
        this.messages = messages;
        this.log = LoggerFactory.getLogger(EmitMessagesEffect.class);
    }

    @Override
    public void runEffect() {
        this.log.trace("Running EmitMessagesEffect");
        for (PNEvent message : this.messages) {
            try {
                PNEvent pNEvent = message;
                if (pNEvent instanceof PNMessageResult) {
                    this.messagesConsumer.announce((PNMessageResult)message);
                    continue;
                }
                if (pNEvent instanceof PNPresenceEventResult) {
                    this.messagesConsumer.announce((PNPresenceEventResult)message);
                    continue;
                }
                if (pNEvent instanceof PNSignalResult) {
                    this.messagesConsumer.announce((PNSignalResult)message);
                    continue;
                }
                if (pNEvent instanceof PNMessageActionResult) {
                    this.messagesConsumer.announce((PNMessageActionResult)message);
                    continue;
                }
                if (pNEvent instanceof PNObjectEventResult) {
                    this.messagesConsumer.announce((PNObjectEventResult)message);
                    continue;
                }
                if (!(pNEvent instanceof PNFileEventResult)) continue;
                this.messagesConsumer.announce((PNFileEventResult)message);
            }
            catch (Throwable throwable) {}
        }
    }
}

