/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.crypto.cryptor;

import com.pubnub.api.PubNubError;
import com.pubnub.api.PubNubException;
import com.pubnub.api.crypto.cryptor.Cryptor;
import com.pubnub.api.crypto.data.EncryptedData;
import com.pubnub.api.crypto.data.EncryptedStreamData;
import com.pubnub.internal.crypto.CryptoModuleImplKt;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.security.Key;
import java.security.MessageDigest;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bH\u0016J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\rH\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u0012H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u000bH\u0002J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010\u001d\u001a\u00020\tH\u0002J\b\u0010\u001e\u001a\u00020\u000bH\u0002J\u0010\u0010\u001f\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020\u000bH\u0002J\u0010\u0010!\u001a\u00020\"2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/pubnub/internal/crypto/cryptor/AesCbcCryptor;", "Lcom/pubnub/api/crypto/cryptor/Cryptor;", "cipherKey", "", "<init>", "(Ljava/lang/String;)V", "getCipherKey", "()Ljava/lang/String;", "newKey", "Ljavax/crypto/spec/SecretKeySpec;", "id", "", "encrypt", "Lcom/pubnub/api/crypto/data/EncryptedData;", "data", "decrypt", "encryptedData", "encryptStream", "Lcom/pubnub/api/crypto/data/EncryptedStreamData;", "stream", "Ljava/io/InputStream;", "decryptStream", "validateData", "", "createInitializedCipher", "Ljavax/crypto/Cipher;", "iv", "mode", "", "createNewKey", "createRandomIv", "sha256", "input", "validateInputStreamAndReturnBuffered", "Ljava/io/BufferedInputStream;", "pubnub-kotlin-impl"})
@SourceDebugExtension(value={"SMAP\nAesCbcCryptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AesCbcCryptor.kt\ncom/pubnub/internal/crypto/cryptor/AesCbcCryptor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,133:1\n1#2:134\n*E\n"})
public final class AesCbcCryptor
implements Cryptor {
    @NotNull
    private final String cipherKey;
    @NotNull
    private final SecretKeySpec newKey;

    public AesCbcCryptor(@NotNull String cipherKey) {
        Intrinsics.checkNotNullParameter((Object)cipherKey, (String)"cipherKey");
        this.cipherKey = cipherKey;
        this.newKey = this.createNewKey();
    }

    @NotNull
    public final String getCipherKey() {
        return this.cipherKey;
    }

    @NotNull
    public byte[] id() {
        byte[] byArray = new byte[]{65, 67, 82, 72};
        return byArray;
    }

    @NotNull
    public EncryptedData encrypt(@NotNull byte[] data) {
        EncryptedData encryptedData;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.validateData(data);
        try {
            byte[] ivBytes = this.createRandomIv();
            Cipher cipher = this.createInitializedCipher(ivBytes, 1);
            byte[] byArray = cipher.doFinal(data);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"doFinal(...)");
            byte[] encryptedData2 = byArray;
            encryptedData = new EncryptedData(ivBytes, encryptedData2);
        }
        catch (Exception e) {
            throw new PubNubException(e.getMessage(), PubNubError.CRYPTO_ERROR, null, 0, null, null, null, null, null, null, null, 2044, null);
        }
        return encryptedData;
    }

    @NotNull
    public byte[] decrypt(@NotNull EncryptedData encryptedData) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)encryptedData, (String)"encryptedData");
        this.validateData(encryptedData.getData());
        try {
            byte[] decryptedData;
            byte[] byArray2;
            block5: {
                block4: {
                    byte[] byArray3;
                    byArray2 = encryptedData.getMetadata();
                    if (byArray2 == null) break block4;
                    byte[] it = byArray3 = byArray2;
                    boolean bl = false;
                    byArray2 = (byte[])(it.length == 16 ? byArray3 : null);
                    if (byArray2 != null) break block5;
                }
                throw new PubNubException("Invalid random IV", PubNubError.CRYPTO_ERROR, null, 0, null, null, null, null, null, null, null, 2044, null);
            }
            byte[] ivBytes = byArray2;
            Cipher cipher = this.createInitializedCipher(ivBytes, 2);
            byArray = decryptedData = cipher.doFinal(encryptedData.getData());
            Intrinsics.checkNotNull((Object)byArray);
        }
        catch (Exception e) {
            throw new PubNubException(e.getMessage(), PubNubError.CRYPTO_ERROR, null, 0, null, null, null, null, null, null, null, 2044, null);
        }
        return byArray;
    }

    @NotNull
    public EncryptedStreamData encryptStream(@NotNull InputStream stream) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        BufferedInputStream bufferedInputStream = this.validateInputStreamAndReturnBuffered(stream);
        try {
            byte[] ivBytes = this.createRandomIv();
            Cipher cipher = this.createInitializedCipher(ivBytes, 1);
            CipherInputStream cipheredStream = new CipherInputStream(bufferedInputStream, cipher);
            return new EncryptedStreamData(ivBytes, (InputStream)cipheredStream);
        }
        catch (Exception e) {
            throw new PubNubException(e.getMessage(), PubNubError.CRYPTO_ERROR, null, 0, null, null, null, null, null, null, null, 2044, null);
        }
    }

    @NotNull
    public InputStream decryptStream(@NotNull EncryptedStreamData encryptedData) {
        Intrinsics.checkNotNullParameter((Object)encryptedData, (String)"encryptedData");
        BufferedInputStream bufferedInputStream = this.validateInputStreamAndReturnBuffered(encryptedData.getStream());
        try {
            byte[] byArray;
            block5: {
                block4: {
                    byte[] byArray2;
                    byArray = encryptedData.getMetadata();
                    if (byArray == null) break block4;
                    byte[] it = byArray2 = byArray;
                    boolean bl = false;
                    byArray = (byte[])(it.length == 16 ? byArray2 : null);
                    if (byArray != null) break block5;
                }
                throw new PubNubException("Invalid random IV", PubNubError.CRYPTO_ERROR, null, 0, null, null, null, null, null, null, null, 2044, null);
            }
            byte[] ivBytes = byArray;
            Cipher cipher = this.createInitializedCipher(ivBytes, 2);
            return new CipherInputStream(bufferedInputStream, cipher);
        }
        catch (Exception e) {
            throw new PubNubException(e.getMessage(), PubNubError.CRYPTO_ERROR, null, 0, null, null, null, null, null, null, null, 2044, null);
        }
    }

    private final void validateData(byte[] data) {
        if (data.length == 0) {
            throw new PubNubException("Encryption/Decryption of empty data not allowed.", PubNubError.ENCRYPTION_AND_DECRYPTION_OF_EMPTY_DATA_NOT_ALLOWED, null, 0, null, null, null, null, null, null, null, 2044, null);
        }
    }

    private final Cipher createInitializedCipher(byte[] iv, int mode) {
        Cipher cipher;
        Cipher it = cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        boolean bl = false;
        it.init(mode, (Key)this.newKey, new IvParameterSpec(iv));
        Cipher cipher2 = cipher;
        Intrinsics.checkNotNullExpressionValue((Object)cipher2, (String)"also(...)");
        return cipher2;
    }

    private final SecretKeySpec createNewKey() {
        byte[] byArray = this.cipherKey.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] keyBytes = this.sha256(byArray);
        return new SecretKeySpec(keyBytes, "AES");
    }

    private final byte[] createRandomIv() {
        byte[] ivBytes = new byte[16];
        new SecureRandom().nextBytes(ivBytes);
        return ivBytes;
    }

    private final byte[] sha256(byte[] input) {
        byte[] byArray;
        MessageDigest digest = null;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            Intrinsics.checkNotNullExpressionValue((Object)messageDigest, (String)"getInstance(...)");
            digest = messageDigest;
            byArray = digest.digest(input);
            Intrinsics.checkNotNull((Object)byArray);
        }
        catch (Exception e) {
            throw new PubNubException(e.getMessage(), PubNubError.CRYPTO_ERROR, null, 0, null, null, null, null, null, null, null, 2044, null);
        }
        return byArray;
    }

    private final BufferedInputStream validateInputStreamAndReturnBuffered(InputStream stream) {
        InputStream inputStream = stream;
        int n = 8192;
        BufferedInputStream bufferedInputStream = inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream, n);
        CryptoModuleImplKt.checkMinSize(bufferedInputStream, 1, (Function1<? super Integer, Unit>)((Function1)AesCbcCryptor::validateInputStreamAndReturnBuffered$lambda$3));
        return bufferedInputStream;
    }

    private static final Unit validateInputStreamAndReturnBuffered$lambda$3(int it) {
        throw new PubNubException("Encryption/Decryption of empty data not allowed.", PubNubError.ENCRYPTION_AND_DECRYPTION_OF_EMPTY_DATA_NOT_ALLOWED, null, 0, null, null, null, null, null, null, null, 2044, null);
    }
}

