/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.crypto.cryptor;

import com.pubnub.api.PubNubError;
import com.pubnub.api.PubNubException;
import com.pubnub.api.logging.LogConfig;
import com.pubnub.api.logging.LogMessage;
import com.pubnub.api.logging.LogMessageContent;
import com.pubnub.internal.crypto.CryptoModuleImplKt;
import com.pubnub.internal.crypto.cryptor.CryptorHeader;
import com.pubnub.internal.crypto.cryptor.CryptorHeaderVersion;
import com.pubnub.internal.crypto.cryptor.HeaderParserKt;
import com.pubnub.internal.crypto.cryptor.ParseResult;
import com.pubnub.internal.logging.LoggerManager;
import com.pubnub.internal.logging.PNLogger;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.UByte;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0005\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0016\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u000b2\u0006\u0010\u0014\u001a\u00020\u0010J\u0018\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00102\b\u0010\u0017\u001a\u0004\u0018\u00010\u0010J\b\u0010\u0018\u001a\u00020\u0019H\u0002J$\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130\u001b2\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u0019H\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0014\u001a\u00020\u0010H\u0002J\u0010\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!H\u0002J\u0018\u0010\"\u001a\u00020\u00132\u0006\u0010#\u001a\u00020\u00192\u0006\u0010$\u001a\u00020\u0019H\u0002J\u0010\u0010%\u001a\u00020\u00102\u0006\u0010&\u001a\u00020\u0013H\u0002R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/pubnub/internal/crypto/cryptor/HeaderParser;", "", "logConfig", "Lcom/pubnub/api/logging/LogConfig;", "<init>", "(Lcom/pubnub/api/logging/LogConfig;)V", "getLogConfig", "()Lcom/pubnub/api/logging/LogConfig;", "log", "Lcom/pubnub/internal/logging/PNLogger;", "parseDataWithHeader", "Lcom/pubnub/internal/crypto/cryptor/ParseResult;", "Ljava/io/InputStream;", "stream", "Ljava/io/BufferedInputStream;", "readExactlyNBytez", "", "bufferedInputStream", "numberOfBytesToRead", "", "data", "createCryptorHeader", "cryptorId", "cryptorData", "getCurrentCryptoHeaderVersion", "", "getCryptorDataSizeAndStartingIndex", "Lkotlin/Pair;", "cryptorDataSizeFirstByte", "validateCryptorHeaderVersion", "", "logTraceMessage", "message", "", "convertTwoBytesToIntBigEndian", "byte1", "byte2", "writeNumberOnTwoBytes", "number", "pubnub-kotlin-impl"})
public final class HeaderParser {
    @Nullable
    private final LogConfig logConfig;
    @NotNull
    private final PNLogger log;

    /*
     * WARNING - void declaration
     */
    public HeaderParser(@Nullable LogConfig logConfig) {
        Object object;
        block3: {
            block2: {
                void it;
                this.logConfig = logConfig;
                HeaderParser headerParser = this;
                object = this.logConfig;
                if (object == null) break block2;
                LogConfig logConfig2 = object;
                HeaderParser headerParser2 = headerParser;
                boolean bl = false;
                PNLogger pNLogger = LoggerManager.Companion.getInstance().getLogger((LogConfig)it, this.getClass());
                headerParser = headerParser2;
                object = pNLogger;
                if (pNLogger != null) break block3;
            }
            object = LoggerManager.Companion.getInstance().getLogger(new LogConfig("default", "default", null, 4, null), this.getClass());
        }
        headerParser.log = object;
    }

    @Nullable
    public final LogConfig getLogConfig() {
        return this.logConfig;
    }

    @NotNull
    public final ParseResult<? extends InputStream> parseDataWithHeader(@NotNull BufferedInputStream stream) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        InputStream inputStream = stream;
        BufferedInputStream bufferedInputStream = (BufferedInputStream)inputStream;
        bufferedInputStream.mark(Integer.MAX_VALUE);
        byte[] possibleInitialHeader = new byte[10];
        int initiallyRead = bufferedInputStream.read(possibleInitialHeader);
        if (!Arrays.equals(ArraysKt.sliceArray((byte[])possibleInitialHeader, (IntRange)new IntRange(0, 3)), HeaderParserKt.access$getSENTINEL$p())) {
            bufferedInputStream.reset();
            return ParseResult.NoHeader.INSTANCE;
        }
        if (initiallyRead < 10) {
            throw new PubNubException("Minimal size of Cryptor Data Header is: 10", PubNubError.CRYPTOR_HEADER_PARSE_ERROR, null, 0, null, null, null, null, null, null, null, 2044, null);
        }
        this.validateCryptorHeaderVersion(possibleInitialHeader);
        byte[] cryptorId = ArraysKt.sliceArray((byte[])possibleInitialHeader, (IntRange)new IntRange(5, 8));
        byte cryptorDataSizeFirstByte = UByte.constructor-impl((byte)possibleInitialHeader[9]);
        if (cryptorDataSizeFirstByte == -1) {
            byte[] cryptorDataSizeBytes = this.readExactlyNBytez(bufferedInputStream, 2);
            int cryptorDataSize = this.convertTwoBytesToIntBigEndian(cryptorDataSizeBytes[0], cryptorDataSizeBytes[1]);
            byArray = this.readExactlyNBytez(bufferedInputStream, cryptorDataSize);
        } else {
            byArray = cryptorDataSizeFirstByte == 0 ? new byte[]{} : this.readExactlyNBytez(bufferedInputStream, cryptorDataSizeFirstByte & 0xFF);
        }
        byte[] cryptorData = byArray;
        return new ParseResult.Success<BufferedInputStream>(cryptorId, cryptorData, bufferedInputStream);
    }

    private final byte[] readExactlyNBytez(BufferedInputStream bufferedInputStream, int numberOfBytesToRead) {
        return CryptoModuleImplKt.readExactlyNBytez(bufferedInputStream, numberOfBytesToRead, (Function1<? super Integer, Unit>)((Function1)HeaderParser::readExactlyNBytez$lambda$1));
    }

    @NotNull
    public final ParseResult<? extends byte[]> parseDataWithHeader(@NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (data.length < HeaderParserKt.access$getSENTINEL$p().length) {
            return ParseResult.NoHeader.INSTANCE;
        }
        byte[] sentinel = ArraysKt.sliceArray((byte[])data, (IntRange)new IntRange(0, 3));
        if (!Arrays.equals(HeaderParserKt.access$getSENTINEL$p(), sentinel)) {
            return ParseResult.NoHeader.INSTANCE;
        }
        if (data.length < 10) {
            throw new PubNubException("Minimal size of encrypted data having Cryptor Data Header is: 10", PubNubError.CRYPTOR_DATA_HEADER_SIZE_TO_SMALL, null, 0, null, null, null, null, null, null, null, 2044, null);
        }
        this.validateCryptorHeaderVersion(data);
        byte[] cryptorId = ArraysKt.sliceArray((byte[])data, (IntRange)new IntRange(5, 8));
        this.logTraceMessage("CryptoId: " + new String(cryptorId, Charsets.UTF_8));
        byte cryptorDataSizeFirstByte = data[9];
        Pair<Integer, Integer> pair = this.getCryptorDataSizeAndStartingIndex(data, cryptorDataSizeFirstByte);
        int startingIndexOfCryptorData = ((Number)pair.component1()).intValue();
        int cryptorDataSize = ((Number)pair.component2()).intValue();
        if (startingIndexOfCryptorData + cryptorDataSize > data.length) {
            throw new PubNubException("Input data size: " + data.length + " is to small to fit header of size " + startingIndexOfCryptorData + " and cryptorData of size: " + cryptorDataSize, PubNubError.CRYPTOR_HEADER_PARSE_ERROR, null, 0, null, null, null, null, null, null, null, 2044, null);
        }
        byte[] cryptorData = ArraysKt.sliceArray((byte[])data, (IntRange)RangesKt.until((int)startingIndexOfCryptorData, (int)(startingIndexOfCryptorData + cryptorDataSize)));
        int sizeOfCryptorHeader = startingIndexOfCryptorData + cryptorDataSize;
        byte[] encryptedData = ArraysKt.sliceArray((byte[])data, (IntRange)RangesKt.until((int)sizeOfCryptorHeader, (int)data.length));
        return new ParseResult.Success<byte[]>(cryptorId, cryptorData, encryptedData);
    }

    @NotNull
    public final byte[] createCryptorHeader(@NotNull byte[] cryptorId, @Nullable byte[] cryptorData) {
        byte[] byArray;
        byte[] byArray2;
        int cryptorDataSize;
        Intrinsics.checkNotNullParameter((Object)cryptorId, (String)"cryptorId");
        byte[] sentinel = HeaderParserKt.access$getSENTINEL$p();
        byte cryptorHeaderVersion = this.getCurrentCryptoHeaderVersion();
        int n = cryptorDataSize = cryptorData != null ? cryptorData.length : 0;
        if (cryptorDataSize < (0xFFFFFFFF & 0xFF)) {
            byArray2 = new byte[]{(byte)cryptorDataSize};
            byArray = byArray2;
        } else if (cryptorDataSize < 65535) {
            byArray2 = new byte[]{(byte)cryptorDataSize};
            byArray = ArraysKt.plus((byte[])byArray2, (byte[])this.writeNumberOnTwoBytes(cryptorDataSize));
        } else {
            throw new PubNubException("Cryptor Data Size is: " + cryptorDataSize + " whereas max cryptor data size is: 65535", PubNubError.CRYPTOR_HEADER_PARSE_ERROR, null, 0, null, null, null, null, null, null, null, 2044, null);
        }
        byte[] finalCryptorDataSize = byArray;
        byte[] byArray3 = cryptorData;
        if (cryptorData == null) {
            byArray3 = new byte[]{};
        }
        CryptorHeader cryptorHeader = new CryptorHeader(sentinel, cryptorHeaderVersion, cryptorId, finalCryptorDataSize, byArray3);
        return cryptorHeader.toByteArray();
    }

    private final byte getCurrentCryptoHeaderVersion() {
        return (byte)CryptorHeaderVersion.One.getValue();
    }

    private final Pair<Integer, Integer> getCryptorDataSizeAndStartingIndex(byte[] data, byte cryptorDataSizeFirstByte) {
        int startingIndexOfCryptorData = 0;
        int cryptorDataSize = 0;
        byte cryptoDataFirstByteAsUByte = UByte.constructor-impl((byte)cryptorDataSizeFirstByte);
        if (cryptoDataFirstByteAsUByte == -1) {
            startingIndexOfCryptorData = 12;
            this.logTraceMessage("\"Cryptor data size\" first byte's value is 255 that mean that size is stored on two next bytes");
            byte cryptorDataSizeSecondByte = data[10];
            byte cryptorDataSizeThirdByte = data[11];
            cryptorDataSize = this.convertTwoBytesToIntBigEndian(cryptorDataSizeSecondByte, cryptorDataSizeThirdByte);
        } else {
            startingIndexOfCryptorData = 10;
            cryptorDataSize = cryptoDataFirstByteAsUByte & 0xFF;
            this.logTraceMessage("\"Cryptor data size\" is 1 byte long and its value is: " + cryptorDataSize);
        }
        return new Pair((Object)startingIndexOfCryptorData, (Object)cryptorDataSize);
    }

    private final void validateCryptorHeaderVersion(byte[] data) {
        byte version = UByte.constructor-impl((byte)data[4]);
        int versionAsInt = version & 0xFF;
        this.logTraceMessage("Cryptor header version is: " + versionAsInt);
        if (CryptorHeaderVersion.Companion.fromValue(versionAsInt) == null) {
            throw new PubNubException("Cryptor header version unknown. Please, update SDK", PubNubError.CRYPTOR_HEADER_VERSION_UNKNOWN, null, 0, null, null, null, null, null, null, null, 2044, null);
        }
    }

    private final void logTraceMessage(String message) {
        this.log.trace(new LogMessage((LogMessageContent)new LogMessageContent.Text(message), null, null, null, null, null, null, 126, null));
    }

    private final int convertTwoBytesToIntBigEndian(byte byte1, byte byte2) {
        return (byte1 & 0xFF) << 8 | byte2 & 0xFF;
    }

    private final byte[] writeNumberOnTwoBytes(int number) {
        byte[] result = new byte[]{(byte)(number >> 8), (byte)number};
        return result;
    }

    private static final Unit readExactlyNBytez$lambda$1(int n) {
        throw new PubNubException("Couldn't read " + n + " bytes", null, 2, null);
    }
}

