/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.endpoints;

import com.google.gson.JsonElement;
import com.pubnub.api.PubNubError;
import com.pubnub.api.PubNubException;
import com.pubnub.api.endpoints.History;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.logging.LogMessage;
import com.pubnub.api.logging.LogMessageContent;
import com.pubnub.api.models.consumer.history.PNHistoryItemResult;
import com.pubnub.api.models.consumer.history.PNHistoryResult;
import com.pubnub.api.retry.RetryableEndpointGroup;
import com.pubnub.internal.EndpointCore;
import com.pubnub.internal.PubNubImpl;
import com.pubnub.internal.extension.JsonElementKt;
import com.pubnub.internal.logging.LoggerManager;
import com.pubnub.internal.logging.PNLogger;
import com.pubnub.internal.managers.MapperManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Call;
import retrofit2.Response;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u00020\u0004BQ\b\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u000f\u0012\u0006\u0010\u0011\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0012\u0010\u0013J\b\u0010#\u001a\u00020$H\u0014J\u000e\u0010%\u001a\b\u0012\u0004\u0012\u00020\b0&H\u0014J2\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00020(2\"\u0010)\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0*j\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b`+H\u0014J\u0016\u0010,\u001a\u00020\u00032\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00020.H\u0014J\b\u0010/\u001a\u000200H\u0016J\b\u00101\u001a\u000202H\u0014J\u001c\u00103\u001a\u00020$2\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b04H\u0002R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0018\u0010\t\u001a\u0004\u0018\u00010\nX\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u0018\u001a\u0004\b\u0016\u0010\u0017R\u0018\u0010\u000b\u001a\u0004\u0018\u00010\nX\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u0018\u001a\u0004\b\u0019\u0010\u0017R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u0010\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001dR\u0014\u0010\u0011\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001dR\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/pubnub/internal/endpoints/HistoryEndpoint;", "Lcom/pubnub/internal/EndpointCore;", "Lcom/google/gson/JsonElement;", "Lcom/pubnub/api/models/consumer/history/PNHistoryResult;", "Lcom/pubnub/api/endpoints/History;", "pubnub", "Lcom/pubnub/internal/PubNubImpl;", "channel", "", "start", "", "end", "count", "", "reverse", "", "includeTimetoken", "includeMeta", "<init>", "(Lcom/pubnub/internal/PubNubImpl;Ljava/lang/String;Ljava/lang/Long;Ljava/lang/Long;IZZZ)V", "getChannel", "()Ljava/lang/String;", "getStart", "()Ljava/lang/Long;", "Ljava/lang/Long;", "getEnd", "getCount", "()I", "getReverse", "()Z", "getIncludeTimetoken", "getIncludeMeta", "log", "Lcom/pubnub/internal/logging/PNLogger;", "countParam", "validateParams", "", "getAffectedChannels", "", "doWork", "Lretrofit2/Call;", "queryParams", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "createResponse", "input", "Lretrofit2/Response;", "operationType", "Lcom/pubnub/api/enums/PNOperationType$PNHistoryOperation;", "getEndpointGroupName", "Lcom/pubnub/api/retry/RetryableEndpointGroup;", "addQueryParams", "", "pubnub-kotlin-impl"})
@SourceDebugExtension(value={"SMAP\nHistoryEndpoint.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HistoryEndpoint.kt\ncom/pubnub/internal/endpoints/HistoryEndpoint\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,159:1\n1#2:160\n*E\n"})
public final class HistoryEndpoint
extends EndpointCore<JsonElement, PNHistoryResult>
implements History {
    @NotNull
    private final String channel;
    @Nullable
    private final Long start;
    @Nullable
    private final Long end;
    private final int count;
    private final boolean reverse;
    private final boolean includeTimetoken;
    private final boolean includeMeta;
    @NotNull
    private final PNLogger log;
    private final int countParam;

    public HistoryEndpoint(@NotNull PubNubImpl pubnub, @NotNull String channel, @Nullable Long start, @Nullable Long end, int count, boolean reverse, boolean includeTimetoken, boolean includeMeta) {
        Intrinsics.checkNotNullParameter((Object)pubnub, (String)"pubnub");
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        super(pubnub);
        this.channel = channel;
        this.start = start;
        this.end = end;
        this.count = count;
        this.reverse = reverse;
        this.includeTimetoken = includeTimetoken;
        this.includeMeta = includeMeta;
        this.log = LoggerManager.Companion.getInstance().getLogger(pubnub.getLogConfig(), this.getClass());
        int n = this.getCount();
        this.countParam = (1 <= n ? n < 101 : false) ? this.getCount() : 100;
    }

    public /* synthetic */ HistoryEndpoint(PubNubImpl pubNubImpl, String string, Long l, Long l2, int n, boolean bl, boolean bl2, boolean bl3, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            l = null;
        }
        if ((n2 & 8) != 0) {
            l2 = null;
        }
        this(pubNubImpl, string, l, l2, n, bl, bl2, bl3);
    }

    @NotNull
    public String getChannel() {
        return this.channel;
    }

    @Nullable
    public Long getStart() {
        return this.start;
    }

    @Nullable
    public Long getEnd() {
        return this.end;
    }

    public int getCount() {
        return this.count;
    }

    public boolean getReverse() {
        return this.reverse;
    }

    public boolean getIncludeTimetoken() {
        return this.includeTimetoken;
    }

    public boolean getIncludeMeta() {
        return this.includeMeta;
    }

    @Override
    protected void validateParams() {
        super.validateParams();
        if (StringsKt.isBlank((CharSequence)this.getChannel())) {
            throw new PubNubException(PubNubError.CHANNEL_MISSING, null, 2, null);
        }
    }

    @Override
    @NotNull
    protected List<String> getAffectedChannels() {
        return CollectionsKt.listOf((Object)this.getChannel());
    }

    @Override
    @NotNull
    protected Call<JsonElement> doWork(@NotNull HashMap<String, String> queryParams) {
        Intrinsics.checkNotNullParameter(queryParams, (String)"queryParams");
        Pair[] pairArray = new Pair[8];
        pairArray[0] = TuplesKt.to((Object)"channel", (Object)this.getChannel());
        Object object = this.getStart();
        if (object == null) {
            object = "";
        }
        pairArray[1] = TuplesKt.to((Object)"start", (Object)object);
        Object object2 = this.getEnd();
        if (object2 == null) {
            object2 = "";
        }
        pairArray[2] = TuplesKt.to((Object)"end", (Object)object2);
        pairArray[3] = TuplesKt.to((Object)"count", (Object)this.getCount());
        pairArray[4] = TuplesKt.to((Object)"reverse", (Object)this.getReverse());
        pairArray[5] = TuplesKt.to((Object)"includeTimetoken", (Object)this.getIncludeTimetoken());
        pairArray[6] = TuplesKt.to((Object)"includeMeta", (Object)this.getIncludeMeta());
        pairArray[7] = TuplesKt.to((Object)"queryParams", queryParams);
        this.log.trace(new LogMessage((LogMessageContent)new LogMessageContent.Object(MapsKt.mapOf((Pair[])pairArray)), "History API call", null, null, null, null, null, 124, null));
        this.addQueryParams((Map<String, String>)queryParams);
        return this.getRetrofitManager().getHistoryService$pubnub_kotlin_impl().fetchHistory(this.getConfiguration().getSubscribeKey(), this.getChannel(), (Map<String, String>)queryParams);
    }

    @Override
    @NotNull
    protected PNHistoryResult createResponse(@NotNull Response<JsonElement> input) {
        Intrinsics.checkNotNullParameter(input, (String)"input");
        MapperManager mapperManager = this.getPubnub().getMapper();
        MapperManager mapperManager2 = this.getPubnub().getMapper();
        Object object = input.body();
        Intrinsics.checkNotNull((Object)object);
        JsonElement jsonElement = mapperManager2.getArrayElement((JsonElement)object, 1);
        Intrinsics.checkNotNullExpressionValue((Object)jsonElement, (String)"getArrayElement(...)");
        long startTimeToken = mapperManager.elementToLong(jsonElement);
        MapperManager mapperManager3 = this.getPubnub().getMapper();
        MapperManager mapperManager4 = this.getPubnub().getMapper();
        Object object2 = input.body();
        Intrinsics.checkNotNull((Object)object2);
        JsonElement jsonElement2 = mapperManager4.getArrayElement((JsonElement)object2, 2);
        Intrinsics.checkNotNullExpressionValue((Object)jsonElement2, (String)"getArrayElement(...)");
        long endTimeToken = mapperManager3.elementToLong(jsonElement2);
        List messages = new ArrayList();
        PNHistoryResult historyData = new PNHistoryResult(messages, startTimeToken, endTimeToken);
        MapperManager mapperManager5 = this.getPubnub().getMapper();
        Object object3 = input.body();
        Intrinsics.checkNotNull((Object)object3);
        if (mapperManager5.getArrayElement((JsonElement)object3, 0).isJsonArray()) {
            MapperManager mapperManager6 = this.getPubnub().getMapper();
            MapperManager mapperManager7 = this.getPubnub().getMapper();
            Object object4 = input.body();
            Intrinsics.checkNotNull((Object)object4);
            Iterator<JsonElement> iterator = mapperManager6.getArrayIterator(mapperManager7.getArrayElement((JsonElement)object4, 0));
            Intrinsics.checkNotNull(iterator);
            Iterator<JsonElement> iterator2 = iterator;
            while (iterator2.hasNext()) {
                JsonElement historyEntry = iterator2.next();
                Long timetoken = null;
                JsonElement meta = null;
                Pair<JsonElement, PubNubError> historyMessageWithError = null;
                if (this.getIncludeTimetoken() || this.getIncludeMeta()) {
                    JsonElement jsonElement3 = this.getPubnub().getMapper().getField(historyEntry, "message");
                    Intrinsics.checkNotNull((Object)jsonElement3);
                    historyMessageWithError = JsonElementKt.tryDecryptMessage(jsonElement3, this.getPubnub().getCryptoModuleWithLogConfig$pubnub_kotlin_impl(), this.getPubnub().getMapper(), this.log);
                    if (this.getIncludeTimetoken()) {
                        MapperManager mapperManager8 = this.getPubnub().getMapper();
                        Intrinsics.checkNotNull((Object)historyEntry);
                        timetoken = mapperManager8.elementToLong(historyEntry, "timetoken");
                    }
                    if (this.getIncludeMeta()) {
                        meta = this.getPubnub().getMapper().getField(historyEntry, "meta");
                    }
                } else {
                    Intrinsics.checkNotNull((Object)historyEntry);
                    historyMessageWithError = JsonElementKt.tryDecryptMessage(historyEntry, this.getPubnub().getCryptoModuleWithLogConfig$pubnub_kotlin_impl(), this.getPubnub().getMapper(), this.log);
                }
                JsonElement message = (JsonElement)historyMessageWithError.getFirst();
                PubNubError error = (PubNubError)historyMessageWithError.getSecond();
                PNHistoryItemResult historyItem = new PNHistoryItemResult(message, timetoken, meta, error, null, 16, null);
                messages.add(historyItem);
            }
        } else {
            PubNubError pubNubError = PubNubError.HTTP_ERROR;
            throw new PubNubException("History is disabled", pubNubError, null, 0, null, null, null, null, null, null, null, 2044, null);
        }
        return historyData;
    }

    @NotNull
    public PNOperationType.PNHistoryOperation operationType() {
        return PNOperationType.PNHistoryOperation.INSTANCE;
    }

    @Override
    @NotNull
    protected RetryableEndpointGroup getEndpointGroupName() {
        return RetryableEndpointGroup.MESSAGE_PERSISTENCE;
    }

    private final void addQueryParams(Map<String, String> queryParams) {
        block1: {
            String string;
            String string2;
            Map<String, String> map;
            queryParams.put("reverse", String.valueOf(this.getReverse()));
            queryParams.put("include_token", String.valueOf(this.getIncludeTimetoken()));
            queryParams.put("include_meta", String.valueOf(this.getIncludeMeta()));
            queryParams.put("count", String.valueOf(this.countParam));
            Long l = this.getStart();
            if (l != null) {
                long $this$addQueryParams_u24lambda_u240 = ((Number)l).longValue();
                boolean bl = false;
                map = queryParams;
                string2 = "start";
                string = String.valueOf($this$addQueryParams_u24lambda_u240);
                Locale locale = Locale.US;
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
                String string3 = string.toLowerCase(locale);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
                string = string3;
                map.put(string2, string);
            }
            Long l2 = this.getEnd();
            if (l2 == null) break block1;
            long $this$addQueryParams_u24lambda_u241 = ((Number)l2).longValue();
            boolean bl = false;
            map = queryParams;
            string2 = "end";
            string = String.valueOf($this$addQueryParams_u24lambda_u241);
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
            String string4 = string.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
            string = string4;
            map.put(string2, string);
        }
    }
}

