/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.endpoints;

import com.google.gson.JsonElement;
import com.pubnub.api.PubNubError;
import com.pubnub.api.PubNubException;
import com.pubnub.api.endpoints.MessageCounts;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.logging.LogMessage;
import com.pubnub.api.logging.LogMessageContent;
import com.pubnub.api.models.consumer.history.PNMessageCountResult;
import com.pubnub.api.retry.RetryableEndpointGroup;
import com.pubnub.internal.EndpointCore;
import com.pubnub.internal.PubNubImpl;
import com.pubnub.internal.PubNubUtilKt;
import com.pubnub.internal.logging.LoggerManager;
import com.pubnub.internal.logging.PNLogger;
import com.pubnub.internal.managers.MapperManager;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import retrofit2.Call;
import retrofit2.Response;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u00020\u0004B-\b\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\b\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u0013\u001a\u00020\u0014H\u0014J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0014J2\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00020\u00172\"\u0010\u0018\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u0019j\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t`\u001aH\u0014J\u0016\u0010\u001b\u001a\u00020\u00032\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00020\u001dH\u0014J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020!H\u0014J\u001c\u0010\"\u001a\u00020\u00142\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0#H\u0002R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/pubnub/internal/endpoints/MessageCountsEndpoint;", "Lcom/pubnub/internal/EndpointCore;", "Lcom/google/gson/JsonElement;", "Lcom/pubnub/api/models/consumer/history/PNMessageCountResult;", "Lcom/pubnub/api/endpoints/MessageCounts;", "pubnub", "Lcom/pubnub/internal/PubNubImpl;", "channels", "", "", "channelsTimetoken", "", "<init>", "(Lcom/pubnub/internal/PubNubImpl;Ljava/util/List;Ljava/util/List;)V", "getChannels", "()Ljava/util/List;", "getChannelsTimetoken", "log", "Lcom/pubnub/internal/logging/PNLogger;", "validateParams", "", "getAffectedChannels", "doWork", "Lretrofit2/Call;", "queryParams", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "createResponse", "input", "Lretrofit2/Response;", "operationType", "Lcom/pubnub/api/enums/PNOperationType$PNMessageCountOperation;", "getEndpointGroupName", "Lcom/pubnub/api/retry/RetryableEndpointGroup;", "addQueryParams", "", "pubnub-kotlin-impl"})
public final class MessageCountsEndpoint
extends EndpointCore<JsonElement, PNMessageCountResult>
implements MessageCounts {
    @NotNull
    private final List<String> channels;
    @NotNull
    private final List<Long> channelsTimetoken;
    @NotNull
    private final PNLogger log;

    public MessageCountsEndpoint(@NotNull PubNubImpl pubnub, @NotNull List<String> channels, @NotNull List<Long> channelsTimetoken) {
        Intrinsics.checkNotNullParameter((Object)pubnub, (String)"pubnub");
        Intrinsics.checkNotNullParameter(channels, (String)"channels");
        Intrinsics.checkNotNullParameter(channelsTimetoken, (String)"channelsTimetoken");
        super(pubnub);
        this.channels = channels;
        this.channelsTimetoken = channelsTimetoken;
        this.log = LoggerManager.Companion.getInstance().getLogger(pubnub.getLogConfig(), this.getClass());
    }

    @NotNull
    public List<String> getChannels() {
        return this.channels;
    }

    @NotNull
    public List<Long> getChannelsTimetoken() {
        return this.channelsTimetoken;
    }

    @Override
    protected void validateParams() {
        super.validateParams();
        if (this.getChannels().isEmpty()) {
            throw new PubNubException(PubNubError.CHANNEL_MISSING, null, 2, null);
        }
        if (this.getChannelsTimetoken().isEmpty()) {
            throw new PubNubException(PubNubError.TIMETOKEN_MISSING, null, 2, null);
        }
        if (this.getChannelsTimetoken().size() != this.getChannels().size() && this.getChannelsTimetoken().size() > 1) {
            throw new PubNubException(PubNubError.CHANNELS_TIMETOKEN_MISMATCH, null, 2, null);
        }
    }

    @Override
    @NotNull
    protected List<String> getAffectedChannels() {
        return this.getChannels();
    }

    @Override
    @NotNull
    protected Call<JsonElement> doWork(@NotNull HashMap<String, String> queryParams) {
        Intrinsics.checkNotNullParameter(queryParams, (String)"queryParams");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"channels", this.getChannels()), TuplesKt.to((Object)"channelsTimetoken", this.getChannelsTimetoken()), TuplesKt.to((Object)"queryParams", queryParams)};
        this.log.trace(new LogMessage((LogMessageContent)new LogMessageContent.Object(MapsKt.mapOf((Pair[])pairArray)), "MessageCounts API call", null, null, null, null, null, 124, null));
        this.addQueryParams((Map<String, String>)queryParams);
        return this.getRetrofitManager().getHistoryService$pubnub_kotlin_impl().fetchCount(this.getConfiguration().getSubscribeKey(), PubNubUtilKt.toCsv(this.getChannels()), (Map<String, String>)queryParams);
    }

    @Override
    @NotNull
    protected PNMessageCountResult createResponse(@NotNull Response<JsonElement> input) {
        Intrinsics.checkNotNullParameter(input, (String)"input");
        HashMap channelsMap = new HashMap();
        MapperManager mapperManager = this.getPubnub().getMapper();
        Object object = input.body();
        Intrinsics.checkNotNull((Object)object);
        Iterator<Map.Entry<String, JsonElement>> it = mapperManager.getObjectIterator((JsonElement)object, "channels");
        while (it.hasNext()) {
            Map.Entry<String, JsonElement> entry = it.next();
            ((Map)channelsMap).put(entry.getKey(), entry.getValue().getAsLong());
        }
        return new PNMessageCountResult((Map)channelsMap);
    }

    @NotNull
    public PNOperationType.PNMessageCountOperation operationType() {
        return PNOperationType.PNMessageCountOperation.INSTANCE;
    }

    @Override
    @NotNull
    protected RetryableEndpointGroup getEndpointGroupName() {
        return RetryableEndpointGroup.MESSAGE_PERSISTENCE;
    }

    private final void addQueryParams(Map<String, String> queryParams) {
        if (this.getChannelsTimetoken().size() == 1) {
            queryParams.put("timetoken", PubNubUtilKt.toCsv(this.getChannelsTimetoken()));
        } else {
            queryParams.put("channelsTimetoken", PubNubUtilKt.toCsv(this.getChannelsTimetoken()));
        }
    }
}

