/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.endpoints;

import com.pubnub.api.endpoints.Time;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.logging.LogMessage;
import com.pubnub.api.logging.LogMessageContent;
import com.pubnub.api.models.consumer.PNTimeResult;
import com.pubnub.api.retry.RetryableEndpointGroup;
import com.pubnub.internal.EndpointCore;
import com.pubnub.internal.PubNubImpl;
import com.pubnub.internal.logging.LoggerManager;
import com.pubnub.internal.logging.PNLogger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import retrofit2.Call;
import retrofit2.Response;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0004\u0012\u00020\u00040\u00012\u00020\u0005B\u0019\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0002H\u0014J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0002H\u0014J8\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u00122\"\u0010\u0013\u001a\u001e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u0014j\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f`\u0015H\u0014J\u001c\u0010\u0016\u001a\u00020\u00042\u0012\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0018H\u0014J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\tH\u0014J\b\u0010\u001c\u001a\u00020\tH\u0014J\b\u0010\u001d\u001a\u00020\u001eH\u0014J\b\u0010\u001f\u001a\u00020\tH\u0014R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/pubnub/internal/endpoints/TimeEndpoint;", "Lcom/pubnub/internal/EndpointCore;", "", "", "Lcom/pubnub/api/models/consumer/PNTimeResult;", "Lcom/pubnub/api/endpoints/Time;", "pubnub", "Lcom/pubnub/internal/PubNubImpl;", "excludeFromRetry", "", "<init>", "(Lcom/pubnub/internal/PubNubImpl;Z)V", "log", "Lcom/pubnub/internal/logging/PNLogger;", "getAffectedChannels", "", "getAffectedChannelGroups", "doWork", "Lretrofit2/Call;", "queryParams", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "createResponse", "input", "Lretrofit2/Response;", "operationType", "Lcom/pubnub/api/enums/PNOperationType$PNTimeOperation;", "isAuthRequired", "isSubKeyRequired", "getEndpointGroupName", "Lcom/pubnub/api/retry/RetryableEndpointGroup;", "isEndpointRetryable", "pubnub-kotlin-impl"})
public final class TimeEndpoint
extends EndpointCore<List<? extends Long>, PNTimeResult>
implements Time {
    private final boolean excludeFromRetry;
    @NotNull
    private final PNLogger log;

    public TimeEndpoint(@NotNull PubNubImpl pubnub, boolean excludeFromRetry) {
        Intrinsics.checkNotNullParameter((Object)pubnub, (String)"pubnub");
        super(pubnub);
        this.excludeFromRetry = excludeFromRetry;
        this.log = LoggerManager.Companion.getInstance().getLogger(pubnub.getLogConfig(), this.getClass());
    }

    public /* synthetic */ TimeEndpoint(PubNubImpl pubNubImpl, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(pubNubImpl, bl);
    }

    @Override
    @NotNull
    protected List<String> getAffectedChannels() {
        return CollectionsKt.emptyList();
    }

    @Override
    @NotNull
    protected List<String> getAffectedChannelGroups() {
        return CollectionsKt.emptyList();
    }

    @Override
    @NotNull
    protected Call<List<Long>> doWork(@NotNull HashMap<String, String> queryParams) {
        Intrinsics.checkNotNullParameter(queryParams, (String)"queryParams");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"excludeFromRetry", (Object)this.excludeFromRetry), TuplesKt.to((Object)"queryParams", queryParams)};
        this.log.trace(new LogMessage((LogMessageContent)new LogMessageContent.Object(MapsKt.mapOf((Pair[])pairArray)), "Time API call", null, null, null, null, null, 124, null));
        return this.getRetrofitManager().getTimeService$pubnub_kotlin_impl().fetchTime((Map<String, String>)queryParams);
    }

    @Override
    @NotNull
    protected PNTimeResult createResponse(@NotNull Response<List<Long>> input) {
        Intrinsics.checkNotNullParameter(input, (String)"input");
        Object object = input.body();
        Intrinsics.checkNotNull((Object)object);
        return new PNTimeResult(((Number)((List)object).get(0)).longValue());
    }

    @NotNull
    public PNOperationType.PNTimeOperation operationType() {
        return PNOperationType.PNTimeOperation.INSTANCE;
    }

    @Override
    protected boolean isAuthRequired() {
        return false;
    }

    @Override
    protected boolean isSubKeyRequired() {
        return false;
    }

    @Override
    @NotNull
    protected RetryableEndpointGroup getEndpointGroupName() {
        return RetryableEndpointGroup.MESSAGE_PERSISTENCE;
    }

    @Override
    protected boolean isEndpointRetryable() {
        return !this.excludeFromRetry;
    }
}

