/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.endpoints.channel_groups;

import com.pubnub.api.PubNubError;
import com.pubnub.api.PubNubException;
import com.pubnub.api.endpoints.channel_groups.DeleteChannelGroup;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.logging.LogMessage;
import com.pubnub.api.logging.LogMessageContent;
import com.pubnub.api.models.consumer.channel_group.PNChannelGroupsDeleteGroupResult;
import com.pubnub.api.retry.RetryableEndpointGroup;
import com.pubnub.internal.EndpointCore;
import com.pubnub.internal.PubNubImpl;
import com.pubnub.internal.logging.LoggerManager;
import com.pubnub.internal.logging.PNLogger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import retrofit2.Call;
import retrofit2.Response;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u00020\u0004B\u0019\b\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u000f\u001a\u00020\u0010H\u0014J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u0012H\u0014J2\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u00142\"\u0010\u0015\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0016j\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b`\u0017H\u0014J\u0016\u0010\u0018\u001a\u00020\u00032\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00020\u001aH\u0014J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0014R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/pubnub/internal/endpoints/channel_groups/DeleteChannelGroupEndpoint;", "Lcom/pubnub/internal/EndpointCore;", "Ljava/lang/Void;", "Lcom/pubnub/api/models/consumer/channel_group/PNChannelGroupsDeleteGroupResult;", "Lcom/pubnub/api/endpoints/channel_groups/DeleteChannelGroup;", "pubnub", "Lcom/pubnub/internal/PubNubImpl;", "channelGroup", "", "<init>", "(Lcom/pubnub/internal/PubNubImpl;Ljava/lang/String;)V", "getChannelGroup", "()Ljava/lang/String;", "log", "Lcom/pubnub/internal/logging/PNLogger;", "validateParams", "", "getAffectedChannelGroups", "", "doWork", "Lretrofit2/Call;", "queryParams", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "createResponse", "input", "Lretrofit2/Response;", "operationType", "Lcom/pubnub/api/enums/PNOperationType$PNRemoveGroupOperation;", "getEndpointGroupName", "Lcom/pubnub/api/retry/RetryableEndpointGroup;", "pubnub-kotlin-impl"})
public final class DeleteChannelGroupEndpoint
extends EndpointCore<Void, PNChannelGroupsDeleteGroupResult>
implements DeleteChannelGroup {
    @NotNull
    private final String channelGroup;
    @NotNull
    private final PNLogger log;

    public DeleteChannelGroupEndpoint(@NotNull PubNubImpl pubnub, @NotNull String channelGroup) {
        Intrinsics.checkNotNullParameter((Object)pubnub, (String)"pubnub");
        Intrinsics.checkNotNullParameter((Object)channelGroup, (String)"channelGroup");
        super(pubnub);
        this.channelGroup = channelGroup;
        this.log = LoggerManager.Companion.getInstance().getLogger(pubnub.getLogConfig(), this.getClass());
    }

    @NotNull
    public String getChannelGroup() {
        return this.channelGroup;
    }

    @Override
    protected void validateParams() {
        super.validateParams();
        if (StringsKt.isBlank((CharSequence)this.getChannelGroup())) {
            throw new PubNubException(PubNubError.GROUP_MISSING, null, 2, null);
        }
    }

    @Override
    @NotNull
    protected List<String> getAffectedChannelGroups() {
        return CollectionsKt.listOf((Object)this.getChannelGroup());
    }

    @Override
    @NotNull
    protected Call<Void> doWork(@NotNull HashMap<String, String> queryParams) {
        Intrinsics.checkNotNullParameter(queryParams, (String)"queryParams");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"channelGroup", (Object)this.getChannelGroup()), TuplesKt.to((Object)"queryParams", queryParams)};
        this.log.trace(new LogMessage((LogMessageContent)new LogMessageContent.Object(MapsKt.mapOf((Pair[])pairArray)), "DeleteChannelGroup API call", null, null, null, null, null, 124, null));
        return this.getRetrofitManager().getChannelGroupService$pubnub_kotlin_impl().deleteChannelGroup(this.getConfiguration().getSubscribeKey(), this.getChannelGroup(), (Map<String, String>)queryParams);
    }

    @Override
    @NotNull
    protected PNChannelGroupsDeleteGroupResult createResponse(@NotNull Response<Void> input) {
        Intrinsics.checkNotNullParameter(input, (String)"input");
        return new PNChannelGroupsDeleteGroupResult();
    }

    @NotNull
    public PNOperationType.PNRemoveGroupOperation operationType() {
        return PNOperationType.PNRemoveGroupOperation.INSTANCE;
    }

    @Override
    @NotNull
    protected RetryableEndpointGroup getEndpointGroupName() {
        return RetryableEndpointGroup.CHANNEL_GROUP;
    }
}

