/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.endpoints.presence;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.pubnub.api.PubNubError;
import com.pubnub.api.PubNubException;
import com.pubnub.api.endpoints.presence.SetState;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.logging.LogMessage;
import com.pubnub.api.logging.LogMessageContent;
import com.pubnub.api.models.consumer.presence.PNSetStateResult;
import com.pubnub.api.retry.RetryableEndpointGroup;
import com.pubnub.internal.EndpointCore;
import com.pubnub.internal.PubNubImpl;
import com.pubnub.internal.PubNubUtilKt;
import com.pubnub.internal.logging.LoggerManager;
import com.pubnub.internal.logging.PNLogger;
import com.pubnub.internal.models.server.Envelope;
import com.pubnub.internal.presence.eventengine.data.PresenceData;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import retrofit2.Call;
import retrofit2.Response;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\u0018\u00002\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0004\u0012\u00020\u00040\u00012\u00020\u0005BG\b\u0000\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\f\u001a\u00020\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\n\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0014J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0014J\b\u0010\u001e\u001a\u00020\u001fH\u0014J8\u0010 \u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020!2\"\u0010\"\u001a\u001e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0#j\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n`$H\u0014J\u001c\u0010%\u001a\u00020\u00042\u0012\u0010&\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020'H\u0014J\b\u0010(\u001a\u00020)H\u0016J\b\u0010*\u001a\u00020+H\u0014J\u001c\u0010,\u001a\u00020\u001f2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0-H\u0002R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u000e\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/pubnub/internal/endpoints/presence/SetStateEndpoint;", "Lcom/pubnub/internal/EndpointCore;", "Lcom/pubnub/internal/models/server/Envelope;", "Lcom/google/gson/JsonElement;", "Lcom/pubnub/api/models/consumer/presence/PNSetStateResult;", "Lcom/pubnub/api/endpoints/presence/SetState;", "pubnub", "Lcom/pubnub/internal/PubNubImpl;", "channels", "", "", "channelGroups", "state", "", "uuid", "presenceData", "Lcom/pubnub/internal/presence/eventengine/data/PresenceData;", "<init>", "(Lcom/pubnub/internal/PubNubImpl;Ljava/util/List;Ljava/util/List;Ljava/lang/Object;Ljava/lang/String;Lcom/pubnub/internal/presence/eventengine/data/PresenceData;)V", "getChannels", "()Ljava/util/List;", "getChannelGroups", "getState", "()Ljava/lang/Object;", "getUuid", "()Ljava/lang/String;", "log", "Lcom/pubnub/internal/logging/PNLogger;", "getAffectedChannels", "getAffectedChannelGroups", "validateParams", "", "doWork", "Lretrofit2/Call;", "queryParams", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "createResponse", "input", "Lretrofit2/Response;", "operationType", "Lcom/pubnub/api/enums/PNOperationType$PNSetStateOperation;", "getEndpointGroupName", "Lcom/pubnub/api/retry/RetryableEndpointGroup;", "addQueryParams", "", "pubnub-kotlin-impl"})
@SourceDebugExtension(value={"SMAP\nSetStateEndpoint.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SetStateEndpoint.kt\ncom/pubnub/internal/endpoints/presence/SetStateEndpoint\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,96:1\n1285#2,2:97\n1299#2,4:99\n*S KotlinDebug\n*F\n+ 1 SetStateEndpoint.kt\ncom/pubnub/internal/endpoints/presence/SetStateEndpoint\n*L\n65#1:97,2\n65#1:99,4\n*E\n"})
public final class SetStateEndpoint
extends EndpointCore<Envelope<JsonElement>, PNSetStateResult>
implements SetState {
    @NotNull
    private final List<String> channels;
    @NotNull
    private final List<String> channelGroups;
    @NotNull
    private final Object state;
    @NotNull
    private final String uuid;
    @NotNull
    private final PresenceData presenceData;
    @NotNull
    private final PNLogger log;

    public SetStateEndpoint(@NotNull PubNubImpl pubnub, @NotNull List<String> channels, @NotNull List<String> channelGroups, @NotNull Object state, @NotNull String uuid, @NotNull PresenceData presenceData) {
        Intrinsics.checkNotNullParameter((Object)pubnub, (String)"pubnub");
        Intrinsics.checkNotNullParameter(channels, (String)"channels");
        Intrinsics.checkNotNullParameter(channelGroups, (String)"channelGroups");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Intrinsics.checkNotNullParameter((Object)presenceData, (String)"presenceData");
        super(pubnub);
        this.channels = channels;
        this.channelGroups = channelGroups;
        this.state = state;
        this.uuid = uuid;
        this.presenceData = presenceData;
        this.log = LoggerManager.Companion.getInstance().getLogger(pubnub.getLogConfig(), this.getClass());
    }

    public /* synthetic */ SetStateEndpoint(PubNubImpl pubNubImpl, List list, List list2, Object object, String string, PresenceData presenceData, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            string = pubNubImpl.getConfiguration().getUserId().getValue();
        }
        this(pubNubImpl, list, list2, object, string, presenceData);
    }

    @NotNull
    public List<String> getChannels() {
        return this.channels;
    }

    @NotNull
    public List<String> getChannelGroups() {
        return this.channelGroups;
    }

    @NotNull
    public Object getState() {
        return this.state;
    }

    @NotNull
    public String getUuid() {
        return this.uuid;
    }

    @Override
    @NotNull
    protected List<String> getAffectedChannels() {
        return this.getChannels();
    }

    @Override
    @NotNull
    protected List<String> getAffectedChannelGroups() {
        return this.getChannelGroups();
    }

    @Override
    protected void validateParams() {
        super.validateParams();
        if (this.getChannels().isEmpty() && this.getChannelGroups().isEmpty()) {
            throw new PubNubException(PubNubError.CHANNEL_AND_GROUP_MISSING, null, 2, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected Call<Envelope<JsonElement>> doWork(@NotNull HashMap<String, String> queryParams) {
        Intrinsics.checkNotNullParameter(queryParams, (String)"queryParams");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"channels", this.getChannels()), TuplesKt.to((Object)"channelGroups", this.getChannelGroups()), TuplesKt.to((Object)"state", (Object)this.getState()), TuplesKt.to((Object)"uuid", (Object)this.getUuid()), TuplesKt.to((Object)"queryParams", queryParams)};
        this.log.trace(new LogMessage((LogMessageContent)new LogMessageContent.Object(MapsKt.mapOf((Pair[])pairArray)), "SetState API call", null, null, null, null, null, 124, null));
        if (Intrinsics.areEqual((Object)this.getUuid(), (Object)this.getPubnub().getConfiguration().getUserId().getValue())) {
            void $this$associateWith$iv;
            JsonElement stateCopy = this.getPubnub().getMapper().fromJson(this.getPubnub().getMapper().toJson(this.getState()), JsonElement.class);
            Iterable iterable = this.getChannels();
            ConcurrentHashMap<String, Object> concurrentHashMap = this.presenceData.getChannelStates$pubnub_kotlin_impl();
            boolean $i$f$associateWith = false;
            LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
            void $this$associateWithTo$iv$iv = $this$associateWith$iv;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                String string = (String)element$iv$iv;
                Object t = element$iv$iv;
                Map map = result$iv;
                boolean bl = false;
                JsonElement jsonElement = stateCopy;
                map.put(t, jsonElement);
            }
            concurrentHashMap.putAll(result$iv);
        }
        this.addQueryParams((Map<String, String>)queryParams);
        return this.getRetrofitManager().getPresenceService$pubnub_kotlin_impl().setState(this.getConfiguration().getSubscribeKey(), PubNubUtilKt.toCsv(this.getChannels()), this.getUuid(), (Map<String, String>)queryParams);
    }

    @Override
    @NotNull
    protected PNSetStateResult createResponse(@NotNull Response<Envelope<JsonElement>> input) {
        Intrinsics.checkNotNullParameter(input, (String)"input");
        Object object = input.body();
        Intrinsics.checkNotNull((Object)object);
        Object t = ((Envelope)object).getPayload$pubnub_kotlin_impl();
        Intrinsics.checkNotNull(t);
        if (t instanceof JsonNull) {
            throw new PubNubException(PubNubError.PARSING_ERROR, null, 2, null);
        }
        Object object2 = input.body();
        Intrinsics.checkNotNull((Object)object2);
        Object t2 = ((Envelope)object2).getPayload$pubnub_kotlin_impl();
        Intrinsics.checkNotNull(t2);
        return new PNSetStateResult((JsonElement)t2);
    }

    @NotNull
    public PNOperationType.PNSetStateOperation operationType() {
        return PNOperationType.PNSetStateOperation.INSTANCE;
    }

    @Override
    @NotNull
    protected RetryableEndpointGroup getEndpointGroupName() {
        return RetryableEndpointGroup.PRESENCE;
    }

    private final void addQueryParams(Map<String, String> queryParams) {
        if (!((Collection)this.getChannelGroups()).isEmpty()) {
            queryParams.put("channel-group", PubNubUtilKt.toCsv(this.getChannelGroups()));
        }
        queryParams.put("state", this.getPubnub().getMapper().toJson(this.getState()));
    }
}

