/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.eventengine;

import com.pubnub.api.logging.LogConfig;
import com.pubnub.api.logging.LogMessage;
import com.pubnub.api.logging.LogMessageContent;
import com.pubnub.internal.eventengine.EffectInvocation;
import com.pubnub.internal.eventengine.Event;
import com.pubnub.internal.eventengine.Sink;
import com.pubnub.internal.eventengine.Source;
import com.pubnub.internal.eventengine.State;
import com.pubnub.internal.eventengine.TransitionKt;
import com.pubnub.internal.logging.LoggerManager;
import com.pubnub.internal.logging.PNLogger;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u0004*\u001a\b\u0002\u0010\u0005*\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u0002H\u00050\u00062\u00020\u0007B=\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00010\u000b\u0012\u0006\u0010\f\u001a\u00028\u0002\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\u0017J\u0017\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00028\u0001H\u0000\u00a2\u0006\u0004\b\u001b\u0010\u001cR\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00028\u0002X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0013R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/pubnub/internal/eventengine/EventEngine;", "Ei", "Lcom/pubnub/internal/eventengine/EffectInvocation;", "Ev", "Lcom/pubnub/internal/eventengine/Event;", "S", "Lcom/pubnub/internal/eventengine/State;", "", "effectSink", "Lcom/pubnub/internal/eventengine/Sink;", "eventSource", "Lcom/pubnub/internal/eventengine/Source;", "currentState", "logConfig", "Lcom/pubnub/api/logging/LogConfig;", "executorService", "Ljava/util/concurrent/ExecutorService;", "<init>", "(Lcom/pubnub/internal/eventengine/Sink;Lcom/pubnub/internal/eventengine/Source;Lcom/pubnub/internal/eventengine/State;Lcom/pubnub/api/logging/LogConfig;Ljava/util/concurrent/ExecutorService;)V", "Lcom/pubnub/internal/eventengine/State;", "log", "Lcom/pubnub/internal/logging/PNLogger;", "start", "", "stop", "performTransitionAndEmitEffects", "event", "performTransitionAndEmitEffects$pubnub_kotlin_impl", "(Lcom/pubnub/internal/eventengine/Event;)V", "pubnub-kotlin-impl"})
@SourceDebugExtension(value={"SMAP\nEventEngine.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EventEngine.kt\ncom/pubnub/internal/eventengine/EventEngine\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,60:1\n1869#2,2:61\n*S KotlinDebug\n*F\n+ 1 EventEngine.kt\ncom/pubnub/internal/eventengine/EventEngine\n*L\n57#1:61,2\n*E\n"})
public final class EventEngine<Ei extends EffectInvocation, Ev extends Event, S extends State<Ei, Ev, S>> {
    @NotNull
    private final Sink<Ei> effectSink;
    @NotNull
    private final Source<Ev> eventSource;
    @NotNull
    private S currentState;
    @NotNull
    private final LogConfig logConfig;
    @NotNull
    private final ExecutorService executorService;
    @NotNull
    private final PNLogger log;

    public EventEngine(@NotNull Sink<Ei> effectSink, @NotNull Source<Ev> eventSource, @NotNull S currentState, @NotNull LogConfig logConfig, @NotNull ExecutorService executorService) {
        Intrinsics.checkNotNullParameter(effectSink, (String)"effectSink");
        Intrinsics.checkNotNullParameter(eventSource, (String)"eventSource");
        Intrinsics.checkNotNullParameter(currentState, (String)"currentState");
        Intrinsics.checkNotNullParameter((Object)logConfig, (String)"logConfig");
        Intrinsics.checkNotNullParameter((Object)executorService, (String)"executorService");
        this.effectSink = effectSink;
        this.eventSource = eventSource;
        this.currentState = currentState;
        this.logConfig = logConfig;
        this.executorService = executorService;
        this.log = LoggerManager.Companion.getInstance().getLogger(this.logConfig, this.getClass());
    }

    public /* synthetic */ EventEngine(Sink sink, Source source, State state, LogConfig logConfig, ExecutorService executorService, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            executorService = Executors.newSingleThreadExecutor();
        }
        this(sink, source, state, logConfig, executorService);
    }

    public final void start() {
        this.executorService.submit(() -> EventEngine.start$lambda$0(this));
    }

    public final void stop() {
        this.executorService.shutdownNow();
    }

    public final void performTransitionAndEmitEffects$pubnub_kotlin_impl(@NotNull Ev event) {
        Intrinsics.checkNotNullParameter(event, (String)"event");
        StringBuilder stringBuilder = new StringBuilder().append("Current state is: ").append(Reflection.getOrCreateKotlinClass(this.currentState.getClass()).getSimpleName()).append(" ; ");
        String string = event.getClass().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        this.log.trace(new LogMessage((LogMessageContent)new LogMessageContent.Text(stringBuilder.append(StringsKt.substringBefore$default((String)StringsKt.substringAfterLast$default((String)string, (char)'.', null, (int)2, null), (char)'$', null, (int)2, null)).append(" to be handled is: ").append(event).append(' ').toString()), null, null, null, null, null, null, 126, null));
        Pair pair = TransitionKt.transition(this.currentState, event);
        State newState = (State)pair.component1();
        Set invocations = (Set)pair.component2();
        this.log.trace(new LogMessage((LogMessageContent)new LogMessageContent.Text("New state is: " + Reflection.getOrCreateKotlinClass(newState.getClass()).getSimpleName() + " ; Emitting fallowing effects: " + CollectionsKt.joinToString$default((Iterable)invocations, null, null, null, (int)0, null, EventEngine::performTransitionAndEmitEffects$lambda$1, (int)31, null)), null, null, null, null, null, null, 126, null));
        this.currentState = newState;
        Iterable $this$forEach$iv = invocations;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EffectInvocation invocation = (EffectInvocation)element$iv;
            boolean bl = false;
            this.effectSink.add(invocation);
        }
    }

    private static final void start$lambda$0(EventEngine this$0) {
        try {
            while (true) {
                Event event = (Event)this$0.eventSource.take();
                this$0.performTransitionAndEmitEffects$pubnub_kotlin_impl(event);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return;
        }
    }

    private static final CharSequence performTransitionAndEmitEffects$lambda$1(EffectInvocation it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getClass().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return StringsKt.substringAfter$default((String)StringsKt.substringAfterLast$default((String)string, (char)'.', null, (int)2, null), (char)'$', null, (int)2, null);
    }
}

