/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.logging;

import com.pubnub.api.logging.CustomLogger;
import com.pubnub.api.logging.ErrorDetails;
import com.pubnub.api.logging.LogMessage;
import com.pubnub.api.logging.LogMessageContent;
import com.pubnub.api.logging.LogMessageType;
import com.pubnub.internal.logging.PNLogger;
import com.pubnub.internal.logging.networkLogging.LogMessageFormatterKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.event.Level;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0001\u0012\u0010\b\u0002\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001d\u0010\u0017\u001a\u00020\u000e2\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000e0\u0019H\u0082\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/pubnub/internal/logging/CompositeLogger;", "Lcom/pubnub/internal/logging/PNLogger;", "slf4jLogger", "Lorg/slf4j/Logger;", "location", "", "pnInstanceId", "toPortalLogger", "customLoggers", "", "Lcom/pubnub/api/logging/CustomLogger;", "<init>", "(Lorg/slf4j/Logger;Ljava/lang/String;Ljava/lang/String;Lcom/pubnub/internal/logging/PNLogger;Ljava/util/List;)V", "trace", "", "message", "Lcom/pubnub/api/logging/LogMessage;", "debug", "info", "warn", "error", "sendMessageToCustomLogger", "logger", "delegateToCustomLoggers", "action", "Lkotlin/Function1;", "pubnub-kotlin-impl"})
@SourceDebugExtension(value={"SMAP\nCompositeLogger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompositeLogger.kt\ncom/pubnub/internal/logging/CompositeLogger\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,169:1\n140#1:170\n141#1,26:172\n167#1:199\n140#1:200\n141#1,26:202\n167#1:229\n140#1:230\n141#1,26:232\n167#1:259\n140#1:260\n141#1,26:262\n167#1:289\n140#1:290\n141#1,26:292\n167#1:319\n1869#2:171\n1870#2:198\n1869#2:201\n1870#2:228\n1869#2:231\n1870#2:258\n1869#2:261\n1870#2:288\n1869#2:291\n1870#2:318\n1869#2,2:320\n*S KotlinDebug\n*F\n+ 1 CompositeLogger.kt\ncom/pubnub/internal/logging/CompositeLogger\n*L\n35#1:170\n35#1:172,26\n35#1:199\n52#1:200\n52#1:202,26\n52#1:229\n69#1:230\n69#1:232,26\n69#1:259\n86#1:260\n86#1:262,26\n86#1:289\n103#1:290\n103#1:292,26\n103#1:319\n35#1:171\n35#1:198\n52#1:201\n52#1:228\n69#1:231\n69#1:258\n86#1:261\n86#1:288\n103#1:291\n103#1:318\n140#1:320,2\n*E\n"})
public final class CompositeLogger
implements PNLogger {
    @NotNull
    private final Logger slf4jLogger;
    @NotNull
    private final String location;
    @NotNull
    private final String pnInstanceId;
    @Nullable
    private final PNLogger toPortalLogger;
    @Nullable
    private final List<CustomLogger> customLoggers;

    public CompositeLogger(@NotNull Logger slf4jLogger, @NotNull String location, @NotNull String pnInstanceId, @Nullable PNLogger toPortalLogger, @Nullable List<? extends CustomLogger> customLoggers) {
        Intrinsics.checkNotNullParameter((Object)slf4jLogger, (String)"slf4jLogger");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)pnInstanceId, (String)"pnInstanceId");
        this.slf4jLogger = slf4jLogger;
        this.location = location;
        this.pnInstanceId = pnInstanceId;
        this.toPortalLogger = toPortalLogger;
        this.customLoggers = customLoggers;
    }

    public /* synthetic */ CompositeLogger(Logger logger, String string, String string2, PNLogger pNLogger, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            pNLogger = null;
        }
        if ((n & 0x10) != 0) {
            list = null;
        }
        this(logger, string, string2, pNLogger, list);
    }

    @Override
    public void trace(@NotNull LogMessage message) {
        block7: {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            LogMessageContent logMessageContent = message.getMessage();
            String string = message.getDetails();
            LogMessageType logMessageType = message.getType();
            String string2 = message.getLocation();
            if (string2 == null) {
                string2 = this.location;
            }
            LogMessage enhancedLogMessage = new LogMessage(logMessageContent, string, logMessageType, string2, this.pnInstanceId, Level.TRACE, message.getTimestamp());
            this.slf4jLogger.trace(LogMessageFormatterKt.simplified(enhancedLogMessage));
            PNLogger pNLogger = this.toPortalLogger;
            if (pNLogger != null) {
                pNLogger.trace(enhancedLogMessage);
            }
            CompositeLogger this_$iv = this;
            boolean $i$f$delegateToCustomLoggers = false;
            List<CustomLogger> list = this_$iv.customLoggers;
            if (list == null) break block7;
            Iterable $this$forEach$iv$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv$iv : $this$forEach$iv$iv) {
                CustomLogger logger$iv = (CustomLogger)element$iv$iv;
                boolean bl = false;
                try {
                    CustomLogger logger = logger$iv;
                    boolean bl2 = false;
                    this.sendMessageToCustomLogger(logger, enhancedLogMessage);
                }
                catch (Exception e$iv) {
                    try {
                        LogMessage logMessage$iv = new LogMessage((LogMessageContent)new LogMessageContent.Error(new ErrorDetails(this_$iv.getClass().getSimpleName(), "Custom logger " + logger$iv.getName() + " failed: " + e$iv.getMessage(), null, 4, null)), null, LogMessageType.ERROR, "CompositeLogger", this_$iv.pnInstanceId, Level.ERROR, null, 66, null);
                        this_$iv.slf4jLogger.error(LogMessageFormatterKt.simplified(logMessage$iv));
                        PNLogger pNLogger2 = this_$iv.toPortalLogger;
                        if (pNLogger2 == null) continue;
                        pNLogger2.error(logMessage$iv);
                    }
                    catch (Exception exception) {
                    }
                }
            }
        }
    }

    @Override
    public void debug(@NotNull LogMessage message) {
        block7: {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            LogMessageContent logMessageContent = message.getMessage();
            String string = message.getDetails();
            LogMessageType logMessageType = message.getType();
            String string2 = message.getLocation();
            if (string2 == null) {
                string2 = this.location;
            }
            LogMessage enhancedLogMessage = new LogMessage(logMessageContent, string, logMessageType, string2, this.pnInstanceId, Level.DEBUG, message.getTimestamp());
            this.slf4jLogger.debug(LogMessageFormatterKt.simplified(enhancedLogMessage));
            PNLogger pNLogger = this.toPortalLogger;
            if (pNLogger != null) {
                pNLogger.debug(enhancedLogMessage);
            }
            CompositeLogger this_$iv = this;
            boolean $i$f$delegateToCustomLoggers = false;
            List<CustomLogger> list = this_$iv.customLoggers;
            if (list == null) break block7;
            Iterable $this$forEach$iv$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv$iv : $this$forEach$iv$iv) {
                CustomLogger logger$iv = (CustomLogger)element$iv$iv;
                boolean bl = false;
                try {
                    CustomLogger logger = logger$iv;
                    boolean bl2 = false;
                    this.sendMessageToCustomLogger(logger, enhancedLogMessage);
                }
                catch (Exception e$iv) {
                    try {
                        LogMessage logMessage$iv = new LogMessage((LogMessageContent)new LogMessageContent.Error(new ErrorDetails(this_$iv.getClass().getSimpleName(), "Custom logger " + logger$iv.getName() + " failed: " + e$iv.getMessage(), null, 4, null)), null, LogMessageType.ERROR, "CompositeLogger", this_$iv.pnInstanceId, Level.ERROR, null, 66, null);
                        this_$iv.slf4jLogger.error(LogMessageFormatterKt.simplified(logMessage$iv));
                        PNLogger pNLogger2 = this_$iv.toPortalLogger;
                        if (pNLogger2 == null) continue;
                        pNLogger2.error(logMessage$iv);
                    }
                    catch (Exception exception) {
                    }
                }
            }
        }
    }

    @Override
    public void info(@NotNull LogMessage message) {
        block7: {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            LogMessageContent logMessageContent = message.getMessage();
            String string = message.getDetails();
            LogMessageType logMessageType = message.getType();
            String string2 = message.getLocation();
            if (string2 == null) {
                string2 = this.location;
            }
            LogMessage enhancedLogMessage = new LogMessage(logMessageContent, string, logMessageType, string2, this.pnInstanceId, Level.INFO, message.getTimestamp());
            this.slf4jLogger.info(LogMessageFormatterKt.simplified(enhancedLogMessage));
            PNLogger pNLogger = this.toPortalLogger;
            if (pNLogger != null) {
                pNLogger.info(enhancedLogMessage);
            }
            CompositeLogger this_$iv = this;
            boolean $i$f$delegateToCustomLoggers = false;
            List<CustomLogger> list = this_$iv.customLoggers;
            if (list == null) break block7;
            Iterable $this$forEach$iv$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv$iv : $this$forEach$iv$iv) {
                CustomLogger logger$iv = (CustomLogger)element$iv$iv;
                boolean bl = false;
                try {
                    CustomLogger logger = logger$iv;
                    boolean bl2 = false;
                    this.sendMessageToCustomLogger(logger, enhancedLogMessage);
                }
                catch (Exception e$iv) {
                    try {
                        LogMessage logMessage$iv = new LogMessage((LogMessageContent)new LogMessageContent.Error(new ErrorDetails(this_$iv.getClass().getSimpleName(), "Custom logger " + logger$iv.getName() + " failed: " + e$iv.getMessage(), null, 4, null)), null, LogMessageType.ERROR, "CompositeLogger", this_$iv.pnInstanceId, Level.ERROR, null, 66, null);
                        this_$iv.slf4jLogger.error(LogMessageFormatterKt.simplified(logMessage$iv));
                        PNLogger pNLogger2 = this_$iv.toPortalLogger;
                        if (pNLogger2 == null) continue;
                        pNLogger2.error(logMessage$iv);
                    }
                    catch (Exception exception) {
                    }
                }
            }
        }
    }

    @Override
    public void warn(@NotNull LogMessage message) {
        block7: {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            LogMessageContent logMessageContent = message.getMessage();
            String string = message.getDetails();
            LogMessageType logMessageType = message.getType();
            String string2 = message.getLocation();
            if (string2 == null) {
                string2 = this.location;
            }
            LogMessage enhancedLogMessage = new LogMessage(logMessageContent, string, logMessageType, string2, this.pnInstanceId, Level.WARN, message.getTimestamp());
            this.slf4jLogger.warn(LogMessageFormatterKt.simplified(enhancedLogMessage));
            PNLogger pNLogger = this.toPortalLogger;
            if (pNLogger != null) {
                pNLogger.warn(enhancedLogMessage);
            }
            CompositeLogger this_$iv = this;
            boolean $i$f$delegateToCustomLoggers = false;
            List<CustomLogger> list = this_$iv.customLoggers;
            if (list == null) break block7;
            Iterable $this$forEach$iv$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv$iv : $this$forEach$iv$iv) {
                CustomLogger logger$iv = (CustomLogger)element$iv$iv;
                boolean bl = false;
                try {
                    CustomLogger logger = logger$iv;
                    boolean bl2 = false;
                    this.sendMessageToCustomLogger(logger, enhancedLogMessage);
                }
                catch (Exception e$iv) {
                    try {
                        LogMessage logMessage$iv = new LogMessage((LogMessageContent)new LogMessageContent.Error(new ErrorDetails(this_$iv.getClass().getSimpleName(), "Custom logger " + logger$iv.getName() + " failed: " + e$iv.getMessage(), null, 4, null)), null, LogMessageType.ERROR, "CompositeLogger", this_$iv.pnInstanceId, Level.ERROR, null, 66, null);
                        this_$iv.slf4jLogger.error(LogMessageFormatterKt.simplified(logMessage$iv));
                        PNLogger pNLogger2 = this_$iv.toPortalLogger;
                        if (pNLogger2 == null) continue;
                        pNLogger2.error(logMessage$iv);
                    }
                    catch (Exception exception) {
                    }
                }
            }
        }
    }

    @Override
    public void error(@NotNull LogMessage message) {
        block7: {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            LogMessageContent logMessageContent = message.getMessage();
            String string = message.getDetails();
            LogMessageType logMessageType = message.getType();
            String string2 = message.getLocation();
            if (string2 == null) {
                string2 = this.location;
            }
            LogMessage enhancedLogMessage = new LogMessage(logMessageContent, string, logMessageType, string2, this.pnInstanceId, Level.ERROR, message.getTimestamp());
            this.slf4jLogger.error(LogMessageFormatterKt.simplified(enhancedLogMessage));
            PNLogger pNLogger = this.toPortalLogger;
            if (pNLogger != null) {
                pNLogger.error(enhancedLogMessage);
            }
            CompositeLogger this_$iv = this;
            boolean $i$f$delegateToCustomLoggers = false;
            List<CustomLogger> list = this_$iv.customLoggers;
            if (list == null) break block7;
            Iterable $this$forEach$iv$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv$iv : $this$forEach$iv$iv) {
                CustomLogger logger$iv = (CustomLogger)element$iv$iv;
                boolean bl = false;
                try {
                    CustomLogger logger = logger$iv;
                    boolean bl2 = false;
                    this.sendMessageToCustomLogger(logger, enhancedLogMessage);
                }
                catch (Exception e$iv) {
                    try {
                        LogMessage logMessage$iv = new LogMessage((LogMessageContent)new LogMessageContent.Error(new ErrorDetails(this_$iv.getClass().getSimpleName(), "Custom logger " + logger$iv.getName() + " failed: " + e$iv.getMessage(), null, 4, null)), null, LogMessageType.ERROR, "CompositeLogger", this_$iv.pnInstanceId, Level.ERROR, null, 66, null);
                        this_$iv.slf4jLogger.error(LogMessageFormatterKt.simplified(logMessage$iv));
                        PNLogger pNLogger2 = this_$iv.toPortalLogger;
                        if (pNLogger2 == null) continue;
                        pNLogger2.error(logMessage$iv);
                    }
                    catch (Exception exception) {
                    }
                }
            }
        }
    }

    private final void sendMessageToCustomLogger(CustomLogger logger, LogMessage message) {
        Level level = message.getLogLevel();
        switch (level == null ? -1 : WhenMappings.$EnumSwitchMapping$0[level.ordinal()]) {
            case 1: {
                logger.trace(message);
                logger.trace(LogMessageFormatterKt.simplified(message));
                break;
            }
            case 2: {
                logger.debug(message);
                logger.debug(LogMessageFormatterKt.simplified(message));
                break;
            }
            case 3: {
                logger.info(message);
                logger.info(LogMessageFormatterKt.simplified(message));
                break;
            }
            case 4: {
                logger.warn(message);
                logger.warn(LogMessageFormatterKt.simplified(message));
                break;
            }
            case 5: {
                logger.error(message);
                logger.error(LogMessageFormatterKt.simplified(message));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported log level: " + message.getLogLevel());
            }
        }
    }

    private final void delegateToCustomLoggers(Function1<? super CustomLogger, Unit> action) {
        block5: {
            boolean $i$f$delegateToCustomLoggers = false;
            List<CustomLogger> list = this.customLoggers;
            if (list == null) break block5;
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CustomLogger logger = (CustomLogger)element$iv;
                boolean bl = false;
                try {
                    action.invoke((Object)logger);
                }
                catch (Exception e) {
                    try {
                        LogMessage logMessage = new LogMessage((LogMessageContent)new LogMessageContent.Error(new ErrorDetails(this.getClass().getSimpleName(), "Custom logger " + logger.getName() + " failed: " + e.getMessage(), null, 4, null)), null, LogMessageType.ERROR, "CompositeLogger", this.pnInstanceId, Level.ERROR, null, 66, null);
                        this.slf4jLogger.error(LogMessageFormatterKt.simplified(logMessage));
                        PNLogger pNLogger = this.toPortalLogger;
                        if (pNLogger == null) continue;
                        pNLogger.error(logMessage);
                    }
                    catch (Exception exception) {
                    }
                }
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Level.values().length];
            try {
                nArray[Level.TRACE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Level.DEBUG.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Level.INFO.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Level.WARN.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Level.ERROR.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

