/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.logging;

import com.pubnub.api.logging.LogMessage;
import com.pubnub.internal.logging.LogConfigFromPortal;
import com.pubnub.internal.logging.PNLogger;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.event.Level;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0002J\b\u0010\u0014\u001a\u00020\u0012H\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u001c\u001a\u00020\u0016H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0017\u001a\u00020\u00168BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001d"}, d2={"Lcom/pubnub/internal/logging/ToPortalLogger;", "Lcom/pubnub/internal/logging/PNLogger;", "userId", "", "<init>", "(Ljava/lang/String;)V", "trace", "", "message", "Lcom/pubnub/api/logging/LogMessage;", "debug", "info", "warn", "error", "onLog", "level", "Lorg/slf4j/event/Level;", "shouldLogMessageForThisLevel", "", "isLoggingToPortalEnabled", "shouldLogMessageForThisUser", "getConfigFromPortal", "Lcom/pubnub/internal/logging/LogConfigFromPortal;", "portalConfig", "getPortalConfig", "()Lcom/pubnub/internal/logging/LogConfigFromPortal;", "portalConfig$delegate", "Lkotlin/Lazy;", "loadConfigFromPortal", "pubnub-kotlin-impl"})
public final class ToPortalLogger
implements PNLogger {
    @NotNull
    private final String userId;
    @NotNull
    private final Lazy portalConfig$delegate;

    public ToPortalLogger(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        this.userId = userId;
        this.portalConfig$delegate = LazyKt.lazy(() -> ToPortalLogger.portalConfig_delegate$lambda$0(this));
    }

    @Override
    public void trace(@NotNull LogMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.onLog(Level.TRACE, message);
    }

    @Override
    public void debug(@NotNull LogMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.onLog(Level.DEBUG, message);
    }

    @Override
    public void info(@NotNull LogMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.onLog(Level.INFO, message);
    }

    @Override
    public void warn(@NotNull LogMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.onLog(Level.WARN, message);
    }

    @Override
    public void error(@NotNull LogMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.onLog(Level.ERROR, message);
    }

    private final void onLog(Level level, LogMessage message) {
        if (!this.isLoggingToPortalEnabled() || !this.shouldLogMessageForThisUser() || this.shouldLogMessageForThisLevel(level)) {
            // empty if block
        }
    }

    private final boolean shouldLogMessageForThisLevel(Level level) {
        Level configuredLevel = this.getConfigFromPortal().getLogLevel();
        return level.toInt() >= configuredLevel.toInt();
    }

    private final boolean isLoggingToPortalEnabled() {
        return this.getConfigFromPortal().isLoggingEnabled();
    }

    private final boolean shouldLogMessageForThisUser() {
        return Intrinsics.areEqual((Object)this.getConfigFromPortal().getUserId(), (Object)this.userId);
    }

    private final LogConfigFromPortal getConfigFromPortal() {
        return this.getPortalConfig();
    }

    private final LogConfigFromPortal getPortalConfig() {
        Lazy lazy = this.portalConfig$delegate;
        return (LogConfigFromPortal)lazy.getValue();
    }

    private final LogConfigFromPortal loadConfigFromPortal() {
        return new LogConfigFromPortal(false, Level.INFO, "defaultUserId");
    }

    private static final LogConfigFromPortal portalConfig_delegate$lambda$0(ToPortalLogger this$0) {
        return this$0.loadConfigFromPortal();
    }
}

