/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.logging.networkLogging;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.pubnub.api.logging.ErrorDetails;
import com.pubnub.api.logging.LogMessageContent;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u001b\u0010\u0004\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lcom/pubnub/internal/logging/networkLogging/LogMessageFormatter;", "", "<init>", "()V", "prettyGson", "Lcom/google/gson/Gson;", "getPrettyGson", "()Lcom/google/gson/Gson;", "prettyGson$delegate", "Lkotlin/Lazy;", "formatMessageContent", "", "content", "Lcom/pubnub/api/logging/LogMessageContent;", "pubnub-kotlin-impl"})
public final class LogMessageFormatter {
    @NotNull
    public static final LogMessageFormatter INSTANCE = new LogMessageFormatter();
    @NotNull
    private static final Lazy prettyGson$delegate = LazyKt.lazy(LogMessageFormatter::prettyGson_delegate$lambda$0);

    private LogMessageFormatter() {
    }

    private final Gson getPrettyGson() {
        Lazy lazy = prettyGson$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (Gson)object;
    }

    @NotNull
    public final String formatMessageContent(@NotNull LogMessageContent content) {
        String string;
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        try {
            String string2;
            LogMessageContent logMessageContent = content;
            if (logMessageContent instanceof LogMessageContent.Text) {
                string2 = ((LogMessageContent.Text)content).getMessage();
            } else if (logMessageContent instanceof LogMessageContent.Object) {
                string2 = this.getPrettyGson().toJson((Object)((LogMessageContent.Object)content).getMessage());
            } else if (logMessageContent instanceof LogMessageContent.Error) {
                ErrorDetails err = ((LogMessageContent.Error)content).getMessage();
                List list = err.getStack();
                string2 = "Error(type=" + err.getType() + ", message=" + err.getMessage() + ", stack=" + (list != null ? CollectionsKt.joinToString$default((Iterable)list, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null) : null) + ')';
            } else {
                string2 = logMessageContent instanceof LogMessageContent.NetworkRequest ? "NetworkRequest:\n" + this.getPrettyGson().toJson((Object)((LogMessageContent.NetworkRequest)content).getMessage()) : (logMessageContent instanceof LogMessageContent.NetworkResponse ? "NetworkResponse:\n" + this.getPrettyGson().toJson((Object)((LogMessageContent.NetworkResponse)content).getMessage()) : content.toString());
            }
            string = string2;
            Intrinsics.checkNotNull((Object)string);
        }
        catch (Exception e) {
            string = "Failed to format message content: " + e.getMessage();
        }
        return string;
    }

    private static final Gson prettyGson_delegate$lambda$0() {
        return new GsonBuilder().setPrettyPrinting().create();
    }
}

