/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.vendor;

import com.pubnub.api.PubNubException;
import com.pubnub.internal.vendor.Crypto;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Locale;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u0007J\u0016\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u0007J\u001d\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\u0011J\u001c\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u00132\u0006\u0010\u0014\u001a\u00020\nH\u0002J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u000fH\u0002J\u0018\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u000fH\u0002J \u0010\u001a\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u0005H\u0002J\u0010\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u0007H\u0002J\b\u0010\u001c\u001a\u00020\u000fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/pubnub/internal/vendor/FileEncryptionUtil;", "", "<init>", "()V", "IV_SIZE_BYTES", "", "ENCODING_UTF_8", "", "CIPHER_TRANSFORMATION", "encrypt", "Ljava/io/InputStream;", "inputStream", "cipherKey", "decrypt", "encryptToBytes", "", "bytesToEncrypt", "encryptToBytes$pubnub_kotlin_impl", "loadIvAndDataFromInputStream", "Lkotlin/Pair;", "inputStreamToEncrypt", "encryptionCipher", "Ljavax/crypto/Cipher;", "keyBytes", "ivBytes", "decryptionCipher", "cipher", "mode", "randomIv", "pubnub-kotlin-impl"})
public final class FileEncryptionUtil {
    @NotNull
    public static final FileEncryptionUtil INSTANCE = new FileEncryptionUtil();
    private static final int IV_SIZE_BYTES = 16;
    @NotNull
    public static final String ENCODING_UTF_8 = "UTF-8";
    @NotNull
    public static final String CIPHER_TRANSFORMATION = "AES/CBC/PKCS5Padding";

    private FileEncryptionUtil() {
    }

    @NotNull
    public final InputStream encrypt(@NotNull InputStream inputStream, @NotNull String cipherKey) throws PubNubException {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Intrinsics.checkNotNullParameter((Object)cipherKey, (String)"cipherKey");
        return new ByteArrayInputStream(this.encryptToBytes$pubnub_kotlin_impl(ByteStreamsKt.readBytes((InputStream)inputStream), cipherKey));
    }

    @NotNull
    public final InputStream decrypt(@NotNull InputStream inputStream, @NotNull String cipherKey) throws PubNubException {
        InputStream inputStream2;
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Intrinsics.checkNotNullParameter((Object)cipherKey, (String)"cipherKey");
        try {
            byte[] keyBytes = this.keyBytes(cipherKey);
            Pair<byte[], byte[]> pair = this.loadIvAndDataFromInputStream(inputStream);
            byte[] ivBytes = (byte[])pair.component1();
            byte[] dataToDecrypt = (byte[])pair.component2();
            Cipher decryptionCipher = this.decryptionCipher(keyBytes, ivBytes);
            byte[] decryptedBytes = decryptionCipher.doFinal(dataToDecrypt);
            inputStream2 = new ByteArrayInputStream(decryptedBytes);
        }
        catch (Exception e) {
            Exception exception = e;
            if (exception instanceof NoSuchAlgorithmException || exception instanceof InvalidAlgorithmParameterException || exception instanceof NoSuchPaddingException || exception instanceof InvalidKeyException || exception instanceof IOException || exception instanceof IllegalBlockSizeException || exception instanceof BadPaddingException) {
                throw new PubNubException(e.getMessage(), null, 2, null);
            }
            throw e;
        }
        return inputStream2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final byte[] encryptToBytes$pubnub_kotlin_impl(@NotNull byte[] bytesToEncrypt, @NotNull String cipherKey) throws PubNubException {
        Intrinsics.checkNotNullParameter((Object)bytesToEncrypt, (String)"bytesToEncrypt");
        Intrinsics.checkNotNullParameter((Object)cipherKey, (String)"cipherKey");
        try {
            Closeable closeable = new ByteArrayOutputStream();
            Throwable throwable = null;
            try {
                ByteArrayOutputStream byteArrayOutputStream = (ByteArrayOutputStream)closeable;
                boolean bl = false;
                byte[] randomIvBytes = INSTANCE.randomIv();
                byteArrayOutputStream.write(randomIvBytes);
                byte[] keyBytes = INSTANCE.keyBytes(cipherKey);
                Cipher encryptionCipher = INSTANCE.encryptionCipher(keyBytes, randomIvBytes);
                byteArrayOutputStream.write(encryptionCipher.doFinal(bytesToEncrypt));
                byte[] byArray = byteArrayOutputStream.toByteArray();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
                byte[] byArray2 = byArray;
                return byArray2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            Exception exception = e;
            if (exception instanceof NoSuchAlgorithmException || exception instanceof InvalidAlgorithmParameterException || exception instanceof NoSuchPaddingException || exception instanceof InvalidKeyException || exception instanceof IOException || exception instanceof BadPaddingException || exception instanceof IllegalBlockSizeException) {
                throw new PubNubException(e.getMessage(), null, 2, null);
            }
            throw e;
        }
    }

    private final Pair<byte[], byte[]> loadIvAndDataFromInputStream(InputStream inputStreamToEncrypt) throws IOException {
        byte[] ivBytes = new byte[16];
        inputStreamToEncrypt.read(ivBytes, 0, 16);
        return TuplesKt.to((Object)ivBytes, (Object)ByteStreamsKt.readBytes((InputStream)inputStreamToEncrypt));
    }

    private final Cipher encryptionCipher(byte[] keyBytes, byte[] ivBytes) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        return this.cipher(keyBytes, ivBytes, 1);
    }

    private final Cipher decryptionCipher(byte[] keyBytes, byte[] ivBytes) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        return this.cipher(keyBytes, ivBytes, 2);
    }

    private final Cipher cipher(byte[] keyBytes, byte[] ivBytes, int mode) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        Cipher cipher = Cipher.getInstance(CIPHER_TRANSFORMATION);
        AlgorithmParameterSpec iv = new IvParameterSpec(ivBytes);
        SecretKeySpec key = new SecretKeySpec(keyBytes, "AES");
        cipher.init(mode, (Key)key, iv);
        Intrinsics.checkNotNull((Object)cipher);
        return cipher;
    }

    private final byte[] keyBytes(String cipherKey) throws UnsupportedEncodingException, PubNubException {
        Charset charset = Charset.forName(ENCODING_UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(...)");
        byte[] byArray = cipherKey.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] byArray2 = Crypto.hexEncode(Crypto.sha256(byArray));
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"hexEncode(...)");
        Object object = byArray2;
        Charset charset2 = Charset.forName(ENCODING_UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"forName(...)");
        Charset charset3 = charset2;
        object = new String((byte[])object, charset3);
        int n = 0;
        int n2 = 32;
        String string = ((String)object).substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        object = string;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string2 = ((String)object).toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        object = string2;
        Charset charset4 = Charset.forName(ENCODING_UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)charset4, (String)"forName(...)");
        Charset charset5 = charset4;
        byte[] byArray3 = ((String)object).getBytes(charset5);
        Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"getBytes(...)");
        return byArray3;
    }

    private final byte[] randomIv() throws NoSuchAlgorithmException {
        byte[] randomIv = new byte[16];
        SecureRandom.getInstance("SHA1PRNG").nextBytes(randomIv);
        return randomIv;
    }
}

