/*
 * Decompiled with CFR 0.152.
 */
package com.pugwoo.dbhelper;

import com.pugwoo.dbhelper.DBHelperInterceptor;
import com.pugwoo.dbhelper.IDBHelperSlowSqlCallback;
import com.pugwoo.dbhelper.enums.DatabaseTypeEnum;
import com.pugwoo.dbhelper.enums.FeatureEnum;
import com.pugwoo.dbhelper.exception.NullKeyValueException;
import com.pugwoo.dbhelper.impl.DBHelperContext;
import com.pugwoo.dbhelper.model.PageData;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface DBHelper {
    public static final Logger LOGGER = LoggerFactory.getLogger(DBHelper.class);

    public static void withTableNames(Map<Class<?>, String> tableNames, Runnable runnable) {
        if (runnable == null) {
            LOGGER.error("withTableNames runnable is null");
            return;
        }
        HashMap oldTableNames = new HashMap();
        if (tableNames != null) {
            tableNames.forEach((clazz, tableName) -> {
                String oldTableName = DBHelperContext.getTableName(clazz);
                oldTableNames.put(clazz, oldTableName);
                DBHelperContext.setTableName(clazz, tableName);
            });
        }
        try {
            runnable.run();
        }
        finally {
            if (tableNames != null) {
                tableNames.forEach((clazz, tableName) -> DBHelperContext.setTableName(clazz, (String)oldTableNames.get(clazz)));
            }
        }
    }

    public static void setGlobalComment(String comment) {
        DBHelperContext.setGlobalComment(comment);
    }

    public static void setLocalComment(String comment) {
        DBHelperContext.setThreadLocalComment(comment);
    }

    public static void enableCache() {
        DBHelperContext.enableCache();
    }

    public static void disableCache() {
        DBHelperContext.disableCache();
    }

    public static boolean isCacheEnabled() {
        return DBHelperContext.isCacheEnabled();
    }

    public void turnOnFeature(FeatureEnum var1);

    public void turnOffFeature(FeatureEnum var1);

    public DatabaseTypeEnum getDatabaseType();

    public void rollback();

    public boolean executeAfterCommit(Runnable var1);

    public void setTimeoutWarningValve(long var1);

    public void setMaxPageSize(int var1);

    public void setFetchSize(int var1);

    public void setTimeoutWarningCallback(IDBHelperSlowSqlCallback var1);

    public void setInterceptors(List<DBHelperInterceptor> var1);

    public <T> T getByKey(Class<T> var1, Object var2) throws NullKeyValueException;

    public <T> PageData<T> getPage(Class<T> var1, int var2, int var3);

    public <T> PageData<T> getPage(Class<T> var1, int var2, int var3, String var4, Object ... var5);

    public <T> long getCount(Class<T> var1);

    public <T> long getCount(Class<T> var1, String var2, Object ... var3);

    public <T> PageData<T> getPageWithoutCount(Class<T> var1, int var2, int var3);

    public <T> PageData<T> getPageWithoutCount(Class<T> var1, int var2, int var3, String var4, Object ... var5);

    public <T> List<T> getAll(Class<T> var1);

    public <T> Stream<T> getAllForStream(Class<T> var1);

    public <T> List<T> getAll(Class<T> var1, String var2, Object ... var3);

    public <T> Stream<T> getAllForStream(Class<T> var1, String var2, Object ... var3);

    public <T> List<T> getAllKey(Class<T> var1, String var2, Object ... var3);

    public <T> T getOne(Class<T> var1);

    public <T> T getOne(Class<T> var1, String var2, Object ... var3);

    public <T> List<T> getRaw(Class<T> var1, String var2, Object ... var3);

    public <T> List<T> getRaw(Class<T> var1, String var2, Map<String, ?> var3);

    public <T> Stream<T> getRawForStream(Class<T> var1, String var2, Object ... var3);

    public <T> Stream<T> getRawForStream(Class<T> var1, String var2, Map<String, ?> var3);

    public <T> T getRawOne(Class<T> var1, String var2, Object ... var3);

    public <T> T getRawOne(Class<T> var1, String var2, Map<String, ?> var3);

    public <T> List<T> getByExample(T var1, int var2);

    public <T> boolean isExist(Class<T> var1, String var2, Object ... var3);

    public <T> boolean isExistAtLeast(int var1, Class<T> var2, String var3, Object ... var4);

    public <T> void handleRelatedColumn(T var1);

    public <T> void handleRelatedColumn(List<T> var1);

    public <T> void handleRelatedColumn(T var1, String ... var2);

    public <T> void handleRelatedColumn(List<T> var1, String ... var2);

    public <T> int insert(T var1);

    public int insert(Collection<?> var1);

    public <T> int insertBatchWithoutReturnId(Collection<T> var1);

    public int insertBatchWithoutReturnId(String var1, Collection<Map<String, Object>> var2);

    public int insertBatchWithoutReturnId(String var1, List<String> var2, Collection<Object[]> var3);

    public <T> int insertWithNull(T var1);

    public <T> int insertOrUpdate(T var1);

    public <T> int insertOrUpdateWithNull(T var1);

    public <T> int insertOrUpdate(Collection<T> var1);

    public <T> int updateWithNull(T var1) throws NullKeyValueException;

    public <T> int updateWithNull(T var1, String var2, Object ... var3) throws NullKeyValueException;

    public <T> int update(T var1) throws NullKeyValueException;

    public <T> int update(T var1, String var2, Object ... var3) throws NullKeyValueException;

    public <T> int updateCustom(T var1, String var2, Object ... var3) throws NullKeyValueException;

    public <T> int updateAll(Class<T> var1, String var2, String var3, Object ... var4);

    public <T> int update(Collection<T> var1) throws NullKeyValueException;

    public <T> int delete(T var1) throws NullKeyValueException;

    public <T> int deleteHard(T var1) throws NullKeyValueException;

    public <T> int delete(Collection<T> var1) throws NullKeyValueException;

    public <T> int deleteHard(Collection<T> var1) throws NullKeyValueException;

    public <T> int delete(Class<T> var1, String var2, Object ... var3);

    public <T> int deleteHard(Class<T> var1, String var2, Object ... var3);

    public int executeRaw(String var1, Object ... var2);

    public int executeRaw(String var1, Map<String, ?> var2);
}

