/*
 * Decompiled with CFR 0.152.
 */
package com.pugwoo.dbhelper.cache;

import com.pugwoo.dbhelper.annotation.Column;
import com.pugwoo.dbhelper.annotation.RelatedColumn;
import com.pugwoo.dbhelper.annotation.Table;
import com.pugwoo.dbhelper.impl.DBHelperContext;
import com.pugwoo.dbhelper.utils.InnerCommonUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassInfoCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClassInfoCache.class);
    private static final Map<Field, Method> fieldSetMethodMap = new ConcurrentHashMap<Field, Method>();
    private static final Map<Field, Boolean> fieldSetMethodNullMap = new ConcurrentHashMap<Field, Boolean>();
    private static final Map<Field, Method> fieldGetMethodMap = new ConcurrentHashMap<Field, Method>();
    private static final Map<Field, Boolean> fieldGetMethodNullMap = new ConcurrentHashMap<Field, Boolean>();
    private static final Map<Class<?>, List<Field>> classFieldMap = new ConcurrentHashMap();
    private static final Map<Class<?>, Table> classTableMap = new ConcurrentHashMap();
    private static final Map<Class<?>, List<Field>> relatedColumnMap = new ConcurrentHashMap();

    public static Method getFieldSetMethod(Field field) {
        boolean isCacheEnable = DBHelperContext.isCacheEnabled();
        Method method = null;
        if (isCacheEnable) {
            method = fieldSetMethodMap.get(field);
            if (method != null) {
                return method;
            }
            Boolean isNull = fieldSetMethodNullMap.get(field);
            if (isNull != null && isNull.booleanValue()) {
                return null;
            }
        }
        String fieldName = field.getName();
        String setMethodName = "set" + InnerCommonUtils.firstLetterUpperCase(fieldName);
        try {
            method = field.getDeclaringClass().getMethod(setMethodName, field.getType());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (isCacheEnable) {
            if (method == null) {
                fieldSetMethodNullMap.put(field, true);
            } else {
                method.setAccessible(true);
                fieldSetMethodMap.put(field, method);
            }
        }
        return method;
    }

    public static Method getFieldGetMethod(Field field) {
        boolean isCacheEnable = DBHelperContext.isCacheEnabled();
        Method method = null;
        if (isCacheEnable) {
            method = fieldGetMethodMap.get(field);
            if (method != null) {
                return method;
            }
            Boolean isNull = fieldGetMethodNullMap.get(field);
            if (isNull != null && isNull.booleanValue()) {
                return null;
            }
        }
        String fieldName = field.getName();
        String getMethodName = "get" + InnerCommonUtils.firstLetterUpperCase(fieldName);
        try {
            method = field.getDeclaringClass().getMethod(getMethodName, new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (isCacheEnable) {
            if (method == null) {
                fieldGetMethodNullMap.put(field, true);
            } else {
                method.setAccessible(true);
                fieldGetMethodMap.put(field, method);
            }
        }
        return method;
    }

    public static List<Field> getColumnFields(Class<?> clazz) {
        List<Field> fields;
        boolean isCacheEnable = DBHelperContext.isCacheEnabled();
        if (isCacheEnable && (fields = classFieldMap.get(clazz)) != null) {
            return fields;
        }
        List<Class<?>> classLink = ClassInfoCache.getClassAndParentClasses(clazz);
        fields = ClassInfoCache.getFields(classLink);
        if (isCacheEnable) {
            classFieldMap.put(clazz, fields);
        }
        return fields;
    }

    private static List<Class<?>> getClassAndParentClasses(Class<?> clazz) {
        if (clazz == null) {
            return new ArrayList();
        }
        ArrayList classLink = new ArrayList();
        for (Class<?> curClass = clazz; curClass != null; curClass = curClass.getSuperclass()) {
            classLink.add(curClass);
        }
        return classLink;
    }

    private static List<Field> getFields(List<Class<?>> classLink) {
        ArrayList<Field> result = new ArrayList<Field>();
        if (classLink == null || classLink.isEmpty()) {
            return result;
        }
        ArrayList<List<Field>> fieldList = new ArrayList<List<Field>>();
        for (int i = classLink.size() - 1; i >= 0; --i) {
            Field[] fields = classLink.get(i).getDeclaredFields();
            fieldList.add(InnerCommonUtils.filter(fields, o -> o.getAnnotation(Column.class) != null));
        }
        HashSet<String> columnValues = new HashSet<String>();
        ArrayList fieldListTmp = new ArrayList();
        for (int i = fieldList.size() - 1; i >= 0; --i) {
            List list = (List)fieldList.get(i);
            ArrayList<Field> fieldsTmp = new ArrayList<Field>();
            for (Field field : list) {
                Column column = field.getAnnotation(Column.class);
                if (columnValues.contains(column.value())) {
                    LOGGER.error("found duplicate field:{} in class(and its parents):{}, this field is ignored", (Object)field.getName(), (Object)classLink.get(0).getName());
                    continue;
                }
                columnValues.add(column.value());
                fieldsTmp.add(field);
            }
            fieldListTmp.add(0, fieldsTmp);
        }
        for (List list : fieldListTmp) {
            result.addAll(list);
        }
        return result;
    }

    public static Table getTable(Class<?> clazz) {
        Table table;
        boolean isCacheEnable = DBHelperContext.isCacheEnabled();
        if (isCacheEnable && (table = classTableMap.get(clazz)) != null) {
            return table;
        }
        table = ClassInfoCache.getAnnotationClass(clazz, Table.class);
        if (isCacheEnable && table != null) {
            classTableMap.put(clazz, table);
        }
        return table;
    }

    private static <T extends Annotation> T getAnnotationClass(Class<?> clazz, Class<T> annotationClass) {
        for (Class<?> curClass = clazz; curClass != null; curClass = curClass.getSuperclass()) {
            T annotation = curClass.getAnnotation(annotationClass);
            if (annotation == null) continue;
            return annotation;
        }
        return null;
    }

    public static List<Field> getRelatedColumns(Class<?> clazz) {
        List<Field> fields;
        boolean isCacheEnable = DBHelperContext.isCacheEnabled();
        if (isCacheEnable && (fields = relatedColumnMap.get(clazz)) != null) {
            return fields;
        }
        List<Class<?>> classLink = ClassInfoCache.getClassAndParentClasses(clazz);
        fields = new ArrayList<Field>();
        for (int i = classLink.size() - 1; i >= 0; --i) {
            Field[] f;
            for (Field field : f = classLink.get(i).getDeclaredFields()) {
                if (field.getAnnotation(RelatedColumn.class) == null) continue;
                fields.add(field);
            }
        }
        if (isCacheEnable) {
            relatedColumnMap.put(clazz, fields);
        }
        return fields;
    }
}

