/*
 * Decompiled with CFR 0.152.
 */
package com.pugwoo.dbhelper.enums;

import java.util.Objects;

public enum DatabaseTypeEnum {
    UNKNOWN("UNKNOWN", "Unknown"),
    MYSQL("MYSQL", "MySQL"),
    CLICKHOUSE("CLICKHOUSE", "ClickHouse"),
    POSTGRESQL("POSTGRESQL", "Postgresql");

    private final String code;
    private final String name;

    private DatabaseTypeEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public static DatabaseTypeEnum getByJdbcProtocol(String jdbcProtocol) {
        if ("mysql".equalsIgnoreCase(jdbcProtocol)) {
            return MYSQL;
        }
        if ("clickhouse".equalsIgnoreCase(jdbcProtocol) || "ch".equalsIgnoreCase(jdbcProtocol)) {
            return CLICKHOUSE;
        }
        if ("postgresql".equalsIgnoreCase(jdbcProtocol) || "pgsql".equalsIgnoreCase(jdbcProtocol)) {
            return POSTGRESQL;
        }
        return UNKNOWN;
    }

    public static DatabaseTypeEnum getByCode(String code) {
        for (DatabaseTypeEnum e : DatabaseTypeEnum.values()) {
            if (!Objects.equals(code, e.getCode())) continue;
            return e;
        }
        return UNKNOWN;
    }

    public static String getNameByCode(String code) {
        DatabaseTypeEnum e = DatabaseTypeEnum.getByCode(code);
        return e == null ? "" : e.getName();
    }

    public String getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }
}

