/*
 * Decompiled with CFR 0.152.
 */
package com.pugwoo.dbhelper.impl;

import com.pugwoo.dbhelper.utils.InnerCommonUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBHelperContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(DBHelperContext.class);
    private static final ThreadLocal<Map<Class<?>, String>> tableNames = new ThreadLocal();
    private static String globalComment;
    private static final ThreadLocal<String> comment;
    private static boolean isCacheEnabled;
    private static final Map<String, Map<Class<?>, Object>> insertDefaultValueMap;

    private static Map<Class<?>, Object> defaultValueMap() {
        ConcurrentHashMap map = new ConcurrentHashMap();
        map.put(Integer.class, 0);
        map.put(Long.class, 0L);
        map.put(Float.class, Float.valueOf(0.0f));
        map.put(Double.class, 0.0);
        map.put(Boolean.class, false);
        map.put(String.class, "");
        map.put(java.util.Date.class, new java.util.Date(0L));
        map.put(Date.class, new Date(0L));
        map.put(Timestamp.class, new Timestamp(0L));
        map.put(Time.class, new Time(0L));
        map.put(BigDecimal.class, new BigDecimal(0));
        map.put(BigInteger.class, new BigInteger("0"));
        map.put(LocalDate.class, LocalDate.of(1970, 1, 1));
        map.put(LocalDateTime.class, LocalDateTime.of(1970, 1, 1, 0, 0, 0));
        map.put(LocalTime.class, LocalTime.of(0, 0, 0));
        return map;
    }

    public static String getTableName(Class<?> clazz) {
        Map<Class<?>, String> tableNames = DBHelperContext.tableNames.get();
        if (tableNames == null) {
            return null;
        }
        return tableNames.get(clazz);
    }

    public static void setTableName(Class<?> clazz, String tableName) {
        Map<Class<?>, String> tableNames;
        if (clazz == null) {
            return;
        }
        if (tableName == null && (tableNames = DBHelperContext.tableNames.get()) != null) {
            tableNames.remove(clazz);
        }
        if (InnerCommonUtils.isBlank(tableName)) {
            return;
        }
        tableNames = DBHelperContext.tableNames.get();
        if (tableNames == null) {
            tableNames = new HashMap();
            DBHelperContext.tableNames.set(tableNames);
        }
        tableNames.put(clazz, tableName);
    }

    public static void resetTableName() {
        tableNames.set(null);
    }

    public static void setGlobalComment(String comment) {
        globalComment = comment;
    }

    public static String getGlobalComment() {
        return globalComment;
    }

    public static void setThreadLocalComment(String comment) {
        DBHelperContext.comment.set(comment);
    }

    public static String getThreadLocalComment() {
        return comment.get();
    }

    public static synchronized void enableCache() {
        isCacheEnabled = true;
    }

    public static synchronized void disableCache() {
        isCacheEnabled = false;
    }

    public static boolean isCacheEnabled() {
        return isCacheEnabled;
    }

    public static Map<Class<?>, Object> getInsertDefaultValueMap(String insertDefaultValueMapName) {
        if (InnerCommonUtils.isBlank(insertDefaultValueMapName)) {
            return null;
        }
        Map<Class<?>, Object> map = insertDefaultValueMap.get(insertDefaultValueMapName);
        if (map == null) {
            LOGGER.error("getInsertDefaultValueMap is not exist, insertDefaultValueMapName:{}", (Object)insertDefaultValueMapName);
        }
        return map;
    }

    public static void setInsertDefaultValue(String insertDefaultValueMapName, Class<?> clazz, Object value) {
        if (InnerCommonUtils.isBlank(insertDefaultValueMapName)) {
            LOGGER.error("setInsertDefaultValue insertDefaultValueMapName is blank, ignore set");
            return;
        }
        if (clazz == null) {
            LOGGER.error("setInsertDefaultValue clazz is null, ignore set");
            return;
        }
        Map<Class<?>, Object> map = insertDefaultValueMap.get(insertDefaultValueMapName);
        if (map == null) {
            map = new ConcurrentHashMap();
            insertDefaultValueMap.put(insertDefaultValueMapName, map);
        }
        map.put(clazz, value);
    }

    static {
        comment = new ThreadLocal();
        isCacheEnabled = true;
        insertDefaultValueMap = new ConcurrentHashMap();
        Map<Class<?>, Object> clickhouse = DBHelperContext.defaultValueMap();
        insertDefaultValueMap.put("clickhouse", clickhouse);
        Map<Class<?>, Object> mysql = DBHelperContext.defaultValueMap();
        insertDefaultValueMap.put("mysql", mysql);
    }
}

