/*
 * Decompiled with CFR 0.152.
 */
package com.pugwoo.dbhelper.impl.part;

import com.pugwoo.dbhelper.DBHelper;
import com.pugwoo.dbhelper.DBHelperInterceptor;
import com.pugwoo.dbhelper.IDBHelperSlowSqlCallback;
import com.pugwoo.dbhelper.enums.DatabaseTypeEnum;
import com.pugwoo.dbhelper.enums.FeatureEnum;
import com.pugwoo.dbhelper.impl.DBHelperContext;
import com.pugwoo.dbhelper.impl.SpringJdbcDBHelper;
import com.pugwoo.dbhelper.json.NimbleOrmJSON;
import com.pugwoo.dbhelper.utils.InnerCommonUtils;
import com.pugwoo.dbhelper.utils.NamedParameterUtils;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.transaction.interceptor.TransactionAspectSupport;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public abstract class P0_JdbcTemplateOp
implements DBHelper,
ApplicationContextAware {
    protected static final Logger LOGGER = LoggerFactory.getLogger(SpringJdbcDBHelper.class);
    protected JdbcTemplate jdbcTemplate;
    private DatabaseTypeEnum databaseType;
    protected NamedParameterJdbcTemplate namedParameterJdbcTemplate;
    protected long timeoutWarningValve = 1000L;
    protected Integer maxPageSize = null;
    protected int fetchSize = 1000;
    protected ApplicationContext applicationContext;
    protected List<DBHelperInterceptor> interceptors = new ArrayList<DBHelperInterceptor>();
    protected Map<FeatureEnum, Boolean> features = new ConcurrentHashMap<FeatureEnum, Boolean>(){
        {
            this.put(FeatureEnum.AUTO_SUM_NULL_TO_ZERO, true);
            this.put(FeatureEnum.LOG_SQL_AT_INFO_LEVEL, false);
            this.put(FeatureEnum.THROW_EXCEPTION_IF_COLUMN_NOT_EXIST, false);
            this.put(FeatureEnum.AUTO_ADD_ORDER_FOR_PAGINATION, true);
            this.put(FeatureEnum.AUTO_EXPLAIN_SLOW_SQL, true);
        }
    };
    private IDBHelperSlowSqlCallback slowSqlCallback;

    protected void log(String sql, int batchSize, Object args) {
        if (batchSize > 0) {
            if (this.features.get((Object)FeatureEnum.LOG_SQL_AT_INFO_LEVEL).booleanValue()) {
                LOGGER.info("Batch ExecSQL:{}; batch size:{}, first row params:{}", new Object[]{sql, batchSize, NimbleOrmJSON.toJson(args)});
            } else {
                LOGGER.debug("Batch ExecSQL:{}; batch size:{}, first row params:{}", new Object[]{sql, batchSize, NimbleOrmJSON.toJson(args)});
            }
        } else if (this.features.get((Object)FeatureEnum.LOG_SQL_AT_INFO_LEVEL).booleanValue()) {
            LOGGER.info("ExecSQL:{}; params:{}", (Object)sql, (Object)NimbleOrmJSON.toJson(args));
        } else {
            LOGGER.debug("ExecSQL:{}; params:{}", (Object)sql, (Object)NimbleOrmJSON.toJson(args));
        }
    }

    protected void logSlow(long cost, String sql, int batchSize, Object args) {
        block23: {
            if (cost > this.timeoutWarningValve) {
                if (batchSize > 0) {
                    LOGGER.warn("SlowSQL:{}; cost:{}ms, listSize:{}, params:{}", new Object[]{sql, cost, batchSize, NimbleOrmJSON.toJson(args)});
                    try {
                        if (this.slowSqlCallback == null) break block23;
                        if (args instanceof List) {
                            this.slowSqlCallback.callback(cost, sql, (List)args);
                            break block23;
                        }
                        if (args instanceof Object[]) {
                            this.slowSqlCallback.callback(cost, sql, Arrays.asList((Object[])args));
                            break block23;
                        }
                        this.slowSqlCallback.callback(cost, sql, Collections.singletonList(args));
                    }
                    catch (Throwable e) {
                        LOGGER.error("DBHelperSlowSqlCallback fail, SlowSQL:{}; cost:{}ms, listSize:{}, params:{}", new Object[]{sql, cost, batchSize, NimbleOrmJSON.toJson(args), e});
                    }
                } else {
                    LOGGER.warn("SlowSQL:{}; cost:{}ms, params:{}", new Object[]{sql, cost, NimbleOrmJSON.toJson(args)});
                    try {
                        if (this.slowSqlCallback != null) {
                            if (args instanceof List) {
                                this.slowSqlCallback.callback(cost, sql, (List)args);
                            } else if (args instanceof Object[]) {
                                this.slowSqlCallback.callback(cost, sql, Arrays.asList((Object[])args));
                            } else {
                                this.slowSqlCallback.callback(cost, sql, Collections.singletonList(args));
                            }
                        }
                    }
                    catch (Throwable e) {
                        LOGGER.error("DBHelperSlowSqlCallback fail, SlowSQL:{}; cost:{}ms, params:{}", new Object[]{sql, cost, NimbleOrmJSON.toJson(args), e});
                    }
                    boolean autoExplainSlowSql = this.getFeature(FeatureEnum.AUTO_EXPLAIN_SLOW_SQL);
                    if (autoExplainSlowSql && this.getDatabaseType() == DatabaseTypeEnum.MYSQL) {
                        try {
                            String explainSql = "EXPLAIN " + sql;
                            List<Object> explainArgs = new ArrayList();
                            boolean isMap = false;
                            if (args != null) {
                                if (args instanceof List) {
                                    explainArgs = (List)args;
                                } else if (args instanceof Object[]) {
                                    explainArgs = Arrays.asList((Object[])args);
                                } else if (args instanceof Map) {
                                    isMap = true;
                                }
                            }
                            List explainResult = !isMap ? this.namedParameterJdbcTemplate.queryForList(NamedParameterUtils.trans(explainSql, explainArgs), NamedParameterUtils.transParam(explainArgs)) : this.namedParameterJdbcTemplate.queryForList(explainSql, (Map)args);
                            LOGGER.warn("Explain SlowSQL:{}; cost:{}ms, params:{} explain result:{}", new Object[]{sql, cost, NimbleOrmJSON.toJson(args), NimbleOrmJSON.toJson(explainResult)});
                        }
                        catch (Throwable e) {
                            LOGGER.error("SlowSQL explain fail, SlowSQL:{}; cost:{}ms, params:{}", new Object[]{sql, cost, NimbleOrmJSON.toJson(args), e});
                        }
                    }
                }
            }
        }
    }

    @Override
    public void rollback() {
        TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
    }

    @Override
    public boolean executeAfterCommit(final Runnable runnable) {
        if (runnable == null) {
            return false;
        }
        if (!TransactionSynchronizationManager.isActualTransactionActive()) {
            return false;
        }
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronization(){

            public void afterCommit() {
                runnable.run();
            }
        });
        return true;
    }

    protected int jdbcExecuteUpdate(String sql, Object ... args) {
        sql = this.addComment(sql);
        this.log(sql, 0, args);
        long start = System.currentTimeMillis();
        int rows = this.jdbcTemplate.update(sql, args);
        long cost = System.currentTimeMillis() - start;
        this.logSlow(cost, sql, 0, args == null ? new ArrayList() : Arrays.asList(args));
        return rows;
    }

    protected int namedJdbcExecuteUpdate(String sql, Object ... args) {
        sql = this.addComment(sql);
        this.log(sql, 0, args);
        long start = System.currentTimeMillis();
        ArrayList<Object> argsList = new ArrayList<Object>();
        if (args != null) {
            argsList.addAll(Arrays.asList(args));
        }
        int rows = this.namedParameterJdbcTemplate.update(NamedParameterUtils.trans(sql, argsList), NamedParameterUtils.transParam(argsList));
        long cost = System.currentTimeMillis() - start;
        this.logSlow(cost, sql, 0, argsList);
        return rows;
    }

    protected int namedJdbcExecuteUpdateWithLog(String sql, String logSql, int batchSize, List<Object> logArgs, Object ... args) {
        sql = this.addComment(sql);
        this.log(logSql, batchSize, logArgs);
        long start = System.currentTimeMillis();
        ArrayList<Object> argsList = new ArrayList<Object>();
        if (args != null) {
            argsList.addAll(Arrays.asList(args));
        }
        int rows = this.namedParameterJdbcTemplate.update(NamedParameterUtils.trans(sql, argsList), NamedParameterUtils.transParam(argsList));
        long cost = System.currentTimeMillis() - start;
        this.logSlow(cost, logSql, batchSize, logArgs);
        return rows;
    }

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        if (jdbcTemplate == null) {
            return;
        }
        this.jdbcTemplate = jdbcTemplate;
        this.namedParameterJdbcTemplate = new NamedParameterJdbcTemplate((JdbcOperations)jdbcTemplate);
        this.databaseType = this.getDatabaseType(jdbcTemplate);
    }

    public void setNamedParameterJdbcTemplate(NamedParameterJdbcTemplate namedParameterJdbcTemplate) {
        this.namedParameterJdbcTemplate = namedParameterJdbcTemplate;
    }

    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    public NamedParameterJdbcTemplate getNamedParameterJdbcTemplate() {
        return this.namedParameterJdbcTemplate;
    }

    @Override
    public void setTimeoutWarningValve(long timeMS) {
        this.timeoutWarningValve = timeMS;
    }

    @Override
    public void setMaxPageSize(int maxPageSize) {
        this.maxPageSize = maxPageSize;
    }

    @Override
    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Override
    public void setInterceptors(List<DBHelperInterceptor> interceptors) {
        if (interceptors != null) {
            for (DBHelperInterceptor interceptor : interceptors) {
                if (interceptor == null) continue;
                this.interceptors.add(interceptor);
            }
        }
    }

    @Override
    public void setTimeoutWarningCallback(IDBHelperSlowSqlCallback callback) {
        this.slowSqlCallback = callback;
    }

    @Override
    public void turnOnFeature(FeatureEnum featureEnum) {
        this.features.put(featureEnum, true);
    }

    @Override
    public void turnOffFeature(FeatureEnum featureEnum) {
        this.features.put(featureEnum, false);
    }

    public boolean getFeature(FeatureEnum featureEnum) {
        Boolean enabled = this.features.get((Object)featureEnum);
        return enabled != null && enabled != false;
    }

    protected String addComment(String sql) {
        String comment;
        String globalComment = DBHelperContext.getGlobalComment();
        if (InnerCommonUtils.isNotBlank(globalComment)) {
            sql = "/*" + globalComment + "*/" + sql;
        }
        if (InnerCommonUtils.isNotBlank(comment = DBHelperContext.getThreadLocalComment())) {
            sql = "/*" + comment + "*/" + sql;
        }
        return sql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DatabaseTypeEnum getDatabaseType(JdbcTemplate jdbcTemplate) {
        DataSource dataSource = jdbcTemplate.getDataSource();
        if (dataSource == null) {
            LOGGER.error("fail to get database type from jdbc url, dataSource is null, jdbcTemplate:{}, will try later", (Object)jdbcTemplate);
            return null;
        }
        Connection connection = null;
        try {
            connection = dataSource.getConnection();
            String url = connection.getMetaData().getURL();
            String type = url.split(":")[1];
            DatabaseTypeEnum databaseTypeEnum = DatabaseTypeEnum.getByJdbcProtocol(type);
            return databaseTypeEnum;
        }
        catch (Exception e) {
            LOGGER.error("fail to get database type from jdbc url, jdbcTemplate:{}, will try later", (Object)jdbcTemplate, (Object)e);
            DatabaseTypeEnum databaseTypeEnum = null;
            return databaseTypeEnum;
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception e) {
                    LOGGER.error("fail to close connection, jdbcTemplate:{}, ignored", (Object)jdbcTemplate, (Object)e);
                }
            }
        }
    }

    @Override
    public DatabaseTypeEnum getDatabaseType() {
        if (this.databaseType == null) {
            this.databaseType = this.getDatabaseType(this.jdbcTemplate);
        }
        return this.databaseType;
    }
}

