/*
 * Decompiled with CFR 0.152.
 */
package com.pugwoo.dbhelper.impl.part;

import com.pugwoo.dbhelper.DBHelperInterceptor;
import com.pugwoo.dbhelper.IDBHelperDataService;
import com.pugwoo.dbhelper.annotation.Column;
import com.pugwoo.dbhelper.annotation.JoinTable;
import com.pugwoo.dbhelper.annotation.RelatedColumn;
import com.pugwoo.dbhelper.enums.FeatureEnum;
import com.pugwoo.dbhelper.exception.BadSQLSyntaxException;
import com.pugwoo.dbhelper.exception.InvalidParameterException;
import com.pugwoo.dbhelper.exception.NotAllowQueryException;
import com.pugwoo.dbhelper.exception.NotOnlyOneKeyColumnException;
import com.pugwoo.dbhelper.exception.NullKeyValueException;
import com.pugwoo.dbhelper.exception.RelatedColumnFieldNotFoundException;
import com.pugwoo.dbhelper.exception.SpringBeanNotMatchException;
import com.pugwoo.dbhelper.impl.part.P0_JdbcTemplateOp;
import com.pugwoo.dbhelper.json.NimbleOrmJSON;
import com.pugwoo.dbhelper.model.PageData;
import com.pugwoo.dbhelper.sql.SQLAssert;
import com.pugwoo.dbhelper.sql.SQLUtils;
import com.pugwoo.dbhelper.utils.AnnotationSupportRowMapper;
import com.pugwoo.dbhelper.utils.DOInfoReader;
import com.pugwoo.dbhelper.utils.InnerCommonUtils;
import com.pugwoo.dbhelper.utils.NamedParameterUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import net.sf.jsqlparser.JSQLParserException;
import org.mvel2.MVEL;

public abstract class P1_QueryOp
extends P0_JdbcTemplateOp {
    @Override
    public <T> T getByKey(Class<T> clazz, Object keyValue) throws NullKeyValueException, NotOnlyOneKeyColumnException {
        this.assertNotVirtualTable(clazz);
        if (keyValue == null) {
            throw new NullKeyValueException();
        }
        SQLAssert.onlyOneKeyColumn(clazz);
        String where = SQLUtils.getKeysWhereSQLWithoutSoftDelete(this.getDatabaseType(), clazz);
        return this.getOne(clazz, where, keyValue);
    }

    @Override
    public <T> PageData<T> getPage(Class<T> clazz, int page, int pageSize, String postSql, Object ... args) {
        this.assertPage(page);
        if (this.maxPageSize != null && pageSize > this.maxPageSize) {
            LOGGER.warn("query class:{} pageSize {} is too large, set to maxPageSize {}", new Object[]{clazz, pageSize, this.maxPageSize});
            pageSize = this.maxPageSize;
        }
        int offset = (page - 1) * pageSize;
        return this._getPage(clazz, true, false, true, offset, pageSize, postSql, args);
    }

    @Override
    public <T> PageData<T> getPage(Class<T> clazz, int page, int pageSize) {
        return this.getPage(clazz, page, pageSize, null, new Object[0]);
    }

    @Override
    public <T> long getCount(Class<T> clazz) {
        boolean isVirtualTable = DOInfoReader.isVirtualTable(clazz);
        String sql = SQLUtils.getSelectCountSQL(this.getDatabaseType(), clazz) + (isVirtualTable ? "" : SQLUtils.autoSetSoftDeleted(this.getDatabaseType(), "", clazz));
        sql = this.addComment(sql);
        this.log(sql, 0, null);
        long start = System.currentTimeMillis();
        Long rows = (Long)this.jdbcTemplate.queryForObject(sql, Long.class);
        long cost = System.currentTimeMillis() - start;
        this.logSlow(cost, sql, 0, null);
        return rows == null ? 0L : rows;
    }

    @Override
    public <T> long getCount(Class<T> clazz, String postSql, Object ... args) {
        boolean isVirtualTable = DOInfoReader.isVirtualTable(clazz);
        String sqlSB = "SELECT count(*) FROM (" + SQLUtils.getSelectSQL(this.getDatabaseType(), clazz, false, true, this.features, postSql) + (isVirtualTable ? (postSql == null ? "\n" : "\n" + postSql) : SQLUtils.autoSetSoftDeleted(this.getDatabaseType(), postSql, clazz)) + ") tff305c6";
        ArrayList<Object> argsList = new ArrayList<Object>();
        if (args != null) {
            argsList.addAll(Arrays.asList(args));
        }
        String sql = sqlSB;
        sql = this.addComment(sql);
        this.log(sql, 0, argsList);
        long start = System.currentTimeMillis();
        Long rows = argsList.isEmpty() ? (Long)this.namedParameterJdbcTemplate.queryForObject(sql, new HashMap(), Long.class) : (Long)this.namedParameterJdbcTemplate.queryForObject(NamedParameterUtils.trans(sql, argsList), NamedParameterUtils.transParam(argsList), Long.class);
        long cost = System.currentTimeMillis() - start;
        this.logSlow(cost, sql, 0, null);
        return rows == null ? 0L : rows;
    }

    @Override
    public <T> PageData<T> getPageWithoutCount(Class<T> clazz, int page, int pageSize, String postSql, Object ... args) {
        this.assertPage(page);
        if (this.maxPageSize != null && pageSize > this.maxPageSize) {
            LOGGER.warn("query class:{} pageSize {} is too large, set to maxPageSize {}", new Object[]{clazz, pageSize, this.maxPageSize});
            pageSize = this.maxPageSize;
        }
        int offset = (page - 1) * pageSize;
        return this._getPage(clazz, true, false, false, offset, pageSize, postSql, args);
    }

    @Override
    public <T> PageData<T> getPageWithoutCount(Class<T> clazz, int page, int pageSize) {
        return this.getPageWithoutCount(clazz, page, pageSize, null, new Object[0]);
    }

    @Override
    public <T> List<T> getAll(Class<T> clazz) {
        return this._getPage(clazz, true, false, false, null, null, null, new Object[0]).getData();
    }

    @Override
    public <T> Stream<T> getAllForStream(Class<T> clazz) {
        return this.getAllForStream(clazz, "", new Object[0]);
    }

    @Override
    public <T> Stream<T> getAllForStream(Class<T> clazz, String postSql, Object ... args) {
        this.jdbcTemplate.setFetchSize(this.fetchSize);
        StringBuilder sqlSB = new StringBuilder();
        sqlSB.append(SQLUtils.getSelectSQL(this.getDatabaseType(), clazz, false, false, this.features, postSql));
        sqlSB.append(SQLUtils.autoSetSoftDeleted(this.getDatabaseType(), postSql, clazz));
        ArrayList<Object> argsList = new ArrayList<Object>();
        if (args != null) {
            argsList.addAll(Arrays.asList(args));
        }
        this.doInterceptBeforeQuery(clazz, sqlSB, argsList);
        String sql = sqlSB.toString();
        sql = this.addComment(sql);
        this.log(sql, 0, argsList);
        long start = System.currentTimeMillis();
        AnnotationSupportRowMapper<T> mapper = new AnnotationSupportRowMapper<T>(this, clazz);
        Stream<Object> list = argsList.isEmpty() ? this.jdbcTemplate.queryForStream(sql, mapper) : this.namedParameterJdbcTemplate.queryForStream(NamedParameterUtils.trans(sql, argsList), NamedParameterUtils.transParam(argsList), mapper);
        List<Field> relatedColumns = DOInfoReader.getRelatedColumns(clazz);
        Stream result = !relatedColumns.isEmpty() ? InnerCommonUtils.partition(list, this.fetchSize).peek(this::handleRelatedColumn).flatMap(Collection::stream) : list;
        long cost = System.currentTimeMillis() - start;
        this.logSlow(cost, sql, 0, argsList);
        return result;
    }

    @Override
    public <T> List<T> getAll(Class<T> clazz, String postSql, Object ... args) {
        return this._getPage(clazz, true, false, false, null, null, postSql, args).getData();
    }

    @Override
    public <T> List<T> getAllKey(Class<T> clazz, String postSql, Object ... args) {
        this.assertNotVirtualTable(clazz);
        return this._getPage(clazz, true, true, false, null, null, postSql, args).getData();
    }

    @Override
    public <T> T getOne(Class<T> clazz) {
        List<T> list = this._getPage(clazz, true, false, false, 0, 1, null, new Object[0]).getData();
        return list == null || list.isEmpty() ? null : (T)list.get(0);
    }

    @Override
    public <T> T getOne(Class<T> clazz, String postSql, Object ... args) {
        List<T> list = this._getPage(clazz, true, false, false, 0, 1, postSql, args).getData();
        return list == null || list.isEmpty() ? null : (T)list.get(0);
    }

    @Override
    public <T> List<T> getRaw(Class<T> clazz, String sql, Map<String, ?> args) {
        return this.getRawByNamedParam(clazz, sql, args);
    }

    @Override
    public <T> Stream<T> getRawForStream(Class<T> clazz, String sql, Map<String, ?> args) {
        return this.getRawByNamedParamForStream(clazz, sql, args);
    }

    private <T> Stream<T> getRawByNamedParamForStream(Class<T> clazz, String sql, Map<String, ?> args) {
        this.jdbcTemplate.setFetchSize(this.fetchSize);
        ArrayList<Object> forIntercept = new ArrayList<Object>();
        if (args != null) {
            forIntercept.add(args);
        }
        this.doInterceptBeforeQuery(clazz, sql, forIntercept);
        sql = this.addComment(sql);
        this.log(sql, 0, forIntercept);
        long start = System.currentTimeMillis();
        Stream<Object> stream = args == null || args.isEmpty() ? this.namedParameterJdbcTemplate.queryForStream(sql, new HashMap(), new AnnotationSupportRowMapper<T>(this, clazz, false)) : this.namedParameterJdbcTemplate.queryForStream(sql, args, new AnnotationSupportRowMapper<T>(this, clazz, false));
        List<Field> relatedColumns = DOInfoReader.getRelatedColumns(clazz);
        Stream result = !relatedColumns.isEmpty() ? InnerCommonUtils.partition(stream, this.fetchSize).peek(this::handleRelatedColumn).flatMap(Collection::stream) : stream;
        long cost = System.currentTimeMillis() - start;
        this.logSlow(cost, sql, 0, forIntercept);
        return result;
    }

    private <T> List<T> getRawByNamedParam(Class<T> clazz, String sql, Map<String, ?> args) {
        ArrayList<Object> forIntercept = new ArrayList<Object>();
        if (args != null) {
            forIntercept.add(args);
        }
        this.doInterceptBeforeQuery(clazz, sql, forIntercept);
        sql = this.addComment(sql);
        this.log(sql, 0, forIntercept);
        long start = System.currentTimeMillis();
        List list = args == null || args.isEmpty() ? this.namedParameterJdbcTemplate.query(sql, new AnnotationSupportRowMapper<T>(this, clazz, false)) : this.namedParameterJdbcTemplate.query(sql, args, new AnnotationSupportRowMapper<T>(this, clazz, false));
        this.handleRelatedColumn(list);
        long cost = System.currentTimeMillis() - start;
        this.logSlow(cost, sql, 0, forIntercept);
        this.doInterceptorAfterQueryList(clazz, list, -1L, sql, forIntercept);
        return list;
    }

    @Override
    public <T> Stream<T> getRawForStream(Class<T> clazz, String sql, Object ... args) {
        this.jdbcTemplate.setFetchSize(this.fetchSize);
        ArrayList<Object> argsList = new ArrayList<Object>();
        if (args != null) {
            argsList.addAll(Arrays.asList(args));
        }
        this.doInterceptBeforeQuery(clazz, sql, argsList);
        sql = this.addComment(sql);
        this.log(sql, 0, argsList);
        long start = System.currentTimeMillis();
        Stream<Object> stream = argsList.isEmpty() ? this.namedParameterJdbcTemplate.queryForStream(sql, new HashMap(), new AnnotationSupportRowMapper<T>(this, clazz, false)) : this.namedParameterJdbcTemplate.queryForStream(NamedParameterUtils.trans(sql, argsList), NamedParameterUtils.transParam(argsList), new AnnotationSupportRowMapper<T>(this, clazz, false));
        List<Field> relatedColumns = DOInfoReader.getRelatedColumns(clazz);
        Stream result = !relatedColumns.isEmpty() ? InnerCommonUtils.partition(stream, this.fetchSize).peek(this::handleRelatedColumn).flatMap(Collection::stream) : stream;
        long cost = System.currentTimeMillis() - start;
        this.logSlow(cost, sql, 0, argsList);
        return result;
    }

    @Override
    public <T> List<T> getRaw(Class<T> clazz, String sql, Object ... args) {
        ArrayList<Object> argsList = new ArrayList<Object>();
        if (args != null) {
            argsList.addAll(Arrays.asList(args));
        }
        this.doInterceptBeforeQuery(clazz, sql, argsList);
        sql = this.addComment(sql);
        this.log(sql, 0, argsList);
        long start = System.currentTimeMillis();
        List list = argsList.isEmpty() ? this.namedParameterJdbcTemplate.query(sql, new AnnotationSupportRowMapper<T>(this, clazz, false)) : this.namedParameterJdbcTemplate.query(NamedParameterUtils.trans(sql, argsList), NamedParameterUtils.transParam(argsList), new AnnotationSupportRowMapper<T>(this, clazz, false));
        this.handleRelatedColumn(list);
        long cost = System.currentTimeMillis() - start;
        this.logSlow(cost, sql, 0, argsList);
        this.doInterceptorAfterQueryList(clazz, list, -1L, sql, argsList);
        return list;
    }

    @Override
    public <T> T getRawOne(Class<T> clazz, String sql, Object ... args) {
        List<T> raw = this.getRaw(clazz, sql, args);
        if (raw == null || raw.isEmpty()) {
            return null;
        }
        return raw.get(0);
    }

    @Override
    public <T> T getRawOne(Class<T> clazz, String sql, Map<String, ?> args) {
        List<T> raw = this.getRaw(clazz, sql, args);
        if (raw == null || raw.isEmpty()) {
            return null;
        }
        return raw.get(0);
    }

    @Override
    public <T> List<T> getByExample(T t, int limit) {
        this.assertNotVirtualTable(t.getClass());
        HashMap<Field, String> filed2column = new HashMap<Field, String>();
        List<Field> declaredFields = DOInfoReader.getColumns(t.getClass());
        for (Field declaredField : declaredFields) {
            Column annotation = declaredField.getAnnotation(Column.class);
            if (annotation == null) continue;
            filed2column.put(declaredField, annotation.value());
        }
        ArrayList<String> cols = new ArrayList<String>();
        ArrayList<Object> args = new ArrayList<Object>();
        for (Map.Entry entry : filed2column.entrySet()) {
            Object value = DOInfoReader.getValue((Field)entry.getKey(), t);
            if (value == null) continue;
            cols.add((String)entry.getValue());
            args.add(value);
        }
        StringBuilder sql = new StringBuilder();
        if (!cols.isEmpty()) {
            sql.append(" WHERE ");
        }
        int n = cols.size();
        for (int i = 0; i < n; ++i) {
            sql.append(SQLUtils.getColumnName(this.getDatabaseType(), (String)cols.get(i))).append("=?");
            if (i == n - 1) continue;
            sql.append(" AND ");
        }
        return this._getPage(t.getClass(), true, false, false, null, limit, sql.toString(), args.toArray()).getData();
    }

    private <T> PageData<T> _getPage(Class<T> clazz, boolean isUseNamedTemplate, boolean selectOnlyKey, boolean withCount, Integer offset, Integer limit, String postSql, Object ... args) {
        boolean isVirtualTable = DOInfoReader.isVirtualTable(clazz);
        StringBuilder sqlSB = new StringBuilder();
        sqlSB.append(SQLUtils.getSelectSQL(this.getDatabaseType(), clazz, selectOnlyKey, false, this.features, postSql));
        if (limit != null && !isVirtualTable) {
            try {
                boolean autoAddOrderForPagination = this.getFeature(FeatureEnum.AUTO_ADD_ORDER_FOR_PAGINATION);
                postSql = SQLUtils.removeLimitAndAddOrder(this.getDatabaseType(), postSql, autoAddOrderForPagination, clazz);
            }
            catch (Exception e) {
                LOGGER.error("removeLimitAndAddOrder fail for class:{}, postSql:{}", new Object[]{clazz, postSql, e});
            }
        }
        sqlSB.append(isVirtualTable ? (postSql == null ? "\n" : "\n" + postSql) : SQLUtils.autoSetSoftDeleted(this.getDatabaseType(), postSql, clazz));
        sqlSB.append(SQLUtils.genLimitSQL(this.getDatabaseType(), offset, limit));
        ArrayList<Object> argsList = new ArrayList<Object>();
        if (args != null) {
            argsList.addAll(Arrays.asList(args));
        }
        if (!selectOnlyKey) {
            this.doInterceptBeforeQuery(clazz, sqlSB, argsList);
        }
        String sql = sqlSB.toString();
        sql = this.addComment(sql);
        this.log(sql, 0, argsList);
        long start = System.currentTimeMillis();
        List list = argsList.isEmpty() ? this.jdbcTemplate.query(sql, new AnnotationSupportRowMapper<T>(this, clazz, selectOnlyKey)) : (isUseNamedTemplate ? this.namedParameterJdbcTemplate.query(NamedParameterUtils.trans(sql, argsList), NamedParameterUtils.transParam(argsList), new AnnotationSupportRowMapper<T>(this, clazz, selectOnlyKey)) : this.jdbcTemplate.query(sql, new AnnotationSupportRowMapper<T>(this, clazz, selectOnlyKey), argsList.toArray()));
        long total = -1L;
        if (withCount) {
            total = offset != null && offset == 0 && limit != null && list.size() < limit ? (long)list.size() : this.getCount(clazz, postSql, args);
        }
        if (!selectOnlyKey) {
            this.handleRelatedColumn(list);
        }
        long cost = System.currentTimeMillis() - start;
        this.logSlow(cost, sql, 0, argsList);
        if (!selectOnlyKey) {
            this.doInterceptorAfterQueryList(clazz, list, total, sql, argsList);
        }
        PageData pageData = new PageData();
        pageData.setData(list);
        pageData.setTotal(total);
        if (limit != null) {
            pageData.setPageSize(limit);
        }
        return pageData;
    }

    @Override
    public <T> boolean isExist(Class<T> clazz, String postSql, Object ... args) {
        return this.getOne(clazz, postSql, args) != null;
    }

    @Override
    public <T> boolean isExistAtLeast(int atLeastCounts, Class<T> clazz, String postSql, Object ... args) {
        if (atLeastCounts == 1) {
            return this.isExist(clazz, postSql, args);
        }
        return this.getCount(clazz, postSql, args) >= (long)atLeastCounts;
    }

    private void doInterceptBeforeQuery(Class<?> clazz, StringBuilder sql, List<Object> args) {
        this.doInterceptBeforeQuery(clazz, sql.toString(), args);
    }

    private void doInterceptBeforeQuery(Class<?> clazz, String sql, List<Object> args) {
        for (DBHelperInterceptor interceptor : this.interceptors) {
            boolean isContinue = interceptor.beforeSelect(clazz, sql, args);
            if (isContinue) continue;
            throw new NotAllowQueryException("interceptor class:" + interceptor.getClass());
        }
    }

    private <T> List<T> doInterceptorAfterQueryList(Class<?> clazz, List<T> list, long total, String sql, List<Object> args) {
        for (int i = this.interceptors.size() - 1; i >= 0; --i) {
            list = ((DBHelperInterceptor)this.interceptors.get(i)).afterSelect(clazz, sql, args, list, total);
        }
        return list;
    }

    @Override
    public <T> void handleRelatedColumn(T t) {
        this.postHandleRelatedColumnSingle(t, new String[0]);
    }

    @Override
    public <T> void handleRelatedColumn(T t, String ... relatedColumnProperties) {
        this.postHandleRelatedColumnSingle(t, relatedColumnProperties);
    }

    @Override
    public <T> void handleRelatedColumn(List<T> list) {
        this.postHandleRelatedColumn(list, false, new String[0]);
    }

    @Override
    public <T> void handleRelatedColumn(List<T> list, String ... relatedColumnProperties) {
        this.postHandleRelatedColumn(list, false, relatedColumnProperties);
    }

    private <T> void postHandleRelatedColumnSingle(T t, String ... relatedColumnProperties) {
        if (t == null) {
            return;
        }
        ArrayList<T> list = new ArrayList<T>();
        list.add(t);
        this.postHandleRelatedColumn(list, false, relatedColumnProperties);
    }

    private <T> List<T> filterRelatedColumnConditional(List<T> tList, String conditional, Field field) {
        if (InnerCommonUtils.isBlank(conditional)) {
            return tList;
        }
        ArrayList<T> result = new ArrayList<T>();
        for (T t : tList) {
            HashMap<String, T> vars = new HashMap<String, T>();
            vars.put("t", t);
            try {
                Object value = MVEL.eval((String)conditional, vars);
                if (value == null) {
                    LOGGER.error("execute conditional return null, script:{}, t:{}", (Object)conditional, (Object)NimbleOrmJSON.toJson(t));
                    continue;
                }
                if (value instanceof Boolean) {
                    if (((Boolean)value).booleanValue()) {
                        result.add(t);
                        continue;
                    }
                    if (field.getType() != List.class) continue;
                    DOInfoReader.setValue(field, t, new ArrayList());
                    continue;
                }
                LOGGER.error("execute conditional return is not instance of Boolean, script:{}, t:{}", (Object)conditional, (Object)NimbleOrmJSON.toJson(t));
            }
            catch (Throwable e) {
                LOGGER.error("execute script fail: {}, t:{}", new Object[]{conditional, NimbleOrmJSON.toJson(t), e});
            }
        }
        return result;
    }

    private <T> void postHandleRelatedColumn(List<T> tList, boolean isFromJoin, String ... relatedColumnProperties) {
        if (tList == null || tList.isEmpty()) {
            return;
        }
        Class<?> clazz = this.getElementClass(tList);
        if (clazz == null) {
            return;
        }
        JoinTable joinTable = DOInfoReader.getJoinTable(clazz);
        if (joinTable != null && !isFromJoin) {
            SQLAssert.allSameClass(tList);
            ArrayList<Object> list1 = new ArrayList<Object>();
            ArrayList<Object> list2 = new ArrayList<Object>();
            Field joinLeftTableField = DOInfoReader.getJoinLeftTable(clazz);
            Field joinRightTableField = DOInfoReader.getJoinRightTable(clazz);
            for (T t : tList) {
                Object obj2;
                Object obj1 = DOInfoReader.getValue(joinLeftTableField, t);
                if (obj1 != null) {
                    list1.add(obj1);
                }
                if ((obj2 = DOInfoReader.getValue(joinRightTableField, t)) == null) continue;
                list2.add(obj2);
            }
            this.postHandleRelatedColumn(list1, false, new String[0]);
            this.postHandleRelatedColumn(list2, false, new String[0]);
            this.postHandleRelatedColumn(tList, true, new String[0]);
            return;
        }
        List<Field> relatedColumns = DOInfoReader.getRelatedColumns(clazz);
        if (relatedColumns.isEmpty()) {
            return;
        }
        SQLAssert.allSameClass(tList);
        for (Field field : relatedColumns) {
            Object oRemoteValue;
            HashMap<String, List<Object>> mapRemoteValuesString;
            HashMap<Object, List<Object>> mapRemoteValues;
            List<?> relateValues;
            boolean isContain;
            if (InnerCommonUtils.isNotEmpty(relatedColumnProperties) && !(isContain = InnerCommonUtils.isContains(field.getName(), relatedColumnProperties))) continue;
            RelatedColumn column = field.getAnnotation(RelatedColumn.class);
            List<T> tListFiltered = this.filterRelatedColumnConditional(tList, column.conditional(), field);
            if (InnerCommonUtils.isBlank(column.localColumn())) {
                throw new RelatedColumnFieldNotFoundException("field:" + field.getName() + " localColumn is blank");
            }
            if (InnerCommonUtils.isBlank(column.remoteColumn())) {
                throw new RelatedColumnFieldNotFoundException("field:" + field.getName() + " remoteColumn is blank");
            }
            List<DOInfoReader.RelatedField> localField = DOInfoReader.getFieldByDBField(clazz, column.localColumn(), field);
            Class<?> remoteDOClass = field.getType() == List.class ? DOInfoReader.getGenericFieldType(field) : field.getType();
            List<DOInfoReader.RelatedField> remoteField = DOInfoReader.getFieldByDBField(remoteDOClass, column.remoteColumn(), field);
            HashSet<Object> values = new HashSet<Object>();
            for (T t : tListFiltered) {
                Object value = DOInfoReader.getValueForRelatedColumn(localField, t);
                if (value == null) continue;
                values.add(value);
            }
            if (values.isEmpty()) {
                if (field.getType() != List.class) continue;
                for (T t : tListFiltered) {
                    DOInfoReader.setValue(field, t, new ArrayList());
                }
                continue;
            }
            if (column.dataService() != Void.TYPE && IDBHelperDataService.class.isAssignableFrom(column.dataService())) {
                IDBHelperDataService dataService = (IDBHelperDataService)this.applicationContext.getBean(column.dataService());
                ArrayList<Object> valuesList = new ArrayList<Object>(values);
                relateValues = dataService.get(valuesList, column, clazz, remoteDOClass);
            } else {
                String inExpr;
                String whereColumn = this.getWhereColumnForRelated(remoteField);
                P1_QueryOp _dbHelper = this;
                if (InnerCommonUtils.isNotBlank(column.dbHelperBean())) {
                    String beanName = column.dbHelperBean().trim();
                    Object bean = this.applicationContext.getBean(beanName);
                    if (!(bean instanceof P1_QueryOp)) {
                        throw new SpringBeanNotMatchException("cannot find DBHelper bean: " + beanName + " or it is not type of SpringJdbcDBHelper");
                    }
                    _dbHelper = (P1_QueryOp)bean;
                }
                if (InnerCommonUtils.isBlank(column.extraWhere())) {
                    inExpr = whereColumn + " in " + this.buildQuestionMark(values);
                    relateValues = _dbHelper.getAllForRelatedColumn(remoteDOClass, "where " + inExpr, values);
                } else {
                    try {
                        String where;
                        if (SQLUtils.isContainsLimit(column.extraWhere())) {
                            String eqExpr = whereColumn + "=?";
                            where = SQLUtils.insertWhereAndExpression(this.getDatabaseType(), column.extraWhere(), eqExpr);
                            relateValues = _dbHelper.getAllForRelatedColumnBySingleValue(remoteDOClass, where, values);
                        } else {
                            inExpr = whereColumn + " in " + this.buildQuestionMark(values);
                            where = SQLUtils.insertWhereAndExpression(this.getDatabaseType(), column.extraWhere(), inExpr);
                            relateValues = _dbHelper.getAllForRelatedColumn(remoteDOClass, where, values);
                        }
                    }
                    catch (JSQLParserException e) {
                        LOGGER.error("wrong RelatedColumn extraWhere:{}, ignore extraWhere", (Object)column.extraWhere());
                        throw new BadSQLSyntaxException(e);
                    }
                }
            }
            if (relateValues == null) {
                relateValues = new ArrayList();
            }
            if (field.getType() == List.class) {
                mapRemoteValues = new HashMap<Object, List<Object>>();
                mapRemoteValuesString = new HashMap<String, List<Object>>();
                for (Object obj : relateValues) {
                    oRemoteValue = DOInfoReader.getValueForRelatedColumn(remoteField, obj);
                    if (oRemoteValue == null) continue;
                    List oRemoteValueList = mapRemoteValues.computeIfAbsent(oRemoteValue, k -> new ArrayList());
                    oRemoteValueList.add(obj);
                    List oRemoteValueListString = mapRemoteValuesString.computeIfAbsent(oRemoteValue.toString(), k -> new ArrayList());
                    oRemoteValueListString.add(obj);
                }
                for (Object t : tListFiltered) {
                    List valueList = new ArrayList();
                    Object oLocalValue = DOInfoReader.getValueForRelatedColumn(localField, t);
                    if (oLocalValue != null) {
                        List objRemoteList = (List)mapRemoteValues.get(oLocalValue);
                        if (objRemoteList != null) {
                            valueList = objRemoteList;
                        } else {
                            List objRemoteStringList = (List)mapRemoteValuesString.get(oLocalValue.toString());
                            if (objRemoteStringList != null) {
                                LOGGER.error("@RelatedColumn fields local:{},remote:{} is different classes. Use String compare.", localField, remoteField);
                                valueList = objRemoteStringList;
                            }
                        }
                    }
                    if (valueList.isEmpty()) {
                        if (DOInfoReader.getValue(field, t) != null) continue;
                        DOInfoReader.setValue(field, t, valueList);
                        continue;
                    }
                    DOInfoReader.setValue(field, t, valueList);
                }
                continue;
            }
            mapRemoteValues = new HashMap();
            mapRemoteValuesString = new HashMap();
            for (Object obj : relateValues) {
                oRemoteValue = DOInfoReader.getValueForRelatedColumn(remoteField, obj);
                if (oRemoteValue == null || mapRemoteValues.containsKey(oRemoteValue)) continue;
                mapRemoteValues.put(oRemoteValue, (List<Object>)obj);
                mapRemoteValuesString.put(oRemoteValue.toString(), (List<Object>)obj);
            }
            for (Object t : tListFiltered) {
                Object oLocalValue = DOInfoReader.getValueForRelatedColumn(localField, t);
                if (oLocalValue == null) continue;
                Object objRemote = mapRemoteValues.get(oLocalValue);
                if (objRemote != null) {
                    DOInfoReader.setValue(field, t, objRemote);
                    continue;
                }
                Object objRemoteString = mapRemoteValuesString.get(oLocalValue.toString());
                if (objRemoteString == null) continue;
                LOGGER.error("@RelatedColumn fields local:{},remote:{} are different classes. Use String compare.", localField, remoteField);
                DOInfoReader.setValue(field, t, objRemoteString);
            }
        }
    }

    private String getWhereColumnForRelated(List<DOInfoReader.RelatedField> remoteField) {
        boolean isSingleColumn = remoteField.size() == 1;
        StringBuilder sb = new StringBuilder(isSingleColumn ? "" : "(");
        boolean isFirst = true;
        for (DOInfoReader.RelatedField remoteF : remoteField) {
            if (!isFirst) {
                sb.append(",");
            }
            isFirst = false;
            Column remoteColumn = remoteF.field.getAnnotation(Column.class);
            if (InnerCommonUtils.isBlank(remoteColumn.computed())) {
                sb.append(remoteF.fieldPrefix).append(SQLUtils.getColumnName(this.getDatabaseType(), remoteColumn.value()));
                continue;
            }
            sb.append(SQLUtils.getComputedColumn(this.getDatabaseType(), remoteColumn, this.features));
        }
        sb.append(isSingleColumn ? "" : ")");
        return sb.toString();
    }

    private String buildQuestionMark(Set<Object> values) {
        StringBuilder sb = new StringBuilder("(");
        boolean isFirst = true;
        for (Object obj : values) {
            if (!isFirst) {
                sb.append(",");
            }
            isFirst = false;
            if (obj instanceof List) {
                sb.append("(");
                int size = ((List)obj).size();
                for (int i = 0; i < size; ++i) {
                    if (i > 0) {
                        sb.append(",");
                    }
                    sb.append("?");
                }
                sb.append(")");
                continue;
            }
            sb.append("?");
        }
        sb.append(")");
        return sb.toString();
    }

    private <T> List<T> getAllForRelatedColumn(Class<T> clazz, String postSql, Set<Object> values) {
        ArrayList<Object> param = new ArrayList<Object>();
        for (Object obj : values) {
            if (obj instanceof List) {
                param.addAll((List)obj);
                continue;
            }
            param.add(obj);
        }
        return this._getPage(clazz, false, false, false, null, null, postSql, param.toArray()).getData();
    }

    private <T> List<T> getAllForRelatedColumnBySingleValue(Class<T> clazz, String postSql, Set<Object> values) {
        ArrayList<T> result = new ArrayList<T>();
        for (Object value : values) {
            ArrayList<Object> param = new ArrayList<Object>();
            param.add(value);
            List<T> results = this._getPage(clazz, false, false, false, null, null, postSql, param.toArray()).getData();
            result.addAll(results);
        }
        return result;
    }

    private Class<?> getElementClass(List<?> tList) {
        for (Object obj : tList) {
            if (obj == null) continue;
            return obj.getClass();
        }
        return null;
    }

    private void assertNotVirtualTable(Class<?> clazz) {
        boolean isVirtualTable = DOInfoReader.isVirtualTable(clazz);
        if (isVirtualTable) {
            throw new NotAllowQueryException("Virtual table is not supported");
        }
    }

    private void assertPage(int page) {
        if (page < 1) {
            throw new InvalidParameterException("[page] must greater than 0");
        }
    }
}

