/*
 * Decompiled with CFR 0.152.
 */
package com.pugwoo.dbhelper.impl.part;

import com.pugwoo.dbhelper.DBHelperInterceptor;
import com.pugwoo.dbhelper.annotation.Column;
import com.pugwoo.dbhelper.enums.DatabaseTypeEnum;
import com.pugwoo.dbhelper.exception.NotAllowModifyException;
import com.pugwoo.dbhelper.impl.part.P1_QueryOp;
import com.pugwoo.dbhelper.json.NimbleOrmDateUtils;
import com.pugwoo.dbhelper.sql.InsertSQLForBatchDTO;
import com.pugwoo.dbhelper.sql.SQLAssert;
import com.pugwoo.dbhelper.sql.SQLUtils;
import com.pugwoo.dbhelper.utils.DOInfoReader;
import com.pugwoo.dbhelper.utils.Generated;
import com.pugwoo.dbhelper.utils.InnerCommonUtils;
import com.pugwoo.dbhelper.utils.PreHandleObject;
import java.lang.reflect.Field;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;

public abstract class P2_InsertOp
extends P1_QueryOp {
    private void doInterceptBeforeInsert(Object t) {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(t);
        this.doInterceptBeforeInsertList(list);
    }

    private void doInterceptBeforeInsertList(Collection<?> list) {
        for (DBHelperInterceptor interceptor : this.interceptors) {
            boolean isContinue = list instanceof List ? interceptor.beforeInsert((List)list) : interceptor.beforeInsert(new ArrayList<Object>(list));
            if (isContinue) continue;
            throw new NotAllowModifyException("interceptor class:" + interceptor.getClass());
        }
    }

    private void doInterceptAfterInsert(Object t, int rows) {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(t);
        this.doInterceptAfterInsertList(list, rows);
    }

    private void doInterceptAfterInsertList(Collection<?> list, int rows) {
        if (InnerCommonUtils.isEmpty(this.interceptors)) {
            return;
        }
        Runnable runnable = () -> {
            for (int i = this.interceptors.size() - 1; i >= 0; --i) {
                if (list instanceof List) {
                    ((DBHelperInterceptor)this.interceptors.get(i)).afterInsert((List)list, rows);
                    continue;
                }
                ((DBHelperInterceptor)this.interceptors.get(i)).afterInsert(new ArrayList<Object>(list), rows);
            }
        };
        if (!this.executeAfterCommit(runnable)) {
            runnable.run();
        }
    }

    @Override
    public <T> int insert(T t) {
        return this.insert(t, false, true);
    }

    @Override
    public int insert(Collection<?> list) {
        if (InnerCommonUtils.isEmpty(list = InnerCommonUtils.filterNonNull(list))) {
            return 0;
        }
        this.doInterceptBeforeInsertList(list);
        boolean canBatchInsert = false;
        boolean isSameClass = SQLAssert.isAllSameClass(list);
        if (isSameClass && this.isAllHaveKeyValue(list)) {
            canBatchInsert = true;
        }
        int sum = 0;
        if (canBatchInsert) {
            sum = this.insertBatchWithoutReturnId(list, false);
        } else {
            for (Object obj : list) {
                sum += this.insert(obj, false, false);
            }
        }
        this.doInterceptAfterInsertList(list, sum);
        return sum;
    }

    @Override
    public <T> int insertBatchWithoutReturnId(Collection<T> list) {
        return this.insertBatchWithoutReturnId(list, true);
    }

    private <T> int insertBatchWithoutReturnId(Collection<T> list, boolean withInterceptor) {
        int total;
        DatabaseTypeEnum databaseType;
        if (InnerCommonUtils.isEmpty(list = InnerCommonUtils.filterNonNull(list))) {
            return 0;
        }
        SQLAssert.allSameClass(list);
        for (T t : list) {
            PreHandleObject.preHandleInsert(t);
        }
        if (withInterceptor) {
            this.doInterceptBeforeInsertList(list);
        }
        if ((databaseType = this.getDatabaseType()) == DatabaseTypeEnum.CLICKHOUSE) {
            ArrayList<Object[]> values = new ArrayList<Object[]>();
            String sql = SQLUtils.getInsertSQLForBatchForJDBCTemplate(this.getDatabaseType(), list, values);
            total = this.insertBatchJDBCTemplateMode(sql, values);
        } else {
            ArrayList<Object> values = new ArrayList<Object>();
            InsertSQLForBatchDTO sqlDTO = SQLUtils.getInsertSQLForBatch(databaseType, list, values);
            total = this.insertBatchDefaultMode(sqlDTO, values, list.size());
        }
        if (withInterceptor) {
            this.doInterceptAfterInsertList(list, total);
        }
        return total;
    }

    private int insertBatchDefaultMode(InsertSQLForBatchDTO sqlDTO, List<Object> values, int listSize) {
        String sql = this.addComment(sqlDTO.getSql());
        String sqlForLog = sqlDTO.getSql().substring(0, sqlDTO.getSqlLogEndIndex());
        List<Object> paramForLog = values.subList(0, sqlDTO.getParamLogEndIndex());
        this.log(sqlForLog, listSize, paramForLog);
        long start = System.currentTimeMillis();
        int total = this.jdbcTemplate.update(sql, values.toArray());
        long cost = System.currentTimeMillis() - start;
        this.logSlow(cost, sqlForLog, listSize, paramForLog);
        return total;
    }

    private int insertBatchJDBCTemplateMode(String sql, List<Object[]> values) {
        int[] rows;
        sql = this.addComment(sql);
        Object[] paramForLog = values.isEmpty() ? null : values.get(0);
        this.log(sql, values.size(), paramForLog);
        String sqlForLog = sql;
        long start = System.currentTimeMillis();
        int total = 0;
        int[] nArray = rows = this.jdbcTemplate.batchUpdate(sql, values);
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int row;
            int result = row = nArray[i];
            if (row == -2) {
                result = 1;
            } else if (row < 0) {
                result = 0;
            }
            total += result;
        }
        long cost = System.currentTimeMillis() - start;
        this.logSlow(cost, sqlForLog, values.size(), paramForLog);
        return total;
    }

    @Override
    public int insertBatchWithoutReturnId(String tableName, Collection<Map<String, Object>> list) {
        int total;
        if (InnerCommonUtils.isEmpty(list = InnerCommonUtils.filterNonNull(list))) {
            return 0;
        }
        DatabaseTypeEnum databaseType = this.getDatabaseType();
        if (databaseType == DatabaseTypeEnum.CLICKHOUSE) {
            ArrayList<Object[]> values = new ArrayList<Object[]>();
            String sql = SQLUtils.getInsertSQLForBatchForJDBCTemplate(databaseType, tableName, list, values);
            total = this.insertBatchJDBCTemplateMode(sql, values);
        } else {
            ArrayList<Object> values = new ArrayList<Object>();
            InsertSQLForBatchDTO sqlDTO = SQLUtils.getInsertSQLForBatch(databaseType, tableName, list, values);
            total = this.insertBatchDefaultMode(sqlDTO, values, list.size());
        }
        return total;
    }

    @Override
    public int insertBatchWithoutReturnId(String tableName, List<String> cols, Collection<Object[]> values) {
        int total;
        List values2 = (List)InnerCommonUtils.filterNonNull(values);
        if (InnerCommonUtils.isEmpty(values2)) {
            return 0;
        }
        DatabaseTypeEnum databaseType = this.getDatabaseType();
        if (databaseType == DatabaseTypeEnum.CLICKHOUSE) {
            String sql = SQLUtils.getInsertSQLForBatchForJDBCTemplate(databaseType, tableName, cols);
            total = this.insertBatchJDBCTemplateMode(sql, values2);
        } else {
            ArrayList<Object> values3 = new ArrayList<Object>();
            InsertSQLForBatchDTO sqlDTO = SQLUtils.getInsertSQLForBatch(databaseType, tableName, cols, values2, values3);
            total = this.insertBatchDefaultMode(sqlDTO, values3, values2.size());
        }
        return total;
    }

    @Override
    public <T> int insertWithNull(T t) {
        return this.insert(t, true, true);
    }

    private <T> int insert(T t, boolean isWithNullValue, boolean withInterceptor) {
        int rows;
        PreHandleObject.preHandleInsert(t);
        ArrayList<Object> values = new ArrayList<Object>();
        if (withInterceptor) {
            this.doInterceptBeforeInsert(t);
        }
        String sql1 = SQLUtils.getInsertSQL(this.getDatabaseType(), t, values, isWithNullValue);
        String sql = this.addComment(sql1);
        this.log(sql, 0, values);
        long start = System.currentTimeMillis();
        DatabaseTypeEnum databaseType = this.getDatabaseType();
        Field autoIncrementField = DOInfoReader.getAutoIncrementField(t.getClass());
        if (autoIncrementField != null && DOInfoReader.getValue(autoIncrementField, t) == null) {
            GeneratedKeyHolder holder = new GeneratedKeyHolder();
            rows = this.jdbcTemplate.update(con -> {
                PreparedStatement statement = con.prepareStatement(sql, 1);
                for (int i = 0; i < values.size(); ++i) {
                    if (databaseType == DatabaseTypeEnum.POSTGRESQL) {
                        Object value = values.get(i);
                        if (value != null && value instanceof Date) {
                            value = NimbleOrmDateUtils.toLocalDateTime((Date)value);
                        }
                        statement.setObject(i + 1, value);
                        continue;
                    }
                    statement.setObject(i + 1, values.get(i));
                }
                return statement;
            }, (KeyHolder)holder);
            if (rows > 0) {
                if (databaseType == DatabaseTypeEnum.POSTGRESQL) {
                    Map map = holder.getKeys();
                    if (map != null) {
                        Object key = map.get(autoIncrementField.getAnnotation(Column.class).value());
                        this.logIfNull(key, autoIncrementField);
                        if (key != null) {
                            DOInfoReader.setValue(autoIncrementField, t, key);
                        }
                    }
                } else {
                    Number key = holder.getKey();
                    this.logIfNull(key, autoIncrementField);
                    if (key != null) {
                        long primaryKey = key.longValue();
                        DOInfoReader.setValue(autoIncrementField, t, primaryKey);
                    }
                }
            }
        } else {
            rows = this.jdbcTemplate.update(sql, values.toArray());
        }
        long cost = System.currentTimeMillis() - start;
        this.logSlow(cost, sql, 0, values);
        if (withInterceptor) {
            this.doInterceptAfterInsert(t, rows);
        }
        return rows;
    }

    @Generated
    private void logIfNull(Object key, Field autoIncrementField) {
        if (key == null) {
            LOGGER.error("get auto increment field:{} return null", (Object)autoIncrementField);
        }
    }

    private boolean isAllHaveKeyValue(Collection<?> list) {
        Class<?> clazz = list.iterator().next().getClass();
        List<Field> fields = DOInfoReader.getKeyColumnsNoThrowsException(clazz);
        if (fields.isEmpty()) {
            return true;
        }
        for (Object obj : list) {
            for (Field field : fields) {
                if (DOInfoReader.getValue(field, obj) != null) continue;
                return false;
            }
        }
        return true;
    }
}

