/*
 * Decompiled with CFR 0.152.
 */
package com.pugwoo.dbhelper.impl.part;

import com.pugwoo.dbhelper.DBHelperInterceptor;
import com.pugwoo.dbhelper.annotation.Column;
import com.pugwoo.dbhelper.enums.DatabaseTypeEnum;
import com.pugwoo.dbhelper.exception.CasVersionNotMatchException;
import com.pugwoo.dbhelper.exception.NotAllowModifyException;
import com.pugwoo.dbhelper.exception.NullKeyValueException;
import com.pugwoo.dbhelper.impl.part.P2_InsertOp;
import com.pugwoo.dbhelper.json.NimbleOrmDateUtils;
import com.pugwoo.dbhelper.json.NimbleOrmJSON;
import com.pugwoo.dbhelper.sql.SQLAssert;
import com.pugwoo.dbhelper.sql.SQLUtils;
import com.pugwoo.dbhelper.utils.DOInfoReader;
import com.pugwoo.dbhelper.utils.InnerCommonUtils;
import com.pugwoo.dbhelper.utils.PreHandleObject;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public abstract class P3_UpdateOp
extends P2_InsertOp {
    private void doInterceptBeforeUpdate(Collection<?> tList, String setSql, List<Object> setSqlArgs) {
        for (DBHelperInterceptor interceptor : this.interceptors) {
            boolean isContinue = tList instanceof List ? interceptor.beforeUpdate((List)tList, setSql, setSqlArgs) : interceptor.beforeUpdate(new ArrayList<Object>(tList), setSql, setSqlArgs);
            if (isContinue) continue;
            throw new NotAllowModifyException("interceptor class:" + interceptor.getClass());
        }
    }

    private void doInterceptBeforeUpdate(Class<?> clazz, String sql, List<String> customsSets, List<Object> customsParams, List<Object> args) {
        for (DBHelperInterceptor interceptor : this.interceptors) {
            boolean isContinue = interceptor.beforeUpdateAll(clazz, sql, customsSets, customsParams, args);
            if (isContinue) continue;
            throw new NotAllowModifyException("interceptor class:" + interceptor.getClass());
        }
    }

    private void doInterceptAfterUpdate(Collection<?> tList, int rows) {
        if (InnerCommonUtils.isEmpty(this.interceptors)) {
            return;
        }
        Runnable runnable = () -> {
            for (int i = this.interceptors.size() - 1; i >= 0; --i) {
                if (tList instanceof List) {
                    ((DBHelperInterceptor)this.interceptors.get(i)).afterUpdate((List)tList, rows);
                    continue;
                }
                ((DBHelperInterceptor)this.interceptors.get(i)).afterUpdate(new ArrayList<Object>(tList), rows);
            }
        };
        if (!this.executeAfterCommit(runnable)) {
            runnable.run();
        }
    }

    @Override
    public <T> int update(T t) throws NullKeyValueException {
        return this._update(t, false, true, null, new Object[0]);
    }

    @Override
    public <T> int update(T t, String postSql, Object ... args) throws NullKeyValueException {
        return this._update(t, false, true, postSql, args);
    }

    @Override
    public <T> int updateWithNull(T t) throws NullKeyValueException {
        return this._update(t, true, true, null, new Object[0]);
    }

    @Override
    public <T> int updateWithNull(T t, String postSql, Object ... args) throws NullKeyValueException {
        return this._update(t, true, true, postSql, args);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T> int update(Collection<T> list) throws NullKeyValueException {
        if (InnerCommonUtils.isEmpty(list = InnerCommonUtils.filterNonNull(list))) {
            return 0;
        }
        if (list.size() == 1) {
            return this.update(list.iterator().next());
        }
        boolean isSameClass = SQLAssert.isAllSameClass(list);
        Class<?> clazz = list.iterator().next().getClass();
        if (this.getDatabaseType() == DatabaseTypeEnum.POSTGRESQL) {
            List<Field> columns = DOInfoReader.getColumns(clazz);
            boolean hasJsonColumn = false;
            for (Field field : columns) {
                if (!field.getAnnotation(Column.class).isJSON()) continue;
                hasJsonColumn = true;
                break;
            }
            if (hasJsonColumn) {
                int rows = 0;
                for (Object object : list) {
                    if (object == null) continue;
                    rows += this.update(object);
                }
                return rows;
            }
        }
        this.doInterceptBeforeUpdate(list, null, null);
        List<Field> keyColumns = DOInfoReader.getKeyColumns(clazz);
        int rows = 0;
        boolean isUpdateOneByOne = true;
        if (isSameClass && keyColumns.size() == 1) {
            try {
                void var8_18;
                List<Field> list2 = DOInfoReader.getNotKeyColumns(clazz);
                if (list2.isEmpty()) {
                    return 0;
                }
                list.forEach(PreHandleObject::preHandleUpdate);
                Object var8_17 = null;
                for (Field field : list2) {
                    if (!field.getAnnotation(Column.class).casVersion()) continue;
                    if (var8_18 != null) {
                        throw new RuntimeException("class:" + clazz.getName() + " has more than one casVersion column");
                    }
                    Field field2 = field;
                }
                if (var8_18 != null) {
                    list2.remove(var8_18);
                }
                ArrayList<Object> params = new ArrayList<Object>();
                SQLUtils.BatchUpdateResultDTO batchUpdateResultDTO = SQLUtils.getBatchUpdateSQL(this.getDatabaseType(), list, params, (Field)var8_18, keyColumns.get(0), list2, clazz);
                if (InnerCommonUtils.isBlank(batchUpdateResultDTO.getSql())) {
                    return 0;
                }
                if (this.getDatabaseType() == DatabaseTypeEnum.POSTGRESQL) {
                    for (int i = 0; i < params.size(); ++i) {
                        if (params.get(i) == null || !(params.get(i) instanceof Date)) continue;
                        params.set(i, NimbleOrmDateUtils.toLocalDateTime((Date)params.get(i)));
                    }
                }
                rows = this.namedJdbcExecuteUpdateWithLog(batchUpdateResultDTO.getSql(), batchUpdateResultDTO.getLogSql(), list.size(), batchUpdateResultDTO.getLogParams(), params.toArray());
                if (this.getDatabaseType() == DatabaseTypeEnum.CLICKHOUSE && rows > 0) {
                    rows = list.size();
                }
                this.postHandleCasVersion(list, rows, (Field)var8_18, clazz);
                isUpdateOneByOne = false;
            }
            catch (Exception exception) {
                if (exception.getMessage().contains("has more than one casVersion column")) {
                    throw exception;
                }
                LOGGER.warn("batch update error, class:{}, data size:{}, will fallback to update one by one", new Object[]{clazz.getName(), list.size(), exception});
            }
        }
        if (isUpdateOneByOne) {
            boolean bl;
            boolean bl2 = false;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (Object object : list) {
                if (object == null) continue;
                try {
                    rows += this._update(object, false, false, null, new Object[0]);
                }
                catch (CasVersionNotMatchException e) {
                    arrayList.add(object);
                    bl = true;
                }
            }
            if (bl) {
                throw new CasVersionNotMatchException(rows, "update fail for class:" + clazz.getName() + ", data:" + NimbleOrmJSON.toJson(arrayList));
            }
        }
        this.doInterceptAfterUpdate(list, rows);
        return rows;
    }

    private <T> int _update(T t, boolean withNull, boolean withInterceptors, String postSql, Object ... args) throws NullKeyValueException {
        if (t == null) {
            return 0;
        }
        if (DOInfoReader.getNotKeyColumns(t.getClass()).isEmpty()) {
            return 0;
        }
        PreHandleObject.preHandleUpdate(t);
        ArrayList<T> tList = new ArrayList<T>();
        tList.add(t);
        if (withInterceptors) {
            this.doInterceptBeforeUpdate(tList, null, null);
        }
        ArrayList<Object> values = new ArrayList<Object>();
        String sql = SQLUtils.getUpdateSQL(this.getDatabaseType(), t, values, withNull, postSql);
        if (args != null) {
            values.addAll(Arrays.asList(args));
        }
        int rows = this.namedJdbcExecuteUpdate(sql, values.toArray());
        this.postHandleCasVersion(t, rows);
        if (withInterceptors) {
            this.doInterceptAfterUpdate(tList, rows);
        }
        return rows;
    }

    private void postHandleCasVersion(Object t, Field casVersionField) {
        Object casVersion = DOInfoReader.getValue(casVersionField, t);
        if (casVersion instanceof Integer) {
            Integer newVersion = (Integer)casVersion + 1;
            DOInfoReader.setValue(casVersionField, t, newVersion);
        } else if (casVersion instanceof Long) {
            Long newVersion = (Long)casVersion + 1L;
            DOInfoReader.setValue(casVersionField, t, newVersion);
        }
    }

    private <T> void postHandleCasVersion(Collection<T> list, int rows, Field casVersionColumn, Class<?> clazz) {
        if (casVersionColumn == null) {
            return;
        }
        if (list.size() != rows) {
            throw new CasVersionNotMatchException(rows, "update fail for class:" + clazz.getName() + ", data:" + NimbleOrmJSON.toJson(list));
        }
        list.forEach(o -> this.postHandleCasVersion(o, casVersionColumn));
    }

    private void postHandleCasVersion(Object t, int rows) {
        Field casVersionField = DOInfoReader.getCasVersionColumn(t.getClass());
        if (casVersionField == null) {
            return;
        }
        if (rows <= 0) {
            throw new CasVersionNotMatchException("update fail for class:" + t.getClass().getName() + ", data:" + NimbleOrmJSON.toJson(t));
        }
        this.postHandleCasVersion(t, casVersionField);
    }

    @Override
    public <T> int updateCustom(T t, String setSql, Object ... args) throws NullKeyValueException {
        if (InnerCommonUtils.isBlank(setSql)) {
            return 0;
        }
        ArrayList<Object> values = new ArrayList<Object>();
        if (args != null) {
            values.addAll(Arrays.asList(args));
        }
        String sql = SQLUtils.getCustomUpdateSQL(this.getDatabaseType(), t, values, setSql);
        ArrayList<T> tList = new ArrayList<T>();
        tList.add(t);
        this.doInterceptBeforeUpdate(tList, setSql, values);
        int rows = this.namedJdbcExecuteUpdate(sql, values.toArray());
        this.postHandleCasVersion(t, rows);
        this.doInterceptAfterUpdate(tList, rows);
        return rows;
    }

    @Override
    public <T> int updateAll(Class<T> clazz, String setSql, String whereSql, Object ... args) {
        ArrayList<Object> values;
        if (InnerCommonUtils.isBlank(setSql)) {
            return 0;
        }
        String sql = SQLUtils.getUpdateAllSQL(this.getDatabaseType(), clazz, setSql, whereSql, null);
        ArrayList<String> customsSets = new ArrayList<String>();
        ArrayList<Object> customsParams = new ArrayList<Object>();
        ArrayList<Object> argsList = new ArrayList<Object>();
        if (args != null) {
            argsList.addAll(Arrays.asList(args));
        }
        this.doInterceptBeforeUpdate(clazz, sql, customsSets, customsParams, argsList);
        if (!customsSets.isEmpty()) {
            values = new ArrayList<Object>();
            values.addAll(customsParams);
            values.addAll(argsList);
            StringBuilder sbSet = new StringBuilder();
            for (String s : customsSets) {
                sbSet.append(s).append(",");
            }
            sbSet.append(setSql.toLowerCase().startsWith("set ") ? setSql.substring(4) : setSql);
            setSql = sbSet.toString();
        } else {
            values = new ArrayList<Object>(argsList);
        }
        sql = SQLUtils.getUpdateAllSQL(this.getDatabaseType(), clazz, setSql, whereSql, null);
        return this.namedJdbcExecuteUpdate(sql, values.toArray());
    }
}

