/*
 * Decompiled with CFR 0.152.
 */
package com.pugwoo.dbhelper.impl.part;

import com.pugwoo.dbhelper.impl.part.P3_UpdateOp;
import com.pugwoo.dbhelper.utils.DOInfoReader;
import com.pugwoo.dbhelper.utils.InnerCommonUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class P4_InsertOrUpdateOp
extends P3_UpdateOp {
    @Override
    public <T> int insertOrUpdate(T t) {
        if (t == null) {
            return 0;
        }
        if (this.isWithKey(t)) {
            return this.update(t);
        }
        return this.insert(t);
    }

    @Override
    public <T> int insertOrUpdateWithNull(T t) {
        if (t == null) {
            return 0;
        }
        if (this.isWithKey(t)) {
            return this.updateWithNull(t);
        }
        return this.insertWithNull(t);
    }

    @Override
    public <T> int insertOrUpdate(Collection<T> list) {
        if (InnerCommonUtils.isEmpty(list)) {
            return 0;
        }
        ArrayList<T> toInsert = new ArrayList<T>();
        ArrayList<T> toUpdate = new ArrayList<T>();
        for (T t : list) {
            if (t == null) continue;
            if (this.isWithKey(t)) {
                toUpdate.add(t);
                continue;
            }
            toInsert.add(t);
        }
        int rows = 0;
        rows += this.insert((Collection<?>)toInsert);
        return rows += this.update(toUpdate);
    }

    private <T> boolean isWithKey(T t) {
        List<Field> keyFields = DOInfoReader.getKeyColumnsNoThrowsException(t.getClass());
        if (keyFields.isEmpty()) {
            return false;
        }
        for (Field keyField : keyFields) {
            if (DOInfoReader.getValue(keyField, t) != null) continue;
            return false;
        }
        return true;
    }
}

