/*
 * Decompiled with CFR 0.152.
 */
package com.pugwoo.dbhelper.impl.part;

import com.pugwoo.dbhelper.DBHelper;
import com.pugwoo.dbhelper.DBHelperInterceptor;
import com.pugwoo.dbhelper.annotation.Column;
import com.pugwoo.dbhelper.annotation.Table;
import com.pugwoo.dbhelper.exception.InvalidParameterException;
import com.pugwoo.dbhelper.exception.NotAllowModifyException;
import com.pugwoo.dbhelper.exception.NullKeyValueException;
import com.pugwoo.dbhelper.exception.SpringBeanNotMatchException;
import com.pugwoo.dbhelper.impl.part.P4_InsertOrUpdateOp;
import com.pugwoo.dbhelper.json.NimbleOrmJSON;
import com.pugwoo.dbhelper.sql.SQLAssert;
import com.pugwoo.dbhelper.sql.SQLUtils;
import com.pugwoo.dbhelper.utils.DOInfoReader;
import com.pugwoo.dbhelper.utils.InnerCommonUtils;
import com.pugwoo.dbhelper.utils.PreHandleObject;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public abstract class P5_DeleteOp
extends P4_InsertOrUpdateOp {
    private <T> void doInterceptBeforeDelete(T t) {
        if (InnerCommonUtils.isEmpty(this.interceptors)) {
            return;
        }
        ArrayList<Object> tList = new ArrayList<Object>();
        tList.add(t);
        this.doInterceptBeforeDelete((List<Object>)tList);
    }

    private void doInterceptBeforeDelete(List<Object> tList) {
        for (DBHelperInterceptor interceptor : this.interceptors) {
            boolean isContinue = interceptor.beforeDelete(tList);
            if (isContinue) continue;
            throw new NotAllowModifyException("interceptor class:" + interceptor.getClass());
        }
    }

    private <T> void doInterceptAfterDelete(T t, int rows) {
        if (InnerCommonUtils.isEmpty(this.interceptors)) {
            return;
        }
        ArrayList<Object> tList = new ArrayList<Object>();
        tList.add(t);
        this.doInterceptAfterDelete((List<Object>)tList, rows);
    }

    private void doInterceptAfterDelete(List<Object> tList, int rows) {
        if (InnerCommonUtils.isEmpty(this.interceptors)) {
            return;
        }
        Runnable runnable = () -> {
            for (int i = this.interceptors.size() - 1; i >= 0; --i) {
                ((DBHelperInterceptor)this.interceptors.get(i)).afterDelete(tList, rows);
            }
        };
        if (!this.executeAfterCommit(runnable)) {
            runnable.run();
        }
    }

    @Override
    public <T> int delete(T t) throws NullKeyValueException {
        return this._delete(t, false);
    }

    @Override
    public <T> int deleteHard(T t) throws NullKeyValueException {
        return this._delete(t, true);
    }

    private <T> int _delete(T t, boolean isHard) throws NullKeyValueException {
        String sql;
        if (t == null) {
            throw new InvalidParameterException("delete t is null");
        }
        PreHandleObject.preHandleDelete(t);
        this.doInterceptBeforeDelete(t);
        Field softDelete = DOInfoReader.getSoftDeleteColumn(t.getClass());
        ArrayList<Object> values = new ArrayList<Object>();
        if (isHard || softDelete == null) {
            sql = SQLUtils.getDeleteSQL(this.getDatabaseType(), t, values);
        } else {
            if (InnerCommonUtils.isNotEmpty(this.interceptors)) {
                this.updateForDelete(t);
            }
            Column softDeleteColumn = softDelete.getAnnotation(Column.class);
            sql = SQLUtils.getSoftDeleteSQL(this.getDatabaseType(), t, softDeleteColumn, values);
        }
        Table table = DOInfoReader.getTable(t.getClass());
        if (!isHard && InnerCommonUtils.isNotBlank(table.softDeleteTable())) {
            DBHelper dbHelper = this.getDBHelper(table.softDeleteDBHelperBean());
            ArrayList<Object> keyParams = new ArrayList<Object>();
            String keysWhereSQL = SQLUtils.getKeysWhereSQL(this.getDatabaseType(), t, keyParams);
            Object dbT = this.getOne(t.getClass(), keysWhereSQL, keyParams.toArray());
            try {
                if (dbT == null) {
                    LOGGER.error("soft delete insert to table:" + table.softDeleteTable() + " error, data is null, key:{}", (Object)NimbleOrmJSON.toJson(keyParams));
                } else {
                    HashMap tableNames = new HashMap();
                    tableNames.put(t.getClass(), table.softDeleteTable());
                    DBHelper.withTableNames(tableNames, () -> {
                        int rows = dbHelper.insert(dbT);
                        if (rows != 1) {
                            LOGGER.error("soft delete insert to table:" + table.softDeleteTable() + " error, rows={}, data: {}", (Object)rows, (Object)NimbleOrmJSON.toJson(dbT));
                        }
                    });
                }
            }
            catch (Exception e) {
                LOGGER.error("soft delete insert to table:" + table.softDeleteTable() + " error, data: {}", (Object)NimbleOrmJSON.toJson(dbT), (Object)e);
            }
        }
        int rows = this.jdbcExecuteUpdate(sql, values.toArray());
        this.doInterceptAfterDelete(t, rows);
        return rows;
    }

    private DBHelper getDBHelper(String dbHelperBean) {
        DBHelper dbHelper = this;
        if (InnerCommonUtils.isNotBlank(dbHelperBean)) {
            Object bean = this.applicationContext.getBean(dbHelperBean);
            if (!(bean instanceof DBHelper)) {
                throw new SpringBeanNotMatchException("cannot find DBHelper bean: " + dbHelperBean + " or it is not type of SpringJdbcDBHelper");
            }
            dbHelper = (DBHelper)bean;
        }
        return dbHelper;
    }

    @Override
    public <T> int deleteHard(Collection<T> list) throws NullKeyValueException {
        return this._delete(list, true);
    }

    @Override
    public <T> int delete(Collection<T> list) throws NullKeyValueException {
        return this._delete(list, false);
    }

    private <T> int _delete(Collection<T> list, boolean isHard) throws NullKeyValueException {
        Object keyFields;
        if (list == null || list.isEmpty()) {
            return 0;
        }
        Class<?> clazz = null;
        for (T t : list) {
            if (t == null) continue;
            clazz = t.getClass();
        }
        boolean batchDelete = false;
        Field keyField = null;
        if (SQLAssert.isAllSameClass(list) && (keyFields = DOInfoReader.getKeyColumns(clazz)).size() == 1) {
            keyField = (Field)keyFields.get(0);
            boolean isUseDeleteValueScript = false;
            List<Field> fields = DOInfoReader.getColumns(clazz);
            for (Field field : fields) {
                Column column = field.getAnnotation(Column.class);
                if (!InnerCommonUtils.isNotBlank(column.deleteValueScript())) continue;
                isUseDeleteValueScript = true;
                break;
            }
            if (!isUseDeleteValueScript) {
                batchDelete = true;
            }
        }
        if (batchDelete) {
            for (Object t : list) {
                PreHandleObject.preHandleDelete(t);
            }
            ArrayList<Object> keys = new ArrayList<Object>();
            for (T t : list) {
                Object key = DOInfoReader.getValue(keyField, t);
                if (key == null) continue;
                keys.add(key);
            }
            ArrayList<Object> listTmp = new ArrayList<Object>(list);
            this.doInterceptBeforeDelete((List<Object>)listTmp);
            Field softDelete = DOInfoReader.getSoftDeleteColumn(clazz);
            String where = SQLUtils.getDeleteSqlByKeyField(this.getDatabaseType(), keyField);
            String sql = isHard || softDelete == null ? SQLUtils.getCustomDeleteSQL(this.getDatabaseType(), clazz, where) : SQLUtils.getCustomSoftDeleteSQL(this.getDatabaseType(), clazz, where, softDelete);
            Table table = DOInfoReader.getTable(clazz);
            if (!isHard && InnerCommonUtils.isNotBlank(table.softDeleteTable())) {
                DBHelper dbHelper = this.getDBHelper(table.softDeleteDBHelperBean());
                List<?> all = dbHelper.getAll(clazz, where, keys.toArray());
                try {
                    if (all == null || all.isEmpty()) {
                        LOGGER.error("soft delete insert to table:" + table.softDeleteTable() + " error, data is null, key:{}", (Object)NimbleOrmJSON.toJson(keys));
                    } else {
                        HashMap tableNames = new HashMap();
                        tableNames.put(clazz, table.softDeleteTable());
                        DBHelper.withTableNames(tableNames, () -> {
                            int rows = dbHelper.insert((Collection<?>)all);
                            if (rows != all.size()) {
                                LOGGER.error("soft delete insert to table:" + table.softDeleteTable() + " error, rows={}, data: {}", (Object)rows, (Object)NimbleOrmJSON.toJson(all));
                            }
                        });
                    }
                }
                catch (Exception e) {
                    LOGGER.error("soft delete insert to table:" + table.softDeleteTable() + " error, data: {}", (Object)NimbleOrmJSON.toJson(all), (Object)e);
                }
            }
            int rows = this.namedJdbcExecuteUpdate(sql, keys);
            this.doInterceptAfterDelete((List<Object>)listTmp, rows);
            return rows;
        }
        int rows = 0;
        for (T t : list) {
            rows += this.delete(t);
        }
        return rows;
    }

    @Override
    public <T> int deleteHard(Class<T> clazz, String postSql, Object ... args) {
        return this._delete(clazz, true, postSql, args);
    }

    @Override
    public <T> int delete(Class<T> clazz, String postSql, Object ... args) {
        return this._delete(clazz, false, postSql, args);
    }

    private <T> int _delete(Class<T> clazz, boolean isHard, String postSql, Object ... args) {
        if (InnerCommonUtils.isBlank(postSql)) {
            throw new InvalidParameterException("delete postSql is blank. it's very dangerous. use WHERE 1=1 to confirm delete all");
        }
        Field softDelete = DOInfoReader.getSoftDeleteColumn(clazz);
        if ((this.interceptors == null || this.interceptors.isEmpty()) && !P5_DeleteOp.isUseDeleteValueScript(clazz)) {
            String sql = isHard || softDelete == null ? SQLUtils.getCustomDeleteSQL(this.getDatabaseType(), clazz, postSql) : SQLUtils.getCustomSoftDeleteSQL(this.getDatabaseType(), clazz, postSql, softDelete);
            Table table = DOInfoReader.getTable(clazz);
            if (!isHard && InnerCommonUtils.isNotBlank(table.softDeleteTable())) {
                DBHelper dbHelper = this.getDBHelper(table.softDeleteDBHelperBean());
                List all = dbHelper.getAll(clazz, postSql, args);
                try {
                    if (all == null || all.isEmpty()) {
                        LOGGER.error("soft delete insert to table:" + table.softDeleteTable() + " error, data is null, postSql:{}, args:{}", (Object)postSql, (Object)NimbleOrmJSON.toJson(args));
                    } else {
                        HashMap tableNames = new HashMap();
                        tableNames.put(clazz, table.softDeleteTable());
                        DBHelper.withTableNames(tableNames, () -> {
                            int rows = dbHelper.insert(all);
                            if (rows != all.size()) {
                                LOGGER.error("soft delete insert to table:" + table.softDeleteTable() + " error, rows={}, data: {}", (Object)rows, (Object)NimbleOrmJSON.toJson(all));
                            }
                        });
                    }
                }
                catch (Exception e) {
                    LOGGER.error("soft delete insert to table:" + table.softDeleteTable() + " error, data: {}", (Object)NimbleOrmJSON.toJson(all), (Object)e);
                }
            }
            return this.namedJdbcExecuteUpdate(sql, args);
        }
        List<T> allKey = this.getAllKey(clazz, postSql, args);
        return this.delete((Collection<T>)allKey);
    }

    private static boolean isUseDeleteValueScript(Class<?> clazz) {
        List<Field> columns = DOInfoReader.getColumns(clazz);
        for (Field field : columns) {
            if (!InnerCommonUtils.isNotBlank(field.getAnnotation(Column.class).deleteValueScript())) continue;
            return true;
        }
        return false;
    }

    private <T> void updateForDelete(T t) throws NullKeyValueException {
        ArrayList<Object> values = new ArrayList<Object>();
        String sql = SQLUtils.getUpdateSQL(this.getDatabaseType(), t, values, false, null);
        if (sql != null) {
            this.jdbcExecuteUpdate(sql, values.toArray());
        }
    }
}

