/*
 * Decompiled with CFR 0.152.
 */
package com.pugwoo.dbhelper.json;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.pugwoo.dbhelper.json.NimbleOrmDateUtils;
import java.io.IOException;
import java.time.LocalTime;

public class MultiLocalTimeDeserializer
extends StdDeserializer<LocalTime> {
    private static final long serialVersionUID = 1L;

    public MultiLocalTimeDeserializer() {
        this(null);
    }

    public MultiLocalTimeDeserializer(Class<?> vc) {
        super(vc);
    }

    public LocalTime deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        String date = node.asText();
        try {
            LocalTime localTime = NimbleOrmDateUtils.parseLocalTime(date);
            if (localTime == null) {
                throw new JsonParseException(jp, "Unparseable localTime: \"" + date + "\". Supported formats: " + NimbleOrmDateUtils.DATE_FORMAT_REGEXPS.values());
            }
            return localTime;
        }
        catch (Exception e) {
            throw new JsonParseException(jp, "Unparseable localTime: \"" + date + "\". Supported formats: " + NimbleOrmDateUtils.DATE_FORMAT_REGEXPS.values());
        }
    }
}

