/*
 * Decompiled with CFR 0.152.
 */
package com.pugwoo.dbhelper.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.pugwoo.dbhelper.json.MultiDateDeserializer;
import com.pugwoo.dbhelper.json.MultiLocalDateDeserializer;
import com.pugwoo.dbhelper.json.MultiLocalDateTimeDeserializer;
import com.pugwoo.dbhelper.json.MultiLocalTimeDeserializer;
import com.pugwoo.dbhelper.json.NullKeySerializer;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Date;

public class MyObjectMapper
extends ObjectMapper {
    private static final long serialVersionUID = 7802045661502663726L;

    public MyObjectMapper() {
        this.setDateFormat(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
        this.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        this.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        this.configure(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT, true);
        this.getSerializerProvider().setNullKeySerializer((JsonSerializer)new NullKeySerializer());
        this.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        this.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        this.configure(JsonParser.Feature.ALLOW_NUMERIC_LEADING_ZEROS, true);
        this.configure(JsonParser.Feature.ALLOW_MISSING_VALUES, true);
        this.configure(JsonParser.Feature.ALLOW_TRAILING_COMMA, true);
        this.configure(JsonParser.Feature.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER, true);
        StdDeserializer deserializer = new MultiDateDeserializer();
        SimpleModule module = new SimpleModule("DateDeserializerModule", new Version(1, 0, 0, "", "", ""));
        module.addDeserializer(Date.class, (JsonDeserializer)deserializer);
        this.registerModule((Module)module);
        this.registerModule((Module)new JavaTimeModule());
        deserializer = new MultiLocalDateDeserializer();
        module = new SimpleModule("LocalDateDeserializerModule", new Version(1, 0, 0, "", "", ""));
        module.addDeserializer(LocalDate.class, (JsonDeserializer)deserializer);
        this.registerModule((Module)module);
        deserializer = new MultiLocalDateTimeDeserializer();
        module = new SimpleModule("LocalDateTimeDeserializerModule", new Version(1, 0, 0, "", "", ""));
        module.addDeserializer(LocalDateTime.class, (JsonDeserializer)deserializer);
        this.registerModule((Module)module);
        deserializer = new MultiLocalTimeDeserializer();
        module = new SimpleModule("LocalTimeDeserializerModule", new Version(1, 0, 0, "", "", ""));
        module.addDeserializer(LocalTime.class, (JsonDeserializer)deserializer);
        this.registerModule((Module)module);
    }
}

