/*
 * Decompiled with CFR 0.152.
 */
package com.pugwoo.dbhelper.json;

import com.pugwoo.dbhelper.utils.InnerCommonUtils;
import java.sql.Time;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class NimbleOrmDateUtils {
    public static final String FORMAT_STANDARD = "yyyy-MM-dd HH:mm:ss";
    public static final String FORMAT_DATE = "yyyy-MM-dd";
    public static final Map<String, String> DATE_FORMAT_REGEXPS = new HashMap<String, String>(){
        {
            this.put("^\\d{4}-\\d{1,2}-\\d{1,2}\\s\\d{1,2}:\\d{1,2}:\\d{1,2}$", NimbleOrmDateUtils.FORMAT_STANDARD);
            this.put("^\\d{4}-\\d{1,2}-\\d{1,2}$", NimbleOrmDateUtils.FORMAT_DATE);
            this.put("^\\d{6}$", "yyyyMM");
            this.put("^\\d{8}$", "yyyyMMdd");
            this.put("^\\d{14}$", "yyyyMMddHHmmss");
            this.put("^\\d{8}\\s\\d{6}$", "yyyyMMdd HHmmss");
            this.put("^\\d{4}-\\d{1,2}$", "yyyy-MM");
            this.put("^\\d{4}/\\d{1,2}$", "yyyy/MM");
            this.put("^\\d{4}/\\d{1,2}/\\d{1,2}$", "yyyy/MM/dd");
            this.put("^\\d{1,2}:\\d{1,2}:\\d{1,2}$", "HH:mm:ss");
            this.put("^\\d{1,2}:\\d{1,2}$", "HH:mm");
            this.put("^\\d{4}\u5e74\\d{1,2}\u6708\\d{1,2}\u65e5$", "yyyy\u5e74MM\u6708dd\u65e5");
            this.put("^\\d{4}-\\d{1,2}-\\d{1,2}\\s\\d{1,2}:\\d{1,2}$", "yyyy-MM-dd HH:mm");
            this.put("^\\d{4}/\\d{1,2}/\\d{1,2}\\s\\d{1,2}:\\d{1,2}$", "yyyy/MM/dd HH:mm");
            this.put("^\\d{4}/\\d{1,2}/\\d{1,2}\\s\\d{1,2}:\\d{1,2}:\\d{1,2}$", "yyyy/MM/dd HH:mm:ss");
            this.put("^\\d{4}-\\d{1,2}-\\d{1,2}\\s\\d{1,2}:\\d{1,2}:\\d{1,2}\\.\\d{1,3}$", "yyyy-MM-dd HH:mm:ss.SSS");
            this.put("^\\d{4}-\\d{1,2}-\\d{1,2}T\\d{1,2}:\\d{1,2}:\\d{1,2}\\.\\d{1,3}Z$", "yyyy-MM-dd'T'HH:mm:ss.SSSX");
            this.put("^\\d{4}-\\d{1,2}-\\d{1,2}T\\d{1,2}:\\d{1,2}:\\d{1,2}\\.\\d{1,3}$", "yyyy-MM-dd'T'HH:mm:ss.SSS");
            this.put("^\\d{4}-\\d{1,2}-\\d{1,2}T\\d{1,2}:\\d{1,2}:\\d{1,2}$", "yyyy-MM-dd'T'HH:mm:ss");
            this.put("^\\d{4}-\\d{1,2}-\\d{1,2}T\\d{1,2}:\\d{1,2}:\\d{1,2}\\.\\d{1,3}[+-]{1}\\d{4}$", "yyyy-MM-dd'T'HH:mm:ss.SSSZ");
            this.put("^\\d{4}-\\d{1,2}-\\d{1,2}T\\d{1,2}:\\d{1,2}:\\d{1,2}\\.\\d{1,3} [+-]{1}\\d{4}$", "yyyy-MM-dd'T'HH:mm:ss.SSS Z");
        }
    };

    public static Date parseThrowException(String date) throws ParseException {
        if (InnerCommonUtils.isBlank(date)) {
            return null;
        }
        String pattern = NimbleOrmDateUtils.determineDateFormat(date = date.trim());
        if (pattern == null) {
            Date _date = NimbleOrmDateUtils.tryParseTimestamp(date);
            if (_date != null) {
                return _date;
            }
            throw new ParseException("cannot parse date: \"" + date + "\". Supported formats: " + DATE_FORMAT_REGEXPS.values(), -1);
        }
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
            simpleDateFormat.setLenient(false);
            return simpleDateFormat.parse(date);
        }
        catch (Exception e) {
            if ("0000-00-00 00:00:00".equals(date) || "0000-00-00".equals(date)) {
                return null;
            }
            throw e;
        }
    }

    public static LocalDateTime parseLocalDateTime(String date) throws ParseException {
        return NimbleOrmDateUtils.toLocalDateTime(NimbleOrmDateUtils.parseThrowException(date));
    }

    public static LocalDateTime toLocalDateTime(Date date) {
        if (date == null) {
            return null;
        }
        if (date instanceof java.sql.Date || date instanceof Time) {
            date = new Date(date.getTime());
        }
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    public static LocalDate parseLocalDate(String date) throws ParseException {
        return NimbleOrmDateUtils.toLocalDate(NimbleOrmDateUtils.parseThrowException(date));
    }

    private static LocalDate toLocalDate(Date date) {
        if (date == null) {
            return null;
        }
        if (date instanceof java.sql.Date || date instanceof Time) {
            date = new Date(date.getTime());
        }
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
    }

    public static LocalTime parseLocalTime(String date) throws ParseException {
        return NimbleOrmDateUtils.toLocalTime(NimbleOrmDateUtils.parseThrowException(date));
    }

    private static LocalTime toLocalTime(Date date) {
        if (date == null) {
            return null;
        }
        if (date instanceof java.sql.Date || date instanceof Time) {
            date = new Date(date.getTime());
        }
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalTime();
    }

    private static Date tryParseTimestamp(String date) {
        if (!NimbleOrmDateUtils.isDigit(date)) {
            return null;
        }
        Long timestamp = NimbleOrmDateUtils.parseLong(date);
        if (timestamp == null) {
            return null;
        }
        if (timestamp < 4200000000L) {
            return new Date(timestamp * 1000L);
        }
        return new Date(timestamp);
    }

    private static boolean isDigit(String str) {
        if (str == null || str.isEmpty()) {
            return false;
        }
        for (char c : str.toCharArray()) {
            if (Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    private static Long parseLong(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Long) {
            return (Long)obj;
        }
        try {
            return Long.valueOf(obj.toString().trim());
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String format(Date date) {
        if (date == null) {
            return "";
        }
        return NimbleOrmDateUtils.format(date, FORMAT_STANDARD);
    }

    public static String formatDate(Date date) {
        if (date == null) {
            return "";
        }
        return NimbleOrmDateUtils.format(date, FORMAT_DATE);
    }

    public static String format(Date date, String pattern) {
        if (date == null) {
            return "";
        }
        return new SimpleDateFormat(pattern).format(date);
    }

    public static String formatWithMs(Date date) {
        return NimbleOrmDateUtils.format(date, "yyyy-MM-dd HH:mm:ss.SSS");
    }

    private static String determineDateFormat(String dateString) {
        for (String regexp : DATE_FORMAT_REGEXPS.keySet()) {
            if (!dateString.matches(regexp)) continue;
            return DATE_FORMAT_REGEXPS.get(regexp);
        }
        return null;
    }
}

