/*
 * Decompiled with CFR 0.152.
 */
package com.pugwoo.dbhelper.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.pugwoo.dbhelper.json.MyObjectMapper;
import com.pugwoo.dbhelper.utils.InnerCommonUtils;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NimbleOrmJSON {
    private static final Logger LOGGER = LoggerFactory.getLogger(NimbleOrmJSON.class);
    private static final ObjectMapper objectMapper = new MyObjectMapper();

    public static String toJson(Object obj) {
        try {
            return objectMapper.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T parse(String json, Class<T> clazz) throws IOException {
        if (InnerCommonUtils.isBlank(json)) {
            return null;
        }
        return (T)objectMapper.readValue(json, clazz);
    }

    public static Object parseGeneric(String json, ParameterizedType type) throws IOException {
        if (InnerCommonUtils.isBlank(json)) {
            return null;
        }
        JavaType javaType = NimbleOrmJSON.toJavaType(type);
        return objectMapper.readValue(json, javaType);
    }

    private static JavaType toJavaType(ParameterizedType type) {
        TypeFactory typeFactory = objectMapper.getTypeFactory();
        Type rawType = type.getRawType();
        Type[] actualTypeArguments = type.getActualTypeArguments();
        JavaType[] javaTypes = new JavaType[actualTypeArguments.length];
        for (int i = 0; i < actualTypeArguments.length; ++i) {
            if (actualTypeArguments[i] instanceof Class) {
                javaTypes[i] = typeFactory.constructType(actualTypeArguments[i]);
                continue;
            }
            if (actualTypeArguments[i] instanceof ParameterizedType) {
                javaTypes[i] = NimbleOrmJSON.toJavaType((ParameterizedType)actualTypeArguments[i]);
                continue;
            }
            LOGGER.error("unknown actualTypeArguments type:{} in type:{}", (Object)actualTypeArguments[i], (Object)type);
        }
        return typeFactory.constructParametricType((Class)rawType, javaTypes);
    }
}

