/*
 * Decompiled with CFR 0.152.
 */
package com.pugwoo.dbhelper.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public class PageData<T>
implements Serializable {
    private static final long serialVersionUID = 3L;
    private long total;
    private int pageSize;
    private List<T> data;

    public PageData() {
        this.data = new ArrayList<T>();
    }

    public PageData(long total, List<T> data, int pageSize) {
        this.total = total;
        this.data = data;
        this.pageSize = pageSize;
    }

    public <R> PageData<R> transform(Function<? super T, ? extends R> mapper) {
        List dataR = null;
        if (this.data != null) {
            dataR = this.data.stream().map(mapper).collect(Collectors.toList());
        }
        return new PageData<T>(this.total, dataR, this.pageSize);
    }

    public int getTotalPage() {
        if (this.total <= 0L) {
            return 0;
        }
        if (this.pageSize < 1) {
            return (int)this.total;
        }
        return (int)((this.total + (long)this.pageSize - 1L) / (long)this.pageSize);
    }

    public long getTotal() {
        return this.total;
    }

    public void setTotal(long total) {
        this.total = total;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public List<T> getData() {
        return this.data;
    }

    public void setData(List<T> data) {
        this.data = data;
    }
}

