/*
 * Decompiled with CFR 0.152.
 */
package com.pugwoo.dbhelper.sql;

import com.pugwoo.dbhelper.annotation.JoinLeftTable;
import com.pugwoo.dbhelper.annotation.JoinRightTable;
import com.pugwoo.dbhelper.annotation.JoinTable;
import com.pugwoo.dbhelper.annotation.Table;
import com.pugwoo.dbhelper.enums.DatabaseTypeEnum;
import com.pugwoo.dbhelper.enums.FeatureEnum;
import com.pugwoo.dbhelper.enums.JoinTypeEnum;
import com.pugwoo.dbhelper.exception.BadSQLSyntaxException;
import com.pugwoo.dbhelper.exception.CasVersionNotMatchException;
import com.pugwoo.dbhelper.exception.InvalidParameterException;
import com.pugwoo.dbhelper.exception.NoKeyColumnAnnotationException;
import com.pugwoo.dbhelper.exception.NullKeyValueException;
import com.pugwoo.dbhelper.exception.OnConditionIsNeedException;
import com.pugwoo.dbhelper.impl.DBHelperContext;
import com.pugwoo.dbhelper.json.NimbleOrmJSON;
import com.pugwoo.dbhelper.sql.FixedAndExpression;
import com.pugwoo.dbhelper.sql.InsertSQLForBatchDTO;
import com.pugwoo.dbhelper.sql.SQLDialect;
import com.pugwoo.dbhelper.utils.DOInfoReader;
import com.pugwoo.dbhelper.utils.InnerCommonUtils;
import com.pugwoo.dbhelper.utils.PreHandleObject;
import com.pugwoo.dbhelper.utils.ScriptUtils;
import com.pugwoo.dbhelper.utils.TypeAutoCast;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.GroupByElement;
import net.sf.jsqlparser.statement.select.Limit;
import net.sf.jsqlparser.statement.select.OrderByElement;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(SQLUtils.class);
    private static final Map<String, Boolean> containsLimitCache = new ConcurrentHashMap<String, Boolean>();

    public static String getSelectSQL(DatabaseTypeEnum databaseType, Class<?> clazz, boolean selectOnlyKey, boolean isSelect1, Map<FeatureEnum, Boolean> features, String postSql) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ");
        JoinTable joinTable = DOInfoReader.getJoinTable(clazz);
        if (joinTable != null) {
            Field leftTableField = DOInfoReader.getJoinLeftTable(clazz);
            Field rightTableField = DOInfoReader.getJoinRightTable(clazz);
            JoinLeftTable joinLeftTable = leftTableField.getAnnotation(JoinLeftTable.class);
            JoinRightTable joinRightTable = rightTableField.getAnnotation(JoinRightTable.class);
            if (isSelect1) {
                sql.append("1");
                String computedColumnsForCountSelect = SQLUtils.getComputedColumnsForCountSelect(databaseType, leftTableField.getType(), joinLeftTable.alias() + ".", features, postSql);
                if (InnerCommonUtils.isNotBlank(computedColumnsForCountSelect)) {
                    sql.append(",").append(computedColumnsForCountSelect);
                }
                if (InnerCommonUtils.isNotBlank(computedColumnsForCountSelect = SQLUtils.getComputedColumnsForCountSelect(databaseType, rightTableField.getType(), joinRightTable.alias() + ".", features, postSql))) {
                    sql.append(",").append(computedColumnsForCountSelect);
                }
            } else {
                List<Field> fields1 = DOInfoReader.getColumnsForSelect(leftTableField.getType(), selectOnlyKey);
                List<Field> fields2 = DOInfoReader.getColumnsForSelect(rightTableField.getType(), selectOnlyKey);
                sql.append(SQLUtils.joinColumnForSelect(databaseType, fields1, joinLeftTable.alias() + ".", features));
                sql.append(",");
                sql.append(SQLUtils.joinColumnForSelect(databaseType, fields2, joinRightTable.alias() + ".", features));
            }
            sql.append(" FROM ").append(SQLUtils.getTableName(databaseType, leftTableField.getType())).append(" ").append(joinLeftTable.alias()).append(" ");
            if (databaseType == DatabaseTypeEnum.MYSQL && InnerCommonUtils.isNotBlank(joinLeftTable.forceIndex())) {
                sql.append(" FORCE INDEX(").append(joinLeftTable.forceIndex()).append(") ");
            }
            String join = InnerCommonUtils.isBlank(joinTable.joinTypeAsString()) ? joinTable.joinType().getCode() : joinTable.joinTypeAsString();
            sql.append(join).append(" ");
            sql.append(SQLUtils.getTableName(databaseType, rightTableField.getType())).append(" ").append(joinRightTable.alias());
            if (databaseType == DatabaseTypeEnum.MYSQL && InnerCommonUtils.isNotBlank(joinRightTable.forceIndex())) {
                sql.append(" FORCE INDEX(").append(joinRightTable.forceIndex()).append(") ");
            }
            if (InnerCommonUtils.isBlank(joinTable.on())) {
                throw new OnConditionIsNeedException("join table :" + clazz.getName());
            }
            sql.append(" on ").append(joinTable.on());
        } else {
            Table table = DOInfoReader.getTable(clazz);
            if (InnerCommonUtils.isNotBlank(table.virtualTableSQL())) {
                if (InnerCommonUtils.isNotBlank(table.value())) {
                    LOGGER.warn("table DO class:{} table name:{} is ignored because virtualTableSQL has value:{}", new Object[]{clazz, table.value(), table.virtualTableSQL()});
                }
                return table.virtualTableSQL();
            }
            if (InnerCommonUtils.isNotBlank(table.virtualTablePath())) {
                if (InnerCommonUtils.isNotBlank(table.value())) {
                    LOGGER.warn("table DO class:{} table name:{} is ignored because virtualTablePath has value:{}", new Object[]{clazz, table.value(), table.virtualTableSQL()});
                }
                return InnerCommonUtils.readClasspathResourceAsString(table.virtualTablePath());
            }
            if (isSelect1) {
                sql.append("1");
                String computedColumnsForCountSelect = SQLUtils.getComputedColumnsForCountSelect(databaseType, clazz, null, features, postSql);
                if (InnerCommonUtils.isNotBlank(computedColumnsForCountSelect)) {
                    sql.append(",").append(computedColumnsForCountSelect);
                }
            } else {
                List<Field> fields = DOInfoReader.getColumnsForSelect(clazz, selectOnlyKey);
                sql.append(SQLUtils.joinColumnForSelect(databaseType, fields, null, features));
            }
            sql.append(" FROM ").append(SQLUtils.getTableName(databaseType, clazz)).append(" ").append(table.alias());
        }
        return sql.toString();
    }

    private static String getComputedColumnsForCountSelect(DatabaseTypeEnum databaseType, Class<?> clazz, String fieldPrefix, Map<FeatureEnum, Boolean> features, String postSql) {
        List<Field> fields = DOInfoReader.getColumnsForSelect(clazz, false);
        ArrayList<Field> field2 = new ArrayList<Field>();
        for (Field field : fields) {
            com.pugwoo.dbhelper.annotation.Column column = field.getAnnotation(com.pugwoo.dbhelper.annotation.Column.class);
            if (column == null || !InnerCommonUtils.isNotBlank(column.computed()) || postSql == null || !postSql.contains(column.value())) continue;
            field2.add(field);
        }
        if (field2.isEmpty()) {
            return "";
        }
        return SQLUtils.joinColumnForSelect(databaseType, field2, fieldPrefix, features);
    }

    public static String getSelectCountSQL(DatabaseTypeEnum databaseType, Class<?> clazz) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT count(*)");
        JoinTable joinTable = DOInfoReader.getJoinTable(clazz);
        if (joinTable != null) {
            Field leftTableField = DOInfoReader.getJoinLeftTable(clazz);
            Field rightTableField = DOInfoReader.getJoinRightTable(clazz);
            JoinLeftTable joinLeftTable = leftTableField.getAnnotation(JoinLeftTable.class);
            JoinRightTable joinRightTable = rightTableField.getAnnotation(JoinRightTable.class);
            sql.append(" FROM ").append(SQLUtils.getTableName(databaseType, leftTableField.getType())).append(" ").append(joinLeftTable.alias()).append(" ");
            if (databaseType == DatabaseTypeEnum.MYSQL && InnerCommonUtils.isNotBlank(joinLeftTable.forceIndex())) {
                sql.append(" FORCE INDEX(").append(joinLeftTable.forceIndex()).append(") ");
            }
            String join = InnerCommonUtils.isBlank(joinTable.joinTypeAsString()) ? joinTable.joinType().getCode() : joinTable.joinTypeAsString();
            sql.append(join).append(" ");
            sql.append(SQLUtils.getTableName(databaseType, rightTableField.getType())).append(" ").append(joinRightTable.alias());
            if (databaseType == DatabaseTypeEnum.MYSQL && InnerCommonUtils.isNotBlank(joinRightTable.forceIndex())) {
                sql.append(" FORCE INDEX(").append(joinRightTable.forceIndex()).append(") ");
            }
            if (InnerCommonUtils.isBlank(joinTable.on())) {
                throw new OnConditionIsNeedException("join table VO:" + clazz.getName());
            }
            sql.append(" on ").append(joinTable.on());
        } else {
            Table table = DOInfoReader.getTable(clazz);
            if (InnerCommonUtils.isNotBlank(table.virtualTableSQL())) {
                if (InnerCommonUtils.isNotBlank(table.value())) {
                    LOGGER.warn("table DO class:{} table name:{} is ignored because virtualTable has value:{}", new Object[]{clazz, table.value(), table.virtualTableSQL()});
                }
                sql.append(" FROM ( ").append(table.virtualTableSQL()).append(" )");
                return sql.toString();
            }
            if (InnerCommonUtils.isNotBlank(table.virtualTablePath())) {
                if (InnerCommonUtils.isNotBlank(table.value())) {
                    LOGGER.warn("table DO class:{} table name:{} is ignored because virtualTablePath has value:{}", new Object[]{clazz, table.value(), table.virtualTablePath()});
                }
                String vSQL = InnerCommonUtils.readClasspathResourceAsString(table.virtualTablePath());
                sql.append(" FROM ( ").append(vSQL).append(" )");
                return sql.toString();
            }
            sql.append(" FROM ").append(SQLUtils.getTableName(databaseType, clazz)).append(" ").append(table.alias());
        }
        return sql.toString();
    }

    public static <T> String getKeysWhereSQL(DatabaseTypeEnum databaseType, T t, List<Object> keyValues) throws NoKeyColumnAnnotationException, NullKeyValueException {
        List<Field> keyFields = DOInfoReader.getKeyColumns(t.getClass());
        ArrayList<Object> _keyValues = new ArrayList<Object>();
        String where = SQLUtils.joinWhereAndGetValue(databaseType, keyFields, "AND", _keyValues, t);
        for (Object e : _keyValues) {
            if (e != null) continue;
            throw new NullKeyValueException();
        }
        if (keyValues != null) {
            keyValues.addAll(_keyValues);
        }
        return SQLUtils.autoSetSoftDeleted(databaseType, "WHERE " + where, t.getClass());
    }

    public static String getKeysWhereSQLWithoutSoftDelete(DatabaseTypeEnum databaseType, Class<?> clazz) throws NoKeyColumnAnnotationException {
        List<Field> keyFields = DOInfoReader.getKeyColumns(clazz);
        String where = SQLUtils.joinWhere(databaseType, keyFields, "AND");
        return "WHERE " + where;
    }

    public static <T> String getInsertSQL(DatabaseTypeEnum databaseType, T t, List<Object> values, boolean isWithNullValue) {
        StringBuilder sql = new StringBuilder("INSERT INTO ");
        List<Field> fields = DOInfoReader.getColumns(t.getClass());
        sql.append(SQLUtils.getTableName(databaseType, t.getClass())).append(" (");
        ArrayList<Object> _values = new ArrayList<Object>();
        String insertSql = SQLUtils.joinAndGetValueForInsert(databaseType, fields, ",", _values, t, isWithNullValue);
        sql.append(insertSql);
        sql.append(") VALUES ");
        String dotSql = "(" + SQLUtils.join("?", _values.size(), ",") + ")";
        sql.append(dotSql);
        values.addAll(_values);
        return sql.toString();
    }

    public static <T> InsertSQLForBatchDTO getInsertSQLForBatch(DatabaseTypeEnum databaseType, Collection<T> list, List<Object> values) {
        StringBuilder sql = new StringBuilder("INSERT INTO ");
        Class<?> clazz = list.iterator().next().getClass();
        List<Field> fields = DOInfoReader.getColumns(clazz);
        fields = SQLUtils.filterFieldWithValue(fields, list);
        SQLUtils.appendTableName(databaseType, sql, clazz);
        SQLUtils.appendInsertColumnSql(databaseType, sql, fields);
        int sqlLogEndIndex = 0;
        int paramLogEndIndex = 0;
        boolean isFirst = true;
        for (T t : list) {
            sql.append(isFirst ? "VALUES" : ",");
            SQLUtils.appendValueForBatchInsert(sql, fields, values, t, databaseType);
            if (isFirst) {
                sqlLogEndIndex = sql.length();
                paramLogEndIndex = values.size();
            }
            isFirst = false;
        }
        return new InsertSQLForBatchDTO(sql.toString(), sqlLogEndIndex, paramLogEndIndex);
    }

    public static InsertSQLForBatchDTO getInsertSQLForBatch(DatabaseTypeEnum databaseType, String tableName, Collection<Map<String, Object>> list, List<Object> values) {
        StringBuilder sql = new StringBuilder("INSERT INTO ");
        sql.append(SQLUtils.getTableName(databaseType, tableName.trim()));
        sql.append(" (");
        boolean isFirst = true;
        int sqlLogEndIndex = 0;
        int paramLogEndIndex = 0;
        HashSet<String> colSet = new HashSet<String>();
        for (Map<String, Object> map : list) {
            colSet.addAll(map.keySet());
        }
        ArrayList cols = new ArrayList(colSet);
        for (Map<String, Object> map : list) {
            StringBuilder sb = new StringBuilder("(");
            for (String col : cols) {
                Object value = map.get(col);
                if (value == null) {
                    sb.append(SQLDialect.getInsertDefaultValue(databaseType));
                } else {
                    sb.append("?");
                    values.add(value);
                }
                sb.append(",");
            }
            if (isFirst) {
                for (int i = 0; i < cols.size(); ++i) {
                    if (i != 0) {
                        sql.append(",");
                    }
                    sql.append(SQLUtils.getColumnName(databaseType, (String)cols.get(i)));
                }
                sql.append(") VALUES ");
            } else {
                sql.append(",");
            }
            String dotSql = sb.substring(0, sb.length() - 1) + ")";
            sql.append(dotSql);
            if (!isFirst) continue;
            sqlLogEndIndex = sql.length();
            paramLogEndIndex = values.size();
            isFirst = false;
        }
        return new InsertSQLForBatchDTO(sql.toString(), sqlLogEndIndex, paramLogEndIndex);
    }

    public static InsertSQLForBatchDTO getInsertSQLForBatch(DatabaseTypeEnum databaseType, String tableName, List<String> cols, Collection<Object[]> list, List<Object> values) {
        StringBuilder sql = new StringBuilder("INSERT INTO ");
        sql.append(SQLUtils.getTableName(databaseType, tableName.trim()));
        sql.append(" (");
        boolean isFirst = true;
        int sqlLogEndIndex = 0;
        int paramLogEndIndex = 0;
        for (Object[] valueArray : list) {
            StringBuilder sb = new StringBuilder("(");
            for (Object value : valueArray) {
                if (value == null) {
                    sb.append(SQLDialect.getInsertDefaultValue(databaseType));
                } else {
                    sb.append("?");
                    values.add(value);
                }
                sb.append(",");
            }
            if (isFirst) {
                for (int i = 0; i < cols.size(); ++i) {
                    if (i != 0) {
                        sql.append(",");
                    }
                    sql.append(SQLUtils.getColumnName(databaseType, cols.get(i)));
                }
                sql.append(") VALUES ");
            } else {
                sql.append(",");
            }
            String dotSql = sb.substring(0, sb.length() - 1) + ")";
            sql.append(dotSql);
            if (!isFirst) continue;
            sqlLogEndIndex = sql.length();
            paramLogEndIndex = values.size();
            isFirst = false;
        }
        return new InsertSQLForBatchDTO(sql.toString(), sqlLogEndIndex, paramLogEndIndex);
    }

    public static <T> String getInsertSQLForBatchForJDBCTemplate(DatabaseTypeEnum databaseType, Collection<T> list, List<Object[]> values) {
        StringBuilder sql = new StringBuilder("INSERT INTO ");
        Class<?> clazz = list.iterator().next().getClass();
        List<Field> fields = DOInfoReader.getColumns(clazz);
        fields = SQLUtils.filterFieldWithValue(fields, list);
        SQLUtils.appendTableName(databaseType, sql, clazz);
        sql.append(" (");
        boolean isFirst = true;
        for (T t : list) {
            ArrayList<Object> _values = new ArrayList<Object>();
            String insertSql = SQLUtils.joinAndGetValueForInsert(databaseType, fields, ",", _values, t, true);
            if (isFirst) {
                sql.append(insertSql);
                sql.append(") VALUES ");
                String dotSql = "(" + SQLUtils.join("?", _values.size(), ",") + ")";
                sql.append(dotSql);
            }
            isFirst = false;
            values.add(_values.toArray());
        }
        return sql.toString();
    }

    public static String getInsertSQLForBatchForJDBCTemplate(DatabaseTypeEnum databaseType, String tableName, Collection<Map<String, Object>> list, List<Object[]> values) {
        StringBuilder sql = new StringBuilder("INSERT INTO ");
        sql.append(SQLUtils.getTableName(databaseType, tableName.trim()));
        sql.append(" (");
        HashSet<String> colSet = new HashSet<String>();
        for (Map<String, Object> map : list) {
            colSet.addAll(map.keySet());
        }
        ArrayList cols = new ArrayList(colSet);
        boolean isFirst = true;
        for (Map<String, Object> map : list) {
            ArrayList<Object> _values = new ArrayList<Object>();
            for (Object col : cols) {
                _values.add(map.get(col));
            }
            if (isFirst) {
                Object col;
                boolean isColFirst = true;
                col = cols.iterator();
                while (col.hasNext()) {
                    String col2 = (String)col.next();
                    if (!isColFirst) {
                        sql.append(",");
                    } else {
                        isColFirst = false;
                    }
                    sql.append(SQLUtils.getColumnName(databaseType, col2.trim()));
                }
                sql.append(") VALUES ");
                String dotSql = "(" + SQLUtils.join("?", _values.size(), ",") + ")";
                sql.append(dotSql);
                isFirst = false;
            }
            values.add(_values.toArray());
        }
        return sql.toString();
    }

    public static String getInsertSQLForBatchForJDBCTemplate(DatabaseTypeEnum databaseType, String tableName, List<String> cols) {
        StringBuilder sql = new StringBuilder();
        sql.append("INSERT INTO ").append(SQLUtils.getTableName(databaseType, tableName.trim())).append(" (");
        boolean isFirst = true;
        for (String col : cols) {
            if (!isFirst) {
                sql.append(",");
            } else {
                isFirst = false;
            }
            sql.append(SQLUtils.getColumnName(databaseType, col.trim()));
        }
        sql.append(") VALUES (").append(SQLUtils.join("?", cols.size(), ",")).append(")");
        return sql.toString();
    }

    private static <T> List<Field> filterFieldWithValue(List<Field> fields, Collection<T> list) {
        fields = InnerCommonUtils.filter(fields, o -> {
            com.pugwoo.dbhelper.annotation.Column column = o.getAnnotation(com.pugwoo.dbhelper.annotation.Column.class);
            return column != null && InnerCommonUtils.isBlank(column.computed());
        });
        ArrayList<Field> result = new ArrayList<Field>();
        block0: for (Field field : fields) {
            for (T t : list) {
                if (DOInfoReader.getValue(field, t) == null) continue;
                result.add(field);
                continue block0;
            }
        }
        return result;
    }

    private static void appendValueForBatchInsert(StringBuilder sb, List<Field> fields, List<Object> values, Object obj, DatabaseTypeEnum databaseType) {
        if (values == null || obj == null) {
            throw new InvalidParameterException("joinAndGetValueForInsert require values and obj");
        }
        sb.append("(");
        for (int i = 0; i < fields.size(); ++i) {
            Field field;
            com.pugwoo.dbhelper.annotation.Column column;
            if (i > 0) {
                sb.append(",");
            }
            if (InnerCommonUtils.isNotBlank((column = (field = fields.get(i)).getAnnotation(com.pugwoo.dbhelper.annotation.Column.class)).computed())) continue;
            Object value = DOInfoReader.getValue(field, obj);
            if (value != null) {
                if (column.isJSON()) {
                    value = NimbleOrmJSON.toJson(value);
                }
                if (databaseType == DatabaseTypeEnum.CLICKHOUSE && field.getType().equals(byte[].class) && value instanceof byte[]) {
                    value = InnerCommonUtils.encodeBase64((byte[])value);
                }
            }
            if (value == null) {
                sb.append(SQLDialect.getInsertDefaultValue(databaseType));
                continue;
            }
            sb.append("?");
            values.add(value);
        }
        sb.append(")");
    }

    public static <T> BatchUpdateResultDTO getBatchUpdateSQL(DatabaseTypeEnum databaseType, Collection<T> list, List<Object> values, Field casVersionColumn, Field keyColumn, List<Field> notKeyColumns, Class<?> clazz) {
        ArrayList<Object> keys = new ArrayList<Object>(list.size());
        for (Object t : list) {
            Object key = DOInfoReader.getValue(keyColumn, t);
            if (key == null) {
                throw new NullKeyValueException("class:" + t.getClass().getName() + ",values:" + NimbleOrmJSON.toJson(t));
            }
            keys.add(key);
        }
        ArrayList<Field> notKeyNotNullFields = new ArrayList<Field>();
        block1: for (Field field : notKeyColumns) {
            for (T t : list) {
                if (DOInfoReader.getValue(field, t) == null) continue;
                notKeyNotNullFields.add(field);
                continue block1;
            }
        }
        if (casVersionColumn == null && notKeyNotNullFields.isEmpty()) {
            BatchUpdateResultDTO dto = new BatchUpdateResultDTO();
            dto.setSql("");
            return dto;
        }
        StringBuilder sql = new StringBuilder();
        StringBuilder logSql = new StringBuilder();
        ArrayList<Object> logParams = new ArrayList<Object>();
        sql.append("UPDATE ").append(SQLUtils.getTableName(databaseType, clazz)).append(" SET ");
        logSql.append((CharSequence)sql);
        boolean isFirst = true;
        for (Field field : notKeyNotNullFields) {
            if (isFirst) {
                isFirst = false;
            } else {
                sql.append(",");
                logSql.append(",");
            }
            sql.append(SQLUtils.getColumnName(databaseType, field)).append("=(CASE");
            logSql.append(SQLUtils.getColumnName(databaseType, field)).append("=(CASE");
            boolean isFirstT = true;
            for (T t : list) {
                Object value;
                StringBuilder sqlOld = null;
                List<Object> valuesOld = null;
                if (isFirstT) {
                    sqlOld = sql;
                    valuesOld = values;
                    sql = new StringBuilder();
                    values = new ArrayList<Object>();
                }
                if (casVersionColumn == null) {
                    sql.append(" WHEN ").append(SQLUtils.getColumnName(databaseType, keyColumn)).append("=? THEN ");
                    values.add(DOInfoReader.getValue(keyColumn, t));
                    value = DOInfoReader.getValue(field, t);
                    if (value == null) {
                        sql.append(SQLUtils.getColumnName(databaseType, field));
                    } else {
                        if (field.getAnnotation(com.pugwoo.dbhelper.annotation.Column.class).isJSON()) {
                            value = NimbleOrmJSON.toJson(value);
                        }
                        if (databaseType == DatabaseTypeEnum.CLICKHOUSE && field.getType().equals(byte[].class) && value instanceof byte[]) {
                            value = InnerCommonUtils.encodeBase64((byte[])value);
                        }
                        sql.append("?");
                        values.add(value);
                    }
                } else {
                    sql.append(" WHEN ").append(SQLUtils.getColumnName(databaseType, keyColumn)).append("=? AND ").append(SQLUtils.getColumnName(databaseType, casVersionColumn)).append("=? THEN ");
                    values.add(DOInfoReader.getValue(keyColumn, t));
                    values.add(DOInfoReader.getValue(casVersionColumn, t));
                    value = DOInfoReader.getValue(field, t);
                    if (value == null) {
                        sql.append(SQLUtils.getColumnName(databaseType, field));
                    } else {
                        if (field.getAnnotation(com.pugwoo.dbhelper.annotation.Column.class).isJSON()) {
                            value = NimbleOrmJSON.toJson(value);
                        }
                        if (databaseType == DatabaseTypeEnum.CLICKHOUSE && field.getType().equals(byte[].class) && value instanceof byte[]) {
                            value = InnerCommonUtils.encodeBase64((byte[])value);
                        }
                        sql.append("?");
                        values.add(value);
                    }
                    sql.append(" WHEN ").append(SQLUtils.getColumnName(databaseType, keyColumn)).append("=? AND ").append(SQLUtils.getColumnName(databaseType, casVersionColumn)).append("!=? THEN ");
                    values.add(DOInfoReader.getValue(keyColumn, t));
                    values.add(DOInfoReader.getValue(casVersionColumn, t));
                    sql.append(SQLUtils.getColumnName(databaseType, field));
                }
                if (!isFirstT) continue;
                logSql.append((CharSequence)sql);
                sqlOld.append((CharSequence)sql);
                valuesOld.addAll(values);
                logParams.addAll(values);
                sql = sqlOld;
                values = valuesOld;
                isFirstT = false;
            }
            sql.append(" END)");
            logSql.append(" END)");
        }
        if (casVersionColumn != null) {
            if (!isFirst) {
                sql.append(",");
                logSql.append(",");
            }
            sql.append(SQLUtils.getColumnName(databaseType, casVersionColumn)).append("=(CASE");
            logSql.append(SQLUtils.getColumnName(databaseType, casVersionColumn)).append("=(CASE");
            boolean isFirstT = true;
            for (T t : list) {
                StringBuilder sqlOld = null;
                List<Object> valuesOld = null;
                if (isFirstT) {
                    sqlOld = sql;
                    valuesOld = values;
                    sql = new StringBuilder();
                    values = new ArrayList<Object>();
                }
                sql.append(" WHEN ").append(SQLUtils.getColumnName(databaseType, keyColumn)).append("=? AND ").append(SQLUtils.getColumnName(databaseType, casVersionColumn)).append("=? THEN ").append(SQLUtils.getColumnName(databaseType, casVersionColumn)).append("+1");
                values.add(DOInfoReader.getValue(keyColumn, t));
                values.add(DOInfoReader.getValue(casVersionColumn, t));
                sql.append(" WHEN ").append(SQLUtils.getColumnName(databaseType, keyColumn)).append("=? AND ").append(SQLUtils.getColumnName(databaseType, casVersionColumn)).append("!=? THEN ").append(SQLUtils.getColumnName(databaseType, casVersionColumn));
                values.add(DOInfoReader.getValue(keyColumn, t));
                values.add(DOInfoReader.getValue(casVersionColumn, t));
                if (!isFirstT) continue;
                logSql.append((CharSequence)sql);
                sqlOld.append((CharSequence)sql);
                valuesOld.addAll(values);
                logParams.addAll(values);
                sql = sqlOld;
                values = valuesOld;
                isFirstT = false;
            }
            sql.append(" END)");
            logSql.append(" END)");
        }
        String where = "WHERE " + SQLUtils.getColumnName(databaseType, keyColumn) + " IN (?)";
        values.add(keys);
        if (casVersionColumn != null) {
            where = where + " AND (" + SQLUtils.getColumnName(databaseType, keyColumn) + "," + SQLUtils.getColumnName(databaseType, casVersionColumn) + ") IN (?)";
            ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
            for (T t : list) {
                arrayList.add(new Object[]{DOInfoReader.getValue(keyColumn, t), DOInfoReader.getValue(casVersionColumn, t)});
            }
            values.add(arrayList);
        }
        where = SQLUtils.autoSetSoftDeleted(databaseType, where, clazz);
        sql.append(where);
        logSql.append(where);
        BatchUpdateResultDTO batchUpdateResultDTO = new BatchUpdateResultDTO();
        batchUpdateResultDTO.setSql(sql.toString());
        batchUpdateResultDTO.setLogSql(logSql.toString());
        batchUpdateResultDTO.setLogParams(logParams);
        return batchUpdateResultDTO;
    }

    public static <T> String getUpdateSQL(DatabaseTypeEnum databaseType, T t, List<Object> values, boolean withNull, String postSql) {
        StringBuilder sql = new StringBuilder();
        sql.append("UPDATE ");
        List<Field> keyFields = DOInfoReader.getKeyColumns(t.getClass());
        List<Field> notKeyFields = DOInfoReader.getNotKeyColumns(t.getClass());
        sql.append(SQLUtils.getTableName(databaseType, t.getClass())).append(" SET ");
        ArrayList<Object> setValues = new ArrayList<Object>();
        String setSql = SQLUtils.joinSetAndGetValue(databaseType, notKeyFields, setValues, t, withNull);
        if (setValues.isEmpty()) {
            return null;
        }
        sql.append(setSql);
        values.addAll(setValues);
        ArrayList<Object> whereValues = new ArrayList<Object>();
        String where = "WHERE " + SQLUtils.joinWhereAndGetValue(databaseType, keyFields, "AND", whereValues, t);
        for (Object e : whereValues) {
            if (e != null) continue;
            throw new NullKeyValueException();
        }
        values.addAll(whereValues);
        Field casVersionField = DOInfoReader.getCasVersionColumn(t.getClass());
        if (casVersionField != null) {
            ArrayList<Field> arrayList = new ArrayList<Field>();
            arrayList.add(casVersionField);
            ArrayList<Object> casValues = new ArrayList<Object>();
            String casWhere = SQLUtils.joinWhereAndGetValue(databaseType, arrayList, "AND", casValues, t);
            if (casValues.size() != 1 || casValues.get(0) == null) {
                throw new CasVersionNotMatchException("casVersion column value is null");
            }
            values.add(casValues.get(0));
            where = where + " AND " + casWhere;
        }
        if (postSql != null && !(postSql = postSql.trim()).isEmpty()) {
            if (postSql.startsWith("where")) {
                postSql = " AND " + postSql.substring(5);
            }
            where = where + postSql;
        }
        sql.append(SQLUtils.autoSetSoftDeleted(databaseType, where, t.getClass()));
        return sql.toString();
    }

    public static <T> String getUpdateAllSQL(DatabaseTypeEnum databaseType, Class<T> clazz, String setSql, String whereSql, String extraWhereSql) {
        StringBuilder sql = new StringBuilder();
        sql.append("UPDATE ");
        List<Field> fields = DOInfoReader.getColumns(clazz);
        sql.append(SQLUtils.getTableName(databaseType, clazz)).append(" ");
        if (setSql.trim().toLowerCase().startsWith("set ")) {
            sql.append(setSql);
        } else {
            sql.append("SET ").append(setSql);
        }
        for (Field field : fields) {
            Object value;
            String nowDateTime;
            com.pugwoo.dbhelper.annotation.Column column = field.getAnnotation(com.pugwoo.dbhelper.annotation.Column.class);
            if (column.setTimeWhenUpdate() && (nowDateTime = PreHandleObject.getNowDateTime(field.getType())) != null) {
                sql.append(",").append(SQLUtils.getColumnName(databaseType, column)).append("='").append(nowDateTime).append("'");
            }
            if (!InnerCommonUtils.isNotBlank(column.updateValueScript()) || (value = ScriptUtils.getValueFromScript(column.ignoreScriptError(), column.updateValueScript())) == null) continue;
            sql.append(",").append(SQLUtils.getColumnName(databaseType, column)).append("=").append(TypeAutoCast.toSqlValueStr(value));
        }
        sql.append(SQLUtils.autoSetSoftDeleted(databaseType, whereSql, clazz, extraWhereSql));
        return sql.toString();
    }

    public static <T> String getCustomUpdateSQL(DatabaseTypeEnum databaseType, T t, List<Object> values, String setSql) {
        StringBuilder sql = new StringBuilder();
        sql.append("UPDATE ");
        List<Field> fields = DOInfoReader.getColumns(t.getClass());
        List<Field> keyFields = DOInfoReader.getKeyColumns(t.getClass());
        sql.append(SQLUtils.getTableName(databaseType, t.getClass())).append(" ");
        if (setSql.trim().toLowerCase().startsWith("set ")) {
            sql.append(setSql);
        } else {
            sql.append("SET ").append(setSql);
        }
        for (Field field : fields) {
            Object value;
            String nowDateTime;
            com.pugwoo.dbhelper.annotation.Column column = field.getAnnotation(com.pugwoo.dbhelper.annotation.Column.class);
            if (column.setTimeWhenUpdate() && (nowDateTime = PreHandleObject.getNowDateTime(field.getType())) != null) {
                sql.append(",").append(SQLUtils.getColumnName(databaseType, column)).append("='").append(nowDateTime).append("'");
            }
            if (column.casVersion()) {
                long _v;
                value = DOInfoReader.getValue(field, t);
                if (value == null) {
                    throw new CasVersionNotMatchException("casVersion column value is null");
                }
                if (value instanceof Long) {
                    _v = (Long)value;
                } else if (value instanceof Integer) {
                    _v = ((Integer)value).longValue();
                } else {
                    throw new CasVersionNotMatchException("casVersion column value type must be Integer or Long");
                }
                sql.append(",").append(SQLUtils.getColumnName(databaseType, column)).append("=").append(_v + 1L);
            }
            if (!InnerCommonUtils.isNotBlank(column.updateValueScript()) || (value = ScriptUtils.getValueFromScript(t, column.ignoreScriptError(), column.updateValueScript())) == null) continue;
            sql.append(",").append(SQLUtils.getColumnName(databaseType, column)).append("=").append(TypeAutoCast.toSqlValueStr(value));
        }
        ArrayList<Object> whereValues = new ArrayList<Object>();
        String where = "WHERE " + SQLUtils.joinWhereAndGetValue(databaseType, keyFields, "AND", whereValues, t);
        for (Object value : whereValues) {
            if (value != null) continue;
            throw new NullKeyValueException();
        }
        values.addAll(whereValues);
        Field casVersionField = DOInfoReader.getCasVersionColumn(t.getClass());
        if (casVersionField != null) {
            ArrayList<Field> casVersionFields = new ArrayList<Field>();
            casVersionFields.add(casVersionField);
            ArrayList<Object> casValues = new ArrayList<Object>();
            String casWhere = SQLUtils.joinWhereAndGetValue(databaseType, casVersionFields, "AND", casValues, t);
            if (casValues.size() != 1 || casValues.get(0) == null) {
                throw new CasVersionNotMatchException("casVersion column value is null");
            }
            values.add(casValues.get(0));
            where = where + " AND " + casWhere;
        }
        sql.append(SQLUtils.autoSetSoftDeleted(databaseType, where, t.getClass()));
        return sql.toString();
    }

    public static <T> String getSoftDeleteSQL(DatabaseTypeEnum databaseType, T t, com.pugwoo.dbhelper.annotation.Column softDeleteColumn, List<Object> values) {
        StringBuilder sql = new StringBuilder();
        sql.append("UPDATE ");
        sql.append(SQLUtils.getTableName(databaseType, t.getClass())).append(" SET ");
        sql.append(SQLUtils.getColumnName(databaseType, softDeleteColumn)).append("=").append(softDeleteColumn.softDelete()[1]);
        List<Field> fields = DOInfoReader.getColumns(t.getClass());
        for (Field field : fields) {
            Object value;
            String nowDateTime;
            com.pugwoo.dbhelper.annotation.Column column = field.getAnnotation(com.pugwoo.dbhelper.annotation.Column.class);
            if (column.setTimeWhenDelete() && (nowDateTime = PreHandleObject.getNowDateTime(field.getType())) != null) {
                sql.append(",").append(SQLUtils.getColumnName(databaseType, column)).append("='").append(nowDateTime).append("'");
            }
            if (!InnerCommonUtils.isNotBlank(column.deleteValueScript()) || (value = DOInfoReader.getValue(field, t)) == null) continue;
            sql.append(",").append(SQLUtils.getColumnName(databaseType, column)).append("=").append(TypeAutoCast.toSqlValueStr(value));
        }
        List<Field> keyFields = DOInfoReader.getKeyColumns(t.getClass());
        ArrayList<Object> whereValues = new ArrayList<Object>();
        String where = "WHERE " + SQLUtils.joinWhereAndGetValue(databaseType, keyFields, "AND", whereValues, t);
        for (Object e : whereValues) {
            if (e != null) continue;
            throw new NullKeyValueException();
        }
        values.addAll(whereValues);
        sql.append(SQLUtils.autoSetSoftDeleted(databaseType, where, t.getClass()));
        return sql.toString();
    }

    public static <T> String getCustomDeleteSQL(DatabaseTypeEnum databaseType, Class<T> clazz, String postSql) {
        return "DELETE FROM " + SQLUtils.getTableName(databaseType, clazz) + " " + postSql;
    }

    public static <T> String getCustomSoftDeleteSQL(DatabaseTypeEnum databaseType, Class<T> clazz, String postSql, Field softDelete) {
        List<Field> fields = DOInfoReader.getColumns(clazz);
        com.pugwoo.dbhelper.annotation.Column softDeleteColumn = softDelete.getAnnotation(com.pugwoo.dbhelper.annotation.Column.class);
        StringBuilder sql = new StringBuilder();
        sql.append("UPDATE ").append(SQLUtils.getTableName(databaseType, clazz));
        sql.append(" SET ").append(SQLUtils.getColumnName(databaseType, softDeleteColumn));
        sql.append("=").append(softDeleteColumn.softDelete()[1]);
        for (Field field : fields) {
            String nowDateTime;
            com.pugwoo.dbhelper.annotation.Column column = field.getAnnotation(com.pugwoo.dbhelper.annotation.Column.class);
            if (!column.setTimeWhenDelete() || (nowDateTime = PreHandleObject.getNowDateTime(field.getType())) == null) continue;
            sql.append(",").append(SQLUtils.getColumnName(databaseType, column)).append("='");
            sql.append(nowDateTime).append("'");
        }
        sql.append(SQLUtils.autoSetSoftDeleted(databaseType, postSql, clazz));
        return sql.toString();
    }

    public static <T> String getDeleteSQL(DatabaseTypeEnum databaseType, T t, List<Object> values) {
        List<Field> keyFields = DOInfoReader.getKeyColumns(t.getClass());
        StringBuilder sql = new StringBuilder();
        sql.append("DELETE FROM ");
        sql.append(SQLUtils.getTableName(databaseType, t.getClass()));
        ArrayList<Object> _values = new ArrayList<Object>();
        String where = "WHERE " + SQLUtils.joinWhereAndGetValue(databaseType, keyFields, "AND", _values, t);
        for (Object e : _values) {
            if (e != null) continue;
            throw new NullKeyValueException();
        }
        values.addAll(_values);
        sql.append(where);
        return sql.toString();
    }

    public static String getDeleteSqlByKeyField(DatabaseTypeEnum databaseType, Field keyField) {
        return "where " + SQLUtils.getColumnName(databaseType, keyField) + " in (?)";
    }

    public static String insertWhereAndExpression(DatabaseTypeEnum databaseType, String whereSql, String condExpression) throws JSQLParserException {
        if (InnerCommonUtils.isBlank(condExpression)) {
            return whereSql == null ? "" : whereSql;
        }
        if (InnerCommonUtils.isBlank(whereSql)) {
            return "WHERE " + condExpression;
        }
        if (!(whereSql = whereSql.trim()).toUpperCase().startsWith("WHERE ")) {
            return "WHERE " + condExpression + " " + whereSql;
        }
        String magic = "A" + UUID.randomUUID().toString().replace("-", "");
        String selectSql = "select * from dual ";
        Statement statement = CCJSqlParserUtil.parse((String)(selectSql + whereSql));
        Select selectStatement = (Select)statement;
        PlainSelect plainSelect = (PlainSelect)selectStatement.getSelectBody();
        Expression ce = CCJSqlParserUtil.parseCondExpression((String)magic);
        Expression oldWhere = plainSelect.getWhere();
        FixedAndExpression newWhere = new FixedAndExpression(oldWhere, ce);
        plainSelect.setWhere((Expression)newWhere);
        String result = plainSelect.toString().substring(selectSql.length());
        return result.replace(magic, condExpression);
    }

    public static String autoSetSoftDeleted(DatabaseTypeEnum databaseType, String whereSql, Class<?> clazz) {
        return SQLUtils.autoSetSoftDeleted(databaseType, whereSql, clazz, "");
    }

    private static String _getDefaultOrderBy(DatabaseTypeEnum databaseType, Class<?> clazz, String prefix) {
        List<Field> orderColumn = DOInfoReader.getKeyColumnsNoThrowsException(clazz);
        if (orderColumn.isEmpty()) {
            orderColumn = DOInfoReader.getColumns(clazz);
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < orderColumn.size(); ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(prefix).append(SQLUtils.getColumnName(databaseType, orderColumn.get(i)));
        }
        return sb.toString();
    }

    private static String getDefaultOrderBy(DatabaseTypeEnum databaseType, Class<?> clazz) {
        JoinTable joinTable = DOInfoReader.getJoinTable(clazz);
        if (joinTable == null) {
            return "ORDER BY " + SQLUtils._getDefaultOrderBy(databaseType, clazz, "");
        }
        Field leftTableField = DOInfoReader.getJoinLeftTable(clazz);
        Field rightTableField = DOInfoReader.getJoinRightTable(clazz);
        JoinLeftTable joinLeftTable = leftTableField.getAnnotation(JoinLeftTable.class);
        JoinRightTable joinRightTable = rightTableField.getAnnotation(JoinRightTable.class);
        String orderBy1 = SQLUtils._getDefaultOrderBy(databaseType, leftTableField.getType(), joinLeftTable.alias() + ".");
        String orderBy2 = SQLUtils._getDefaultOrderBy(databaseType, rightTableField.getType(), joinRightTable.alias() + ".");
        return "ORDER BY " + orderBy1 + "," + orderBy2;
    }

    private static List<OrderByElement> _getDefaultOrderByElement(DatabaseTypeEnum databaseType, Class<?> clazz, String prefix) {
        List<Field> orderColumn = DOInfoReader.getKeyColumnsNoThrowsException(clazz);
        if (orderColumn.isEmpty()) {
            orderColumn = DOInfoReader.getColumns(clazz);
        }
        ArrayList<OrderByElement> list = new ArrayList<OrderByElement>();
        for (Field field : orderColumn) {
            OrderByElement ele = new OrderByElement();
            com.pugwoo.dbhelper.annotation.Column column = field.getAnnotation(com.pugwoo.dbhelper.annotation.Column.class);
            if (InnerCommonUtils.isBlank(column.computed())) {
                ele.setExpression((Expression)new Column(prefix + SQLUtils.getColumnName(databaseType, field)));
            } else {
                ele.setExpression((Expression)new Column(SQLUtils.getColumnName(databaseType, field, prefix)));
            }
            list.add(ele);
        }
        return list;
    }

    private static List<OrderByElement> getDefaultOrderByElement(DatabaseTypeEnum databaseType, Class<?> clazz) {
        JoinTable joinTable = DOInfoReader.getJoinTable(clazz);
        if (joinTable == null) {
            return SQLUtils._getDefaultOrderByElement(databaseType, clazz, "");
        }
        Field leftTableField = DOInfoReader.getJoinLeftTable(clazz);
        Field rightTableField = DOInfoReader.getJoinRightTable(clazz);
        JoinLeftTable joinLeftTable = leftTableField.getAnnotation(JoinLeftTable.class);
        JoinRightTable joinRightTable = rightTableField.getAnnotation(JoinRightTable.class);
        ArrayList<OrderByElement> list = new ArrayList<OrderByElement>();
        list.addAll(SQLUtils._getDefaultOrderByElement(databaseType, leftTableField.getType(), joinLeftTable.alias() + "."));
        list.addAll(SQLUtils._getDefaultOrderByElement(databaseType, rightTableField.getType(), joinRightTable.alias() + "."));
        return list;
    }

    private static List<OrderByElement> getDefaultOrderByGroup(List<Expression> groupByList) {
        ArrayList<OrderByElement> list = new ArrayList<OrderByElement>();
        for (Expression expression : groupByList) {
            OrderByElement ele = new OrderByElement();
            ele.setExpression((Expression)new Column(expression.getASTNode().jjtGetValue().toString()));
            list.add(ele);
        }
        return list;
    }

    public static String removeLimitAndAddOrder(DatabaseTypeEnum databaseType, String whereSql, boolean autoAddOrderForPagination, Class<?> clazz) {
        Statement statement;
        if (InnerCommonUtils.isBlank(whereSql) && autoAddOrderForPagination) {
            return SQLUtils.getDefaultOrderBy(databaseType, clazz);
        }
        String selectSql = "SELECT * FROM dual ";
        try {
            statement = CCJSqlParserUtil.parse((String)(selectSql + whereSql));
        }
        catch (JSQLParserException e) {
            LOGGER.error("fail to parse sql:{}", (Object)whereSql, (Object)e);
            return whereSql;
        }
        boolean isChange = false;
        Select selectStatement = (Select)statement;
        PlainSelect plainSelect = (PlainSelect)selectStatement.getSelectBody();
        Limit limit = plainSelect.getLimit();
        if (limit != null) {
            plainSelect.setLimit(null);
            isChange = true;
        }
        if (autoAddOrderForPagination) {
            List groupByList;
            List orderBy = plainSelect.getOrderByElements();
            GroupByElement groupBy = plainSelect.getGroupBy();
            ExpressionList groupBys = groupBy == null ? null : groupBy.getGroupByExpressionList();
            List list = groupByList = groupBys == null ? null : groupBys.getExpressions();
            if (orderBy == null || orderBy.isEmpty()) {
                if (groupByList == null || groupByList.isEmpty()) {
                    plainSelect.setOrderByElements(SQLUtils.getDefaultOrderByElement(databaseType, clazz));
                } else {
                    plainSelect.setOrderByElements(SQLUtils.getDefaultOrderByGroup(groupByList));
                }
                isChange = true;
            } else if (groupByList != null) {
                for (Expression groupName : groupByList) {
                    String name = groupName.getASTNode().jjtGetValue().toString();
                    boolean isFound = false;
                    for (OrderByElement order : orderBy) {
                        if (!order.getExpression().getASTNode().getClass().toString().equals(name)) continue;
                        isFound = true;
                        break;
                    }
                    if (isFound) continue;
                    LOGGER.warn("class:{} postSql:[{}], group by field:{} not in order by list, it may cause unstable pagination result.", new Object[]{clazz, whereSql, name});
                }
            }
        }
        if (isChange) {
            String sql = plainSelect.toString();
            if (sql.startsWith(selectSql)) {
                return sql.substring(selectSql.length());
            }
            LOGGER.error("fail to remove limit and handle order by for sql:{}", (Object)whereSql);
            return whereSql;
        }
        return whereSql;
    }

    public static String autoSetSoftDeleted(DatabaseTypeEnum databaseType, String whereSql, Class<?> clazz, String extraWhere) {
        if (whereSql == null) {
            whereSql = "";
        }
        String string = extraWhere = extraWhere == null ? "" : extraWhere;
        if (InnerCommonUtils.isNotBlank(extraWhere)) {
            extraWhere = "(" + extraWhere + ")";
        }
        String deletedExpression = "";
        JoinTable joinTable = DOInfoReader.getJoinTable(clazz);
        if (joinTable != null) {
            String columnName;
            com.pugwoo.dbhelper.annotation.Column softDeleteColumn;
            Field leftTableField = DOInfoReader.getJoinLeftTable(clazz);
            Field rightTableField = DOInfoReader.getJoinRightTable(clazz);
            JoinLeftTable joinLeftTable = leftTableField.getAnnotation(JoinLeftTable.class);
            JoinRightTable joinRightTable = rightTableField.getAnnotation(JoinRightTable.class);
            Field softDeleteT1 = DOInfoReader.getSoftDeleteColumn(leftTableField.getType());
            Field softDeleteT2 = DOInfoReader.getSoftDeleteColumn(rightTableField.getType());
            if (softDeleteT1 == null && softDeleteT2 == null) {
                try {
                    return " " + SQLUtils.insertWhereAndExpression(databaseType, whereSql, extraWhere);
                }
                catch (JSQLParserException e) {
                    LOGGER.error("Bad sql syntax,whereSql:{},deletedExpression:{}", new Object[]{whereSql, deletedExpression, e});
                    throw new BadSQLSyntaxException(e);
                }
            }
            StringBuilder deletedExpressionSb = new StringBuilder();
            if (softDeleteT1 != null) {
                softDeleteColumn = softDeleteT1.getAnnotation(com.pugwoo.dbhelper.annotation.Column.class);
                columnName = SQLUtils.getColumnName(databaseType, softDeleteColumn);
                if (joinTable.joinType() == JoinTypeEnum.RIGHT_JOIN) {
                    deletedExpressionSb.append("(").append(joinLeftTable.alias()).append(".").append(columnName).append("=").append(softDeleteColumn.softDelete()[0]).append(" or ").append(joinLeftTable.alias()).append(".").append(columnName).append(" is null)");
                } else {
                    deletedExpressionSb.append(joinLeftTable.alias()).append(".").append(columnName).append("=").append(softDeleteColumn.softDelete()[0]);
                }
            }
            if (softDeleteT2 != null) {
                if (softDeleteT1 != null) {
                    deletedExpressionSb.append(" AND ");
                }
                softDeleteColumn = softDeleteT2.getAnnotation(com.pugwoo.dbhelper.annotation.Column.class);
                columnName = SQLUtils.getColumnName(databaseType, softDeleteColumn);
                if (joinTable.joinType() == JoinTypeEnum.LEFT_JOIN) {
                    deletedExpressionSb.append("(").append(joinRightTable.alias()).append(".").append(columnName).append("=").append(softDeleteColumn.softDelete()[0]).append(" or ").append(joinRightTable.alias()).append(".").append(columnName).append(" is null)");
                } else {
                    deletedExpressionSb.append(joinRightTable.alias()).append(".").append(columnName).append("=").append(softDeleteColumn.softDelete()[0]);
                }
            }
            deletedExpression = deletedExpressionSb.toString();
        } else {
            Field softDelete = DOInfoReader.getSoftDeleteColumn(clazz);
            if (softDelete == null) {
                try {
                    return " " + SQLUtils.insertWhereAndExpression(databaseType, whereSql, extraWhere);
                }
                catch (JSQLParserException e) {
                    LOGGER.error("Bad sql syntax,whereSql:{},deletedExpression:{}", new Object[]{whereSql, deletedExpression, e});
                    throw new BadSQLSyntaxException(e);
                }
            }
            com.pugwoo.dbhelper.annotation.Column softDeleteColumn = softDelete.getAnnotation(com.pugwoo.dbhelper.annotation.Column.class);
            deletedExpression = SQLUtils.getColumnName(databaseType, softDeleteColumn) + "=" + softDeleteColumn.softDelete()[0];
        }
        try {
            if (!extraWhere.isEmpty()) {
                deletedExpression = "(" + deletedExpression + " and " + extraWhere + ")";
            }
            return " " + SQLUtils.insertWhereAndExpression(databaseType, whereSql, deletedExpression);
        }
        catch (JSQLParserException e) {
            LOGGER.error("Bad sql syntax,whereSql:{},deletedExpression:{}", new Object[]{whereSql, deletedExpression, e});
            throw new BadSQLSyntaxException(e);
        }
    }

    public static String genLimitSQL(DatabaseTypeEnum databaseType, Integer offset, Integer limit) {
        StringBuilder sb = new StringBuilder();
        if (limit != null) {
            sb.append(" LIMIT ");
            sb.append(limit);
            if (offset != null) {
                sb.append(" OFFSET ").append(offset);
            }
        }
        return sb.toString();
    }

    public static String getComputedColumn(DatabaseTypeEnum databaseType, com.pugwoo.dbhelper.annotation.Column column, Map<FeatureEnum, Boolean> features) {
        String computedLower;
        String computed = column.computed();
        Boolean autoSumNullToZero = features.get((Object)FeatureEnum.AUTO_SUM_NULL_TO_ZERO);
        if (autoSumNullToZero != null && autoSumNullToZero.booleanValue() && (computedLower = computed.toLowerCase().trim()).startsWith("sum(") && computedLower.endsWith(")")) {
            computed = "COALESCE(" + computed + ",0)";
        }
        return computed;
    }

    public static boolean isContainsLimit(String postSql) throws JSQLParserException {
        Boolean result = containsLimitCache.get(postSql);
        if (result != null) {
            return result;
        }
        String selectSql = "select * from dual ";
        Statement statement = CCJSqlParserUtil.parse((String)(selectSql + postSql));
        Select selectStatement = (Select)statement;
        PlainSelect plainSelect = (PlainSelect)selectStatement.getSelectBody();
        Limit limit = plainSelect.getLimit();
        boolean isContainsLimit = limit != null;
        containsLimitCache.put(postSql, isContainsLimit);
        return isContainsLimit;
    }

    private static String joinColumnForSelect(DatabaseTypeEnum databaseType, List<Field> fields, String fieldPrefix, Map<FeatureEnum, Boolean> features) {
        String sep = ",";
        fieldPrefix = fieldPrefix == null ? "" : fieldPrefix.trim();
        StringBuilder sb = new StringBuilder();
        for (Field field : fields) {
            com.pugwoo.dbhelper.annotation.Column column = field.getAnnotation(com.pugwoo.dbhelper.annotation.Column.class);
            if (InnerCommonUtils.isNotBlank(column.computed())) {
                sb.append("(").append(SQLUtils.getComputedColumn(databaseType, column, features)).append(") AS ").append(SQLUtils.getColumnName(databaseType, column, fieldPrefix)).append(sep);
                continue;
            }
            sb.append(fieldPrefix).append(SQLUtils.getColumnName(databaseType, column)).append(" AS \"").append(fieldPrefix).append(column.value()).append("\"").append(sep);
        }
        int len = sb.length();
        return len == 0 ? "" : sb.substring(0, len - 1);
    }

    private static String joinWhereAndGetValue(DatabaseTypeEnum databaseType, List<Field> fields, String logicOperate, List<Object> values, Object obj) {
        StringBuilder sb = new StringBuilder();
        int fieldSize = fields.size();
        for (int i = 0; i < fieldSize; ++i) {
            Object val;
            com.pugwoo.dbhelper.annotation.Column column = fields.get(i).getAnnotation(com.pugwoo.dbhelper.annotation.Column.class);
            sb.append(SQLUtils.getColumnName(databaseType, column)).append("=?");
            if (i < fieldSize - 1) {
                sb.append(" ").append(logicOperate).append(" ");
            }
            if ((val = DOInfoReader.getValue(fields.get(i), obj)) != null && column.isJSON()) {
                val = NimbleOrmJSON.toJson(val);
            }
            if (val != null && databaseType == DatabaseTypeEnum.CLICKHOUSE && fields.get(i).getType().equals(byte[].class) && val instanceof byte[]) {
                val = InnerCommonUtils.encodeBase64((byte[])val);
            }
            values.add(val);
        }
        return sb.toString();
    }

    private static String joinWhere(DatabaseTypeEnum databaseType, List<Field> fields, String logicOperate) {
        StringBuilder sb = new StringBuilder();
        int fieldSize = fields.size();
        for (int i = 0; i < fieldSize; ++i) {
            com.pugwoo.dbhelper.annotation.Column column = fields.get(i).getAnnotation(com.pugwoo.dbhelper.annotation.Column.class);
            sb.append(SQLUtils.getColumnName(databaseType, column)).append("=?");
            if (i >= fieldSize - 1) continue;
            sb.append(" ").append(logicOperate).append(" ");
        }
        return sb.toString();
    }

    private static void appendInsertColumnSql(DatabaseTypeEnum databaseType, StringBuilder sb, List<Field> fields) {
        sb.append("(");
        if (fields != null) {
            for (int i = 0; i < fields.size(); ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                Field field = fields.get(i);
                com.pugwoo.dbhelper.annotation.Column column = field.getAnnotation(com.pugwoo.dbhelper.annotation.Column.class);
                SQLUtils.appendColumnName(databaseType, sb, column.value());
            }
        }
        sb.append(")");
    }

    private static String joinAndGetValueForInsert(DatabaseTypeEnum databaseType, List<Field> fields, String sep, List<Object> values, Object obj, boolean isWithNullValue) {
        if (values == null || obj == null) {
            throw new InvalidParameterException("joinAndGetValueForInsert require values and obj");
        }
        StringBuilder sb = new StringBuilder();
        for (Field field : fields) {
            com.pugwoo.dbhelper.annotation.Column column = field.getAnnotation(com.pugwoo.dbhelper.annotation.Column.class);
            if (InnerCommonUtils.isNotBlank(column.computed())) continue;
            Object value = DOInfoReader.getValue(field, obj);
            if (value != null && column.isJSON()) {
                value = NimbleOrmJSON.toJson(value);
            }
            if (value != null && databaseType == DatabaseTypeEnum.CLICKHOUSE && field.getType().equals(byte[].class) && value instanceof byte[]) {
                value = InnerCommonUtils.encodeBase64((byte[])value);
            }
            if (isWithNullValue) {
                if (field.getAnnotation(com.pugwoo.dbhelper.annotation.Column.class).isKey() && value == null) continue;
                values.add(value);
            } else {
                if (value == null) continue;
                values.add(value);
            }
            sb.append(SQLUtils.getColumnName(databaseType, column)).append(sep);
        }
        int len = sb.length();
        return len == 0 ? "" : sb.substring(0, len - 1);
    }

    private static String join(String str, int times, String sep) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < times; ++i) {
            sb.append(str);
            if (i >= times - 1) continue;
            sb.append(sep);
        }
        return sb.toString();
    }

    private static String joinSetAndGetValue(DatabaseTypeEnum databaseType, List<Field> fields, List<Object> values, Object obj, boolean withNull) {
        StringBuilder sb = new StringBuilder();
        for (Field field : fields) {
            com.pugwoo.dbhelper.annotation.Column column = field.getAnnotation(com.pugwoo.dbhelper.annotation.Column.class);
            Object value = DOInfoReader.getValue(field, obj);
            if (column.casVersion()) {
                long _v;
                if (value == null) {
                    throw new CasVersionNotMatchException("casVersion column value is null");
                }
                if (value instanceof Long) {
                    _v = (Long)value;
                } else if (value instanceof Integer) {
                    _v = ((Integer)value).longValue();
                } else {
                    throw new CasVersionNotMatchException("casVersion column type must be Integer or Long");
                }
                sb.append(SQLUtils.getColumnName(databaseType, column)).append("=").append(_v + 1L).append(",");
                continue;
            }
            if (value != null && column.isJSON()) {
                value = NimbleOrmJSON.toJson(value);
            }
            if (value != null && databaseType == DatabaseTypeEnum.CLICKHOUSE && field.getType().equals(byte[].class) && value instanceof byte[]) {
                value = InnerCommonUtils.encodeBase64((byte[])value);
            }
            if (!withNull && value == null) continue;
            sb.append(SQLUtils.getColumnName(databaseType, column)).append("=?,");
            values.add(value);
        }
        return sb.length() == 0 ? "" : sb.substring(0, sb.length() - 1);
    }

    private static String getEscapeChar(DatabaseTypeEnum databaseType) {
        return databaseType == DatabaseTypeEnum.POSTGRESQL ? "\"" : "`";
    }

    private static String getTableName(DatabaseTypeEnum databaseType, Class<?> clazz) {
        String tableName = DBHelperContext.getTableName(clazz);
        if (InnerCommonUtils.isBlank(tableName)) {
            tableName = DOInfoReader.getTable(clazz).value();
        }
        String escape = SQLUtils.getEscapeChar(databaseType);
        return escape + tableName + escape;
    }

    private static String getTableName(DatabaseTypeEnum databaseType, String tableName) {
        String escape = SQLUtils.getEscapeChar(databaseType);
        return escape + tableName + escape;
    }

    private static void appendTableName(DatabaseTypeEnum databaseType, StringBuilder sb, Class<?> clazz) {
        String tableName = DBHelperContext.getTableName(clazz);
        if (InnerCommonUtils.isBlank(tableName)) {
            tableName = DOInfoReader.getTable(clazz).value();
        }
        String escape = SQLUtils.getEscapeChar(databaseType);
        sb.append(escape).append(tableName).append(escape);
    }

    private static String getColumnName(DatabaseTypeEnum databaseType, com.pugwoo.dbhelper.annotation.Column column, String prefix) {
        return SQLUtils.getColumnName(databaseType, column.value(), prefix);
    }

    private static String getColumnName(DatabaseTypeEnum databaseType, com.pugwoo.dbhelper.annotation.Column column) {
        return SQLUtils.getColumnName(databaseType, column.value());
    }

    private static String getColumnName(DatabaseTypeEnum databaseType, Field field) {
        return SQLUtils.getColumnName(databaseType, field.getAnnotation(com.pugwoo.dbhelper.annotation.Column.class));
    }

    private static String getColumnName(DatabaseTypeEnum databaseType, Field field, String prefix) {
        return SQLUtils.getColumnName(databaseType, field.getAnnotation(com.pugwoo.dbhelper.annotation.Column.class), prefix);
    }

    public static String getColumnName(DatabaseTypeEnum databaseType, String columnName) {
        String escape = SQLUtils.getEscapeChar(databaseType);
        return escape + columnName + escape;
    }

    private static String getColumnName(DatabaseTypeEnum databaseType, String columnName, String prefix) {
        String escape = SQLUtils.getEscapeChar(databaseType);
        return escape + prefix + columnName + escape;
    }

    private static void appendColumnName(DatabaseTypeEnum databaseType, StringBuilder sb, String columnName) {
        String escape = SQLUtils.getEscapeChar(databaseType);
        sb.append(escape).append(columnName).append(escape);
    }

    public static class BatchUpdateResultDTO {
        private String sql;
        private String logSql;
        private List<Object> logParams;

        public String getSql() {
            return this.sql;
        }

        public void setSql(String sql) {
            this.sql = sql;
        }

        public String getLogSql() {
            return this.logSql;
        }

        public void setLogSql(String logSql) {
            this.logSql = logSql;
        }

        public List<Object> getLogParams() {
            return this.logParams;
        }

        public void setLogParams(List<Object> logParams) {
            this.logParams = logParams;
        }
    }
}

