/*
 * Decompiled with CFR 0.152.
 */
package com.pugwoo.dbhelper.sql;

import com.pugwoo.dbhelper.exception.BadSQLSyntaxException;
import com.pugwoo.dbhelper.json.NimbleOrmJSON;
import com.pugwoo.dbhelper.utils.InnerCommonUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WhereSQL {
    private static final Logger LOGGER = LoggerFactory.getLogger(WhereSQL.class);
    private String condition;
    private boolean isOrExpression;
    private List<Object> params;
    private List<String> groupBy;
    private List<Object> groupByParams;
    private String having;
    private List<Object> havingByParams;
    private List<String> orderBy;
    private List<Object> orderByParams;
    private Long offset;
    private Long limit;

    public WhereSQL() {
    }

    public WhereSQL copy() {
        WhereSQL whereSQL = new WhereSQL();
        whereSQL.condition = this.condition;
        whereSQL.isOrExpression = this.isOrExpression;
        whereSQL.params = this.params == null ? null : new ArrayList<Object>(this.params);
        whereSQL.groupBy = this.groupBy == null ? null : new ArrayList<String>(this.groupBy);
        whereSQL.groupByParams = this.groupByParams == null ? null : new ArrayList<Object>(this.groupByParams);
        whereSQL.having = this.having;
        whereSQL.havingByParams = this.havingByParams == null ? null : new ArrayList<Object>(this.havingByParams);
        whereSQL.orderBy = this.orderBy == null ? null : new ArrayList<String>(this.orderBy);
        whereSQL.orderByParams = this.orderByParams == null ? null : new ArrayList<Object>(this.orderByParams);
        whereSQL.offset = this.offset;
        whereSQL.limit = this.limit;
        return whereSQL;
    }

    public WhereSQL(String condition, Object ... param) {
        if (InnerCommonUtils.isNotBlank(condition)) {
            this.isOrExpression = this.isOrExpression(condition);
            this.condition = condition;
        }
        this.doAddParam(param);
    }

    public String getSQL() {
        StringBuilder sql = new StringBuilder();
        if (InnerCommonUtils.isNotBlank(this.condition)) {
            sql.append(" WHERE ").append(this.condition);
        }
        this.getSQLLeft(sql);
        return sql.toString();
    }

    public String toString() {
        return this.getSQL();
    }

    public String getSQLForWhereAppend() {
        StringBuilder sql = new StringBuilder();
        if (InnerCommonUtils.isNotBlank(this.condition)) {
            sql.append(" AND ");
            if (this.isOrExpression) {
                sql.append("(");
            }
            sql.append(this.condition);
            if (this.isOrExpression) {
                sql.append(")");
            }
        }
        this.getSQLLeft(sql);
        return sql.toString();
    }

    private void getSQLLeft(StringBuilder sql) {
        if (InnerCommonUtils.isNotEmpty(this.groupBy)) {
            sql.append(" GROUP BY ").append(String.join((CharSequence)",", this.groupBy));
        }
        if (InnerCommonUtils.isNotBlank(this.having)) {
            sql.append(" HAVING ").append(this.having);
        }
        if (InnerCommonUtils.isNotEmpty(this.orderBy)) {
            sql.append(" ORDER BY ").append(String.join((CharSequence)",", this.orderBy));
        }
        if (this.limit != null) {
            sql.append(" LIMIT ");
            sql.append(this.limit);
            if (this.offset != null) {
                sql.append(" OFFSET ").append(this.offset);
            }
        }
        sql.append(" ");
    }

    public Object[] getParams() {
        ArrayList<Object> result = new ArrayList<Object>();
        if (this.params != null) {
            result.addAll(this.params);
        }
        if (this.groupByParams != null) {
            result.addAll(this.groupByParams);
        }
        if (this.havingByParams != null) {
            result.addAll(this.havingByParams);
        }
        if (this.orderByParams != null) {
            result.addAll(this.orderByParams);
        }
        return result.toArray();
    }

    public WhereSQL not() {
        if (InnerCommonUtils.isBlank(this.condition)) {
            return this;
        }
        this.condition = "NOT " + (this.isAndOrExpression(this.condition) ? "(" + this.condition + ")" : this.condition);
        this.isOrExpression = false;
        return this;
    }

    public WhereSQL notIf(boolean ifTrue) {
        if (ifTrue) {
            this.not();
        }
        return this;
    }

    public WhereSQL and(String condition, Object ... param) {
        if (InnerCommonUtils.isNotBlank(condition)) {
            boolean isOrExpression = this.isOrExpression(condition);
            String string = condition = isOrExpression ? "(" + condition + ")" : condition;
            if (this.isOrExpression) {
                this.condition = "(" + this.condition + ") AND " + condition;
                this.isOrExpression = false;
            } else if (InnerCommonUtils.isBlank(this.condition)) {
                this.condition = condition;
                this.isOrExpression = isOrExpression;
            } else {
                this.condition = this.condition + " AND " + condition;
                this.isOrExpression = false;
            }
        }
        this.doAddParam(param);
        return this;
    }

    public WhereSQL andIf(boolean ifTrue, String condition, Object ... param) {
        if (ifTrue) {
            this.and(condition, param);
        }
        return this;
    }

    public WhereSQL and(WhereSQL whereSQL) {
        if (whereSQL.isNotOnlyHasCondition()) {
            LOGGER.warn("whereSQL has other properties which will be ignored:{}", (Object)NimbleOrmJSON.toJson(whereSQL));
        }
        return this.and(whereSQL.condition, whereSQL.params == null ? new Object[]{} : whereSQL.params.toArray());
    }

    public WhereSQL andIf(boolean ifTrue, WhereSQL whereSQL) {
        if (ifTrue) {
            this.and(whereSQL);
        }
        return this;
    }

    public WhereSQL or(String condition, Object ... param) {
        if (InnerCommonUtils.isNotBlank(condition)) {
            this.condition = (this.condition == null ? "" : this.condition + " OR ") + condition;
            this.isOrExpression = true;
        }
        this.doAddParam(param);
        return this;
    }

    public WhereSQL orIf(boolean ifTrue, String condition, Object ... param) {
        if (ifTrue) {
            this.or(condition, param);
        }
        return this;
    }

    public WhereSQL or(WhereSQL whereSQL) {
        if (whereSQL.isNotOnlyHasCondition()) {
            LOGGER.warn("whereSQL has other properties which will be ignored:{}", (Object)NimbleOrmJSON.toJson(whereSQL));
        }
        return this.or(whereSQL.condition, whereSQL.params == null ? new Object[]{} : whereSQL.params.toArray());
    }

    public WhereSQL orIf(boolean ifTrue, WhereSQL whereSQL) {
        if (ifTrue) {
            this.or(whereSQL);
        }
        return this;
    }

    public WhereSQL addGroupByWithParam(String groupColumn, Object ... params) {
        if (InnerCommonUtils.isNotBlank(groupColumn)) {
            if (this.groupBy == null) {
                this.groupBy = new ArrayList<String>();
            }
            this.groupBy.add(groupColumn);
        }
        if (params != null && params.length > 0) {
            if (this.groupByParams == null) {
                this.groupByParams = new ArrayList<Object>();
            }
            this.groupByParams.addAll(Arrays.asList(params));
        }
        return this;
    }

    public WhereSQL addGroupBy(String ... groupByColumn) {
        if (groupByColumn != null && groupByColumn.length > 0) {
            if (this.groupBy == null) {
                this.groupBy = new ArrayList<String>();
            }
            for (String groupBy : groupByColumn) {
                if (!InnerCommonUtils.isNotBlank(groupBy)) continue;
                this.groupBy.add(groupBy);
            }
        }
        return this;
    }

    public WhereSQL resetGroupBy() {
        this.groupBy = null;
        this.groupByParams = null;
        return this;
    }

    public WhereSQL having(String having, Object ... params) {
        if (InnerCommonUtils.isNotBlank(this.having) || InnerCommonUtils.isNotEmpty(this.havingByParams)) {
            LOGGER.warn("having sql [{}] will be covered by [{}]", (Object)this.having, (Object)having);
        }
        this.having = having;
        this.havingByParams = params != null && params.length > 0 ? new ArrayList<Object>(Arrays.asList(params)) : null;
        return this;
    }

    public WhereSQL addOrderByWithParam(String orderColumn, Object ... params) {
        if (InnerCommonUtils.isNotBlank(orderColumn)) {
            if (this.orderBy == null) {
                this.orderBy = new ArrayList<String>();
            }
            this.orderBy.add(orderColumn);
        }
        if (params != null && params.length > 0) {
            if (this.orderByParams == null) {
                this.orderByParams = new ArrayList<Object>();
            }
            this.orderByParams.addAll(Arrays.asList(params));
        }
        return this;
    }

    public WhereSQL addOrderBy(String ... orderByColumn) {
        if (orderByColumn != null && orderByColumn.length > 0) {
            if (this.orderBy == null) {
                this.orderBy = new ArrayList<String>();
            }
            for (String orderBy : orderByColumn) {
                if (!InnerCommonUtils.isNotBlank(orderBy)) continue;
                this.orderBy.add(orderBy);
            }
        }
        return this;
    }

    public WhereSQL resetOrderBy() {
        this.orderBy = null;
        this.orderByParams = null;
        return this;
    }

    public WhereSQL limit(Integer limit) {
        if (limit != null) {
            this.limit = (long)limit;
        }
        this.offset = null;
        return this;
    }

    public WhereSQL limit(Integer offset, Integer limit) {
        if (limit != null) {
            this.limit = (long)limit;
        }
        if (offset != null) {
            this.offset = (long)offset;
        }
        return this;
    }

    public WhereSQL limit(Long limit) {
        this.limit = limit;
        this.offset = null;
        return this;
    }

    public WhereSQL limit(Long offset, Long limit) {
        this.limit = limit;
        this.offset = offset;
        return this;
    }

    private void doAddParam(Object[] param) {
        if (param != null && param.length > 0) {
            if (this.params == null) {
                this.params = new ArrayList<Object>();
            }
            this.params.addAll(Arrays.asList(param));
        }
    }

    private boolean isOrExpression(String condition) {
        Expression expression;
        try {
            expression = CCJSqlParserUtil.parseCondExpression((String)condition);
        }
        catch (JSQLParserException e) {
            LOGGER.error("parse condition:{} exception", (Object)condition, (Object)e);
            throw new BadSQLSyntaxException(e);
        }
        return expression instanceof OrExpression;
    }

    private boolean isAndOrExpression(String condition) {
        Expression expression;
        try {
            expression = CCJSqlParserUtil.parseCondExpression((String)condition);
        }
        catch (JSQLParserException e) {
            LOGGER.error("parse condition:{} exception", (Object)condition, (Object)e);
            throw new BadSQLSyntaxException(e);
        }
        return expression instanceof OrExpression || expression instanceof AndExpression;
    }

    private boolean isNotOnlyHasCondition() {
        return InnerCommonUtils.isNotEmpty(this.groupBy) || InnerCommonUtils.isNotEmpty(this.groupByParams) || InnerCommonUtils.isNotBlank(this.having) || InnerCommonUtils.isNotEmpty(this.havingByParams) || InnerCommonUtils.isNotEmpty(this.orderBy) || InnerCommonUtils.isNotEmpty(this.orderByParams) || this.offset != null || this.limit != null;
    }
}

