/*
 * Decompiled with CFR 0.152.
 */
package com.pugwoo.dbhelper.sql;

import com.pugwoo.dbhelper.exception.BadSQLSyntaxException;
import com.pugwoo.dbhelper.json.NimbleOrmJSON;
import com.pugwoo.dbhelper.utils.InnerCommonUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WhereSQLForNamedParam {
    private static final Logger LOGGER = LoggerFactory.getLogger(WhereSQLForNamedParam.class);
    private Map<String, Object> paramMap = new HashMap<String, Object>();
    private String condition;
    private boolean isOrExpression;
    private List<String> groupBy;
    private String having;
    private List<String> orderBy;
    private Long offset;
    private Long limit;

    public WhereSQLForNamedParam() {
    }

    public WhereSQLForNamedParam copy() {
        WhereSQLForNamedParam whereSQL = new WhereSQLForNamedParam();
        whereSQL.condition = this.condition;
        whereSQL.isOrExpression = this.isOrExpression;
        whereSQL.paramMap = this.paramMap == null ? null : new HashMap<String, Object>(this.paramMap);
        whereSQL.groupBy = this.groupBy == null ? null : new ArrayList<String>(this.groupBy);
        whereSQL.having = this.having;
        whereSQL.orderBy = this.orderBy == null ? null : new ArrayList<String>(this.orderBy);
        whereSQL.offset = this.offset;
        whereSQL.limit = this.limit;
        return whereSQL;
    }

    public WhereSQLForNamedParam(String condition) {
        if (InnerCommonUtils.isNotBlank(condition)) {
            this.isOrExpression = this.isOrExpression(condition);
            this.condition = condition;
        }
    }

    public WhereSQLForNamedParam(String condition, Map<String, ?> paramMap) {
        if (InnerCommonUtils.isNotBlank(condition)) {
            this.isOrExpression = this.isOrExpression(condition);
            this.condition = condition;
        }
        this.doAddParam(paramMap);
    }

    public String getSQL() {
        StringBuilder sql = new StringBuilder();
        if (InnerCommonUtils.isNotBlank(this.condition)) {
            sql.append(" WHERE ").append(this.condition);
        }
        this.getSQLLeft(sql);
        return sql.toString();
    }

    public String toString() {
        return this.getSQL();
    }

    public String getSQLForWhereAppend() {
        StringBuilder sql = new StringBuilder();
        if (InnerCommonUtils.isNotBlank(this.condition)) {
            sql.append(" AND ");
            if (this.isOrExpression) {
                sql.append("(");
            }
            sql.append(this.condition);
            if (this.isOrExpression) {
                sql.append(")");
            }
        }
        this.getSQLLeft(sql);
        return sql.toString();
    }

    private void getSQLLeft(StringBuilder sql) {
        if (InnerCommonUtils.isNotEmpty(this.groupBy)) {
            sql.append(" GROUP BY ").append(String.join((CharSequence)",", this.groupBy));
        }
        if (InnerCommonUtils.isNotBlank(this.having)) {
            sql.append(" HAVING ").append(this.having);
        }
        if (InnerCommonUtils.isNotEmpty(this.orderBy)) {
            sql.append(" ORDER BY ").append(String.join((CharSequence)",", this.orderBy));
        }
        if (this.limit != null) {
            sql.append(" LIMIT ");
            sql.append(this.limit);
            if (this.offset != null) {
                sql.append(" OFFSET ").append(this.offset);
            }
        }
        sql.append(" ");
    }

    public Map<String, Object> getParams() {
        return this.paramMap == null ? new HashMap() : this.paramMap;
    }

    public WhereSQLForNamedParam not() {
        if (InnerCommonUtils.isBlank(this.condition)) {
            return this;
        }
        this.condition = "NOT " + (this.isAndOrExpression(this.condition) ? "(" + this.condition + ")" : this.condition);
        this.isOrExpression = false;
        return this;
    }

    public WhereSQLForNamedParam notIf(boolean ifTrue) {
        if (ifTrue) {
            this.not();
        }
        return this;
    }

    public WhereSQLForNamedParam and(String condition) {
        return this.and(condition, null);
    }

    public WhereSQLForNamedParam andIf(boolean ifTrue, String condition) {
        if (ifTrue) {
            this.and(condition);
        }
        return this;
    }

    public WhereSQLForNamedParam and(String condition, Map<String, ?> param) {
        if (InnerCommonUtils.isNotBlank(condition)) {
            boolean isOrExpression = this.isOrExpression(condition);
            String string = condition = isOrExpression ? "(" + condition + ")" : condition;
            if (this.isOrExpression) {
                this.condition = "(" + this.condition + ") AND " + condition;
                this.isOrExpression = false;
            } else if (InnerCommonUtils.isBlank(this.condition)) {
                this.condition = condition;
                this.isOrExpression = isOrExpression;
            } else {
                this.condition = this.condition + " AND " + condition;
                this.isOrExpression = false;
            }
        }
        this.doAddParam(param);
        return this;
    }

    public WhereSQLForNamedParam andIf(boolean ifTrue, String condition, Map<String, ?> param) {
        if (ifTrue) {
            this.and(condition, param);
        }
        return this;
    }

    public WhereSQLForNamedParam and(WhereSQLForNamedParam whereSQL) {
        if (whereSQL.isNotOnlyHasCondition()) {
            LOGGER.warn("whereSQL has other properties which will be ignored:{}", (Object)NimbleOrmJSON.toJson(whereSQL));
        }
        return this.and(whereSQL.condition, whereSQL.paramMap);
    }

    public WhereSQLForNamedParam andIf(boolean ifTrue, WhereSQLForNamedParam whereSQL) {
        if (ifTrue) {
            this.and(whereSQL);
        }
        return this;
    }

    public WhereSQLForNamedParam or(String condition, Map<String, ?> param) {
        if (InnerCommonUtils.isNotBlank(condition)) {
            this.condition = (this.condition == null ? "" : this.condition + " OR ") + condition;
            this.isOrExpression = true;
        }
        this.doAddParam(param);
        return this;
    }

    public WhereSQLForNamedParam orIf(boolean ifTrue, String condition, Map<String, ?> param) {
        if (ifTrue) {
            this.or(condition, param);
        }
        return this;
    }

    public WhereSQLForNamedParam or(WhereSQLForNamedParam whereSQL) {
        if (whereSQL.isNotOnlyHasCondition()) {
            LOGGER.warn("whereSQL has other properties which will be ignored:{}", (Object)NimbleOrmJSON.toJson(whereSQL));
        }
        return this.or(whereSQL.condition, whereSQL.paramMap);
    }

    public WhereSQLForNamedParam orIf(boolean ifTrue, WhereSQLForNamedParam whereSQL) {
        if (ifTrue) {
            this.or(whereSQL);
        }
        return this;
    }

    public WhereSQLForNamedParam addGroupByWithParam(String groupColumn, Map<String, ?> paramMap) {
        if (InnerCommonUtils.isNotBlank(groupColumn)) {
            if (this.groupBy == null) {
                this.groupBy = new ArrayList<String>();
            }
            this.groupBy.add(groupColumn);
        }
        this.doAddParam(paramMap);
        return this;
    }

    public WhereSQLForNamedParam addGroupBy(String ... groupByColumn) {
        if (groupByColumn != null && groupByColumn.length > 0) {
            if (this.groupBy == null) {
                this.groupBy = new ArrayList<String>();
            }
            for (String groupBy : groupByColumn) {
                if (!InnerCommonUtils.isNotBlank(groupBy)) continue;
                this.groupBy.add(groupBy);
            }
        }
        return this;
    }

    public WhereSQLForNamedParam resetGroupBy() {
        this.groupBy = null;
        return this;
    }

    public WhereSQLForNamedParam having(String having) {
        return this.having(having, null);
    }

    public WhereSQLForNamedParam having(String having, Map<String, ?> paramMap) {
        if (InnerCommonUtils.isNotBlank(this.having)) {
            LOGGER.warn("having sql [{}] will be covered by [{}]", (Object)this.having, (Object)having);
        }
        this.having = having;
        this.doAddParam(paramMap);
        return this;
    }

    public WhereSQLForNamedParam addOrderByWithParam(String orderColumn, Map<String, ?> paramMap) {
        if (InnerCommonUtils.isNotBlank(orderColumn)) {
            if (this.orderBy == null) {
                this.orderBy = new ArrayList<String>();
            }
            this.orderBy.add(orderColumn);
        }
        this.doAddParam(paramMap);
        return this;
    }

    public WhereSQLForNamedParam addOrderBy(String ... orderByColumn) {
        if (orderByColumn != null && orderByColumn.length > 0) {
            if (this.orderBy == null) {
                this.orderBy = new ArrayList<String>();
            }
            for (String orderBy : orderByColumn) {
                if (!InnerCommonUtils.isNotBlank(orderBy)) continue;
                this.orderBy.add(orderBy);
            }
        }
        return this;
    }

    public WhereSQLForNamedParam resetOrderBy() {
        this.orderBy = null;
        return this;
    }

    public WhereSQLForNamedParam limit(Integer limit) {
        if (limit != null) {
            this.limit = (long)limit;
        }
        this.offset = null;
        return this;
    }

    public WhereSQLForNamedParam limit(Integer offset, Integer limit) {
        if (limit != null) {
            this.limit = (long)limit;
        }
        if (offset != null) {
            this.offset = (long)offset;
        }
        return this;
    }

    public WhereSQLForNamedParam limit(Long limit) {
        this.limit = limit;
        this.offset = null;
        return this;
    }

    public WhereSQLForNamedParam limit(Long offset, Long limit) {
        this.limit = limit;
        this.offset = offset;
        return this;
    }

    private void doAddParam(Map<String, ?> paramMap) {
        if (paramMap != null) {
            if (this.paramMap == null) {
                this.paramMap = new HashMap<String, Object>();
            }
            this.paramMap.putAll(paramMap);
        }
    }

    private boolean isOrExpression(String condition) {
        Expression expression;
        try {
            expression = CCJSqlParserUtil.parseCondExpression((String)condition);
        }
        catch (JSQLParserException e) {
            LOGGER.error("parse condition:{} exception", (Object)condition, (Object)e);
            throw new BadSQLSyntaxException(e);
        }
        return expression instanceof OrExpression;
    }

    private boolean isAndOrExpression(String condition) {
        Expression expression;
        try {
            expression = CCJSqlParserUtil.parseCondExpression((String)condition);
        }
        catch (JSQLParserException e) {
            LOGGER.error("parse condition:{} exception", (Object)condition, (Object)e);
            throw new BadSQLSyntaxException(e);
        }
        return expression instanceof OrExpression || expression instanceof AndExpression;
    }

    private boolean isNotOnlyHasCondition() {
        return InnerCommonUtils.isNotEmpty(this.groupBy) || InnerCommonUtils.isNotBlank(this.having) || InnerCommonUtils.isNotEmpty(this.orderBy) || this.offset != null || this.limit != null;
    }
}

