/*
 * Decompiled with CFR 0.152.
 */
package com.pugwoo.dbhelper.utils;

import com.pugwoo.dbhelper.DBHelper;
import com.pugwoo.dbhelper.annotation.Column;
import com.pugwoo.dbhelper.annotation.JoinLeftTable;
import com.pugwoo.dbhelper.annotation.JoinRightTable;
import com.pugwoo.dbhelper.annotation.JoinTable;
import com.pugwoo.dbhelper.enums.FeatureEnum;
import com.pugwoo.dbhelper.exception.RowMapperFailException;
import com.pugwoo.dbhelper.impl.part.P0_JdbcTemplateOp;
import com.pugwoo.dbhelper.utils.DOInfoReader;
import com.pugwoo.dbhelper.utils.InnerCommonUtils;
import com.pugwoo.dbhelper.utils.ScriptUtils;
import com.pugwoo.dbhelper.utils.TypeAutoCast;
import java.lang.reflect.Field;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.RowMapper;

public class AnnotationSupportRowMapper<T>
implements RowMapper<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnnotationSupportRowMapper.class);
    private final DBHelper dbHelper;
    private Class<T> clazz;
    private boolean isJoinVO = false;
    private Field leftJoinField;
    private Field rightJoinField;
    private boolean selectOnlyKey = false;

    public AnnotationSupportRowMapper(DBHelper dbHelper, Class<T> clazz) {
        this.dbHelper = dbHelper;
        this.handleClazz(clazz);
    }

    public AnnotationSupportRowMapper(DBHelper dbHelper, Class<T> clazz, boolean selectOnlyKey) {
        this.dbHelper = dbHelper;
        this.selectOnlyKey = selectOnlyKey;
        this.handleClazz(clazz);
    }

    private void handleClazz(Class<T> clazz) {
        this.clazz = clazz;
        JoinTable joinTable = DOInfoReader.getJoinTable(clazz);
        if (joinTable != null) {
            this.isJoinVO = true;
            this.leftJoinField = DOInfoReader.getJoinLeftTable(clazz);
            this.rightJoinField = DOInfoReader.getJoinRightTable(clazz);
        }
    }

    public T mapRow(ResultSet rs, int index) {
        ArrayList<Field> currentField = new ArrayList<Field>(1);
        currentField.add(null);
        try {
            TypeAutoCast.BasicTypeResult basicTypeResult = TypeAutoCast.transBasicType(this.clazz, rs);
            if (basicTypeResult.isBasicType()) {
                return (T)basicTypeResult.getValue();
            }
            T obj = this.clazz.newInstance();
            if (this.isJoinVO) {
                currentField.set(0, this.leftJoinField);
                Object t1 = this.leftJoinField.getType().newInstance();
                JoinLeftTable joinLeftTable = this.leftJoinField.getAnnotation(JoinLeftTable.class);
                List<Field> fieldsT1 = DOInfoReader.getColumnsForSelect(this.leftJoinField.getType(), this.selectOnlyKey);
                boolean isT1AllNull = this.handleFieldAndIsAllFieldNull(fieldsT1, joinLeftTable.alias(), t1, rs, currentField);
                currentField.set(0, this.leftJoinField);
                DOInfoReader.setValue(this.leftJoinField, obj, isT1AllNull ? null : t1);
                currentField.set(0, null);
                currentField.set(0, this.rightJoinField);
                Object t2 = this.rightJoinField.getType().newInstance();
                JoinRightTable joinRightTable = this.rightJoinField.getAnnotation(JoinRightTable.class);
                List<Field> fieldsT2 = DOInfoReader.getColumnsForSelect(this.rightJoinField.getType(), this.selectOnlyKey);
                boolean isT2AllNull = this.handleFieldAndIsAllFieldNull(fieldsT2, joinRightTable.alias(), t2, rs, currentField);
                currentField.set(0, this.rightJoinField);
                DOInfoReader.setValue(this.rightJoinField, obj, isT2AllNull ? null : t2);
                currentField.set(0, null);
            } else {
                List<Field> fields = DOInfoReader.getColumnsForSelect(this.clazz, this.selectOnlyKey);
                for (Field field : fields) {
                    currentField.set(0, field);
                    Column column = field.getAnnotation(Column.class);
                    Object value = this.getFromRS(rs, column.value(), field);
                    if (value == null && InnerCommonUtils.isNotBlank(column.readIfNullScript())) {
                        value = ScriptUtils.getValueFromScript(column.ignoreScriptError(), column.readIfNullScript());
                    }
                    DOInfoReader.setValue(field, obj, value);
                    currentField.set(0, null);
                }
            }
            return obj;
        }
        catch (Exception e) {
            boolean isHandleField;
            boolean bl = isHandleField = !currentField.isEmpty() && currentField.get(0) != null;
            if (isHandleField) {
                LOGGER.error("mapRow exception, class:{}, field:{}", new Object[]{this.clazz, currentField.get(0), e});
                throw new RowMapperFailException(e, (Field)currentField.get(0));
            }
            LOGGER.error("mapRow exception, class:{}", this.clazz, (Object)e);
            throw new RowMapperFailException(e);
        }
    }

    private Object getFromRS(ResultSet rs, String columnName, Field field) throws Exception {
        if (this.dbHelper instanceof P0_JdbcTemplateOp) {
            boolean throwErrorIfColumnNotExist = ((P0_JdbcTemplateOp)this.dbHelper).getFeature(FeatureEnum.THROW_EXCEPTION_IF_COLUMN_NOT_EXIST);
            if (!throwErrorIfColumnNotExist) {
                try {
                    return TypeAutoCast.getFromRS(rs, columnName, field, this.dbHelper.getDatabaseType());
                }
                catch (SQLException e) {
                    String message = e.getMessage();
                    if (!(message.contains("not found") || message.contains("does not exist") || message.contains("\u627e\u4e0d\u5230"))) {
                        throw e;
                    }
                    LOGGER.warn("column:[{}] not found in ResultSet, class:{}, field:{}", new Object[]{columnName, this.clazz, field});
                    return null;
                }
            }
            return TypeAutoCast.getFromRS(rs, columnName, field, this.dbHelper.getDatabaseType());
        }
        return TypeAutoCast.getFromRS(rs, columnName, field, this.dbHelper.getDatabaseType());
    }

    private boolean handleFieldAndIsAllFieldNull(List<Field> fields, String tableAlias, Object t, ResultSet rs, List<Field> currentField) throws Exception {
        boolean isAllNull = true;
        for (Field field : fields) {
            currentField.set(0, field);
            Column column = field.getAnnotation(Column.class);
            String columnName = tableAlias + "." + column.value();
            Object value = this.getFromRS(rs, columnName, field);
            if (value != null) {
                isAllNull = false;
            }
            if (value == null && InnerCommonUtils.isNotBlank(column.readIfNullScript())) {
                value = ScriptUtils.getValueFromScript(column.ignoreScriptError(), column.readIfNullScript());
            }
            DOInfoReader.setValue(field, t, value);
            currentField.set(0, null);
        }
        return isAllNull;
    }
}

