/*
 * Decompiled with CFR 0.152.
 */
package com.pugwoo.dbhelper.utils;

import com.pugwoo.dbhelper.annotation.Column;
import com.pugwoo.dbhelper.annotation.JoinLeftTable;
import com.pugwoo.dbhelper.annotation.JoinRightTable;
import com.pugwoo.dbhelper.annotation.JoinTable;
import com.pugwoo.dbhelper.annotation.Table;
import com.pugwoo.dbhelper.cache.ClassInfoCache;
import com.pugwoo.dbhelper.exception.CasVersionNotMatchException;
import com.pugwoo.dbhelper.exception.NoColumnAnnotationException;
import com.pugwoo.dbhelper.exception.NoJoinTableMemberException;
import com.pugwoo.dbhelper.exception.NoKeyColumnAnnotationException;
import com.pugwoo.dbhelper.exception.NoTableAnnotationException;
import com.pugwoo.dbhelper.exception.RelatedColumnFieldNotFoundException;
import com.pugwoo.dbhelper.json.NimbleOrmJSON;
import com.pugwoo.dbhelper.utils.InnerCommonUtils;
import com.pugwoo.dbhelper.utils.TypeAutoCast;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DOInfoReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(DOInfoReader.class);

    public static Table getTable(Class<?> clazz) throws NoTableAnnotationException {
        Table table = ClassInfoCache.getTable(clazz);
        if (table != null) {
            if (table.sameTableNameAs() != Void.TYPE) {
                if (InnerCommonUtils.isNotBlank(table.value())) {
                    LOGGER.warn("class:{} @Table annotation value:{} is ignored because @Table.sameTableNameAs is not void.class, it is {}", new Object[]{clazz, table.value(), table.sameTableNameAs()});
                }
                return DOInfoReader.getTable(table.sameTableNameAs());
            }
            return table;
        }
        throw new NoTableAnnotationException("class: " + (clazz == null ? "null" : clazz.getName()) + " does not have @Table annotation.");
    }

    public static JoinTable getJoinTable(Class<?> clazz) {
        return DOInfoReader.getAnnotationClass(clazz, JoinTable.class);
    }

    public static boolean isVirtualTable(Class<?> clazz) {
        JoinTable joinTable = DOInfoReader.getJoinTable(clazz);
        if (joinTable != null) {
            return false;
        }
        Table table = DOInfoReader.getTable(clazz);
        return InnerCommonUtils.isNotBlank(table.virtualTableSQL()) || InnerCommonUtils.isNotBlank(table.virtualTablePath());
    }

    public static List<RelatedField> getFieldByDBField(Class<?> clazz, String dbFieldName, Field relatedColumnField) {
        List<String> dbFieldNameList = InnerCommonUtils.split(dbFieldName, ",");
        ArrayList<RelatedField> fields = new ArrayList<RelatedField>();
        JoinTable joinTable = DOInfoReader.getJoinTable(clazz);
        String leftTablePrefix = "";
        String rightTablePrefix = "";
        if (joinTable == null) {
            List<Field> fs = DOInfoReader.getColumns(clazz);
            for (Field field : fs) {
                fields.add(new RelatedField(field, 0, ""));
            }
        } else {
            Field joinLeftTableFiled = DOInfoReader.getJoinLeftTable(clazz);
            Field joinRightTableFiled = DOInfoReader.getJoinRightTable(clazz);
            leftTablePrefix = joinLeftTableFiled.getAnnotation(JoinLeftTable.class).alias() + ".";
            rightTablePrefix = joinRightTableFiled.getAnnotation(JoinRightTable.class).alias() + ".";
            List<Field> leftFs = DOInfoReader.getColumns(joinLeftTableFiled.getType());
            List<Field> rightFs = DOInfoReader.getColumns(joinRightTableFiled.getType());
            for (Field f : leftFs) {
                fields.add(new RelatedField(f, 1, leftTablePrefix));
            }
            for (Field f : rightFs) {
                fields.add(new RelatedField(f, 2, rightTablePrefix));
            }
        }
        ArrayList<RelatedField> result = new ArrayList<RelatedField>();
        for (String string : dbFieldNameList) {
            boolean isFound = false;
            for (RelatedField field : fields) {
                Column column;
                if (joinTable == null) {
                    column = field.field.getAnnotation(Column.class);
                    if (!column.value().trim().equalsIgnoreCase(string)) continue;
                    result.add(field);
                    isFound = true;
                    break;
                }
                if (string.startsWith(leftTablePrefix)) {
                    if (field.fieldType != 1 || !(column = field.field.getAnnotation(Column.class)).value().trim().equalsIgnoreCase(string.substring(leftTablePrefix.length()))) continue;
                    result.add(field);
                    isFound = true;
                    break;
                }
                if (string.startsWith(rightTablePrefix)) {
                    if (field.fieldType != 2 || !(column = field.field.getAnnotation(Column.class)).value().trim().equalsIgnoreCase(string.substring(rightTablePrefix.length()))) continue;
                    result.add(field);
                    isFound = true;
                    break;
                }
                throw new RelatedColumnFieldNotFoundException(relatedColumnField.getDeclaringClass().getName() + " @RelatedColumn field:" + relatedColumnField.getName() + ", column: " + string + " should start with " + leftTablePrefix + " or " + rightTablePrefix);
            }
            if (isFound) continue;
            throw new RelatedColumnFieldNotFoundException(relatedColumnField.getDeclaringClass().getName() + " @RelatedColumn field:" + relatedColumnField.getName() + ", column: " + string + " not found in class " + clazz.getName());
        }
        return result;
    }

    public static Class<?> getGenericFieldType(Field field) {
        ParameterizedType stringListType = (ParameterizedType)field.getGenericType();
        return (Class)stringListType.getActualTypeArguments()[0];
    }

    public static List<Field> getColumns(Class<?> clazz) throws NoColumnAnnotationException {
        if (clazz == null) {
            throw new NoColumnAnnotationException("class is null");
        }
        List<Field> result = ClassInfoCache.getColumnFields(clazz);
        if (InnerCommonUtils.isEmpty(result)) {
            throw new NoColumnAnnotationException("class " + clazz.getName() + " does not have any @Column fields");
        }
        return result;
    }

    public static List<Field> getColumnsForSelect(Class<?> clazz, boolean selectOnlyKey) {
        List<Field> result = DOInfoReader.getColumns(clazz);
        if (selectOnlyKey) {
            result = InnerCommonUtils.filter(result, o -> o.getAnnotation(Column.class).isKey());
        }
        if (result.isEmpty()) {
            throw new NoColumnAnnotationException("class " + clazz.getName() + " does not have any @Column fields");
        }
        return result;
    }

    public static Field getJoinLeftTable(Class<?> clazz) {
        return DOInfoReader.getJoinTableField(clazz, JoinLeftTable.class);
    }

    public static Field getJoinRightTable(Class<?> clazz) {
        return DOInfoReader.getJoinTableField(clazz, JoinRightTable.class);
    }

    private static Field getJoinTableField(Class<?> clazz, Class<? extends Annotation> annotationClass) {
        if (clazz == null) {
            throw new NoJoinTableMemberException("clazz is null");
        }
        List<Field> result = DOInfoReader._getAnnotationColumns(clazz, annotationClass);
        if (result.isEmpty()) {
            throw new NoJoinTableMemberException("class " + clazz.getName() + " does not have @" + annotationClass.getSimpleName() + " field");
        }
        if (result.size() > 1) {
            LOGGER.error("class {} has more than one @{} fields, use first one", (Object)clazz.getName(), (Object)annotationClass.getSimpleName());
        }
        return result.get(0);
    }

    public static List<Field> getKeyColumns(Class<?> clazz) throws NoKeyColumnAnnotationException {
        List<Field> keyFields = DOInfoReader.getKeyColumnsNoThrowsException(clazz);
        if (keyFields.isEmpty()) {
            throw new NoKeyColumnAnnotationException();
        }
        return keyFields;
    }

    public static List<Field> getKeyColumnsNoThrowsException(Class<?> clazz) {
        List<Field> fields = DOInfoReader.getColumns(clazz);
        ArrayList<Field> keyFields = new ArrayList<Field>();
        for (Field field : fields) {
            Column column = field.getAnnotation(Column.class);
            if (!column.isKey()) continue;
            keyFields.add(field);
        }
        return keyFields;
    }

    public static Field getCasVersionColumn(Class<?> clazz) throws CasVersionNotMatchException {
        List<Field> fields = DOInfoReader.getColumns(clazz);
        Field casVersionField = null;
        for (Field field : fields) {
            Column column = field.getAnnotation(Column.class);
            if (!column.casVersion()) continue;
            if (casVersionField != null) {
                throw new CasVersionNotMatchException("there are more than one casVersion column in a DO class");
            }
            casVersionField = field;
        }
        return casVersionField;
    }

    public static Field getAutoIncrementField(Class<?> clazz) {
        List<Field> fields = DOInfoReader.getColumns(clazz);
        for (Field field : fields) {
            Column column = field.getAnnotation(Column.class);
            if (!column.isAutoIncrement()) continue;
            return field;
        }
        return null;
    }

    public static Field getSoftDeleteColumn(Class<?> clazz) {
        List<Field> fields = DOInfoReader.getColumns(clazz);
        for (Field field : fields) {
            Column column = field.getAnnotation(Column.class);
            if (column.softDelete().length != 2 || !InnerCommonUtils.isNotBlank(column.softDelete()[0]) || !InnerCommonUtils.isNotBlank(column.softDelete()[1])) continue;
            return field;
        }
        return null;
    }

    public static List<Field> getNotKeyColumns(Class<?> clazz) {
        List<Field> fields = DOInfoReader.getColumns(clazz);
        ArrayList<Field> keyFields = new ArrayList<Field>();
        for (Field field : fields) {
            Column column = field.getAnnotation(Column.class);
            if (column.isKey()) continue;
            keyFields.add(field);
        }
        return keyFields;
    }

    public static List<Field> getRelatedColumns(Class<?> clazz) {
        return ClassInfoCache.getRelatedColumns(clazz);
    }

    public static Object getValue(Field field, Object object) {
        Method method = ClassInfoCache.getFieldGetMethod(field);
        if (method != null) {
            try {
                method.setAccessible(true);
                return method.invoke(object, new Object[0]);
            }
            catch (Exception e) {
                LOGGER.error("get method:{} invoke fail", (Object)method, (Object)e);
            }
        }
        field.setAccessible(true);
        try {
            return field.get(object);
        }
        catch (Exception e) {
            LOGGER.error("field:{} get fail", (Object)field, (Object)e);
            return null;
        }
    }

    public static Object getValueForRelatedColumn(List<RelatedField> fields, Object object) {
        if (fields == null || fields.isEmpty()) {
            return null;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        for (RelatedField relatedField : fields) {
            if (relatedField.fieldType == 0) {
                result.add(DOInfoReader.getValue(relatedField.field, object));
                continue;
            }
            if (relatedField.fieldType == 1) {
                Field joinLeftTableField = DOInfoReader.getJoinLeftTable(object.getClass());
                Object obj1 = DOInfoReader.getValue(joinLeftTableField, object);
                if (obj1 == null) {
                    result.add(null);
                    continue;
                }
                result.add(DOInfoReader.getValue(relatedField.field, obj1));
                continue;
            }
            if (relatedField.fieldType != 2) continue;
            Field joinRightTableField = DOInfoReader.getJoinRightTable(object.getClass());
            Object obj2 = DOInfoReader.getValue(joinRightTableField, object);
            if (obj2 == null) {
                result.add(null);
                continue;
            }
            result.add(DOInfoReader.getValue(relatedField.field, obj2));
        }
        return result.size() == 1 ? result.get(0) : result;
    }

    public static void setValue(Field field, Object object, Object value) {
        value = TypeAutoCast.cast(value, field.getType());
        Method method = ClassInfoCache.getFieldSetMethod(field);
        if (method != null) {
            try {
                method.invoke(object, value);
            }
            catch (Exception e) {
                LOGGER.error("set method:{} invoke fail, object:{}, value:{}", new Object[]{method.getName(), NimbleOrmJSON.toJson(object), value, e});
            }
        } else {
            field.setAccessible(true);
            try {
                field.set(object, value);
            }
            catch (Exception e) {
                LOGGER.error("field:{} set fail, object:{}, value:{}", new Object[]{field.getName(), NimbleOrmJSON.toJson(object), value, e});
            }
        }
    }

    private static List<Field> _getAnnotationColumns(Class<?> clazz, Class<? extends Annotation> annotationClazz) {
        List<Class<?>> classLink = DOInfoReader.getClassAndParentClasses(clazz);
        return DOInfoReader._getFields(classLink, annotationClazz);
    }

    private static List<Class<?>> getClassAndParentClasses(Class<?> clazz) {
        if (clazz == null) {
            return new ArrayList();
        }
        ArrayList classLink = new ArrayList();
        for (Class<?> curClass = clazz; curClass != null; curClass = curClass.getSuperclass()) {
            classLink.add(curClass);
        }
        return classLink;
    }

    private static <T extends Annotation> T getAnnotationClass(Class<?> clazz, Class<T> annotationClass) {
        for (Class<?> curClass = clazz; curClass != null; curClass = curClass.getSuperclass()) {
            T annotation = curClass.getAnnotation(annotationClass);
            if (annotation == null) continue;
            return annotation;
        }
        return null;
    }

    private static List<Field> _getFields(List<Class<?>> classLink, Class<? extends Annotation> annotationClazz) {
        ArrayList<Field> result = new ArrayList<Field>();
        if (classLink == null || classLink.isEmpty() || annotationClazz == null) {
            return result;
        }
        ArrayList<List<Field>> fieldList = new ArrayList<List<Field>>();
        for (int i = classLink.size() - 1; i >= 0; --i) {
            Field[] fieldArray = classLink.get(i).getDeclaredFields();
            fieldList.add(InnerCommonUtils.filter(fieldArray, o -> o.getAnnotation(annotationClazz) != null));
        }
        if (annotationClazz == Column.class) {
            HashSet<String> columnValues = new HashSet<String>();
            ArrayList arrayList = new ArrayList();
            for (int i = fieldList.size() - 1; i >= 0; --i) {
                List list = (List)fieldList.get(i);
                ArrayList<Field> fieldsTmp = new ArrayList<Field>();
                for (Field field : list) {
                    Column column = field.getAnnotation(Column.class);
                    if (columnValues.contains(column.value())) {
                        LOGGER.error("found duplicate field:{} in class(and its parents):{}, this field is ignored", (Object)field.getName(), (Object)classLink.get(0).getName());
                        continue;
                    }
                    columnValues.add(column.value());
                    fieldsTmp.add(field);
                }
                arrayList.add(0, fieldsTmp);
            }
            for (List list : arrayList) {
                result.addAll(list);
            }
        } else {
            for (List list : fieldList) {
                result.addAll(list);
            }
        }
        return result;
    }

    public static class RelatedField {
        public Field field;
        public int fieldType;
        public String fieldPrefix;

        public RelatedField(Field field, int fieldType, String fieldPrefix) {
            this.field = field;
            this.fieldType = fieldType;
            this.fieldPrefix = fieldPrefix;
        }
    }
}

