/*
 * Decompiled with CFR 0.152.
 */
package com.pugwoo.dbhelper.utils;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class InnerCommonUtils {
    public static boolean isBlank(String str) {
        if (str == null) {
            return true;
        }
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(String str) {
        return !InnerCommonUtils.isBlank(str);
    }

    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isNotEmpty(Collection<?> collection) {
        return collection != null && !collection.isEmpty();
    }

    public static <T> Collection<T> filterNonNull(Collection<T> list) {
        if (list == null) {
            return new ArrayList();
        }
        for (T t : list) {
            if (t != null) continue;
            return InnerCommonUtils.filter(list, Objects::nonNull);
        }
        return list;
    }

    public static <T> List<T> filter(Collection<T> list, Predicate<? super T> predicate) {
        if (list == null) {
            return new ArrayList();
        }
        return list.stream().filter(predicate).collect(Collectors.toList());
    }

    public static <T> List<T> filter(T[] array, Predicate<? super T> predicate) {
        if (array == null || array.length == 0) {
            return new ArrayList();
        }
        ArrayList<T> list = new ArrayList<T>();
        for (T t : array) {
            if (!predicate.test(t)) continue;
            list.add(t);
        }
        return list;
    }

    public static <T> Stream<List<T>> partition(Stream<T> stream, int groupNum) {
        ArrayList currentBatch = new ArrayList();
        currentBatch.add(new ArrayList(groupNum));
        return Stream.concat(((Stream)stream.sequential()).map(t -> {
            ((List)currentBatch.get(0)).add(t);
            return ((List)currentBatch.get(0)).size() == groupNum ? (List)currentBatch.set(0, new ArrayList(groupNum)) : null;
        }), Stream.generate(() -> ((List)currentBatch.get(0)).isEmpty() ? null : (List)currentBatch.get(0)).limit(1L)).filter(Objects::nonNull);
    }

    public static boolean isNotEmpty(String[] strings) {
        return strings != null && strings.length > 0;
    }

    public static boolean isContains(String checkStr, String[] strings) {
        if (!InnerCommonUtils.isNotEmpty(strings)) {
            return false;
        }
        boolean isContain = false;
        for (String str : strings) {
            if (!Objects.equals(str, checkStr)) continue;
            isContain = true;
            break;
        }
        return isContain;
    }

    public static List<String> split(String str, String sep) {
        if (str == null || str.isEmpty()) {
            return new ArrayList<String>();
        }
        String[] splits = str.split(sep);
        ArrayList<String> result = new ArrayList<String>();
        for (String s : splits) {
            if (!InnerCommonUtils.isNotBlank(s)) continue;
            result.add(s.trim());
        }
        return result;
    }

    public static String firstLetterUpperCase(String str) {
        if (str == null || str.isEmpty()) {
            return "";
        }
        String firstLetter = str.substring(0, 1).toUpperCase();
        return firstLetter + str.substring(1);
    }

    public static String readClasspathResourceAsString(String path) {
        InputStream in = InnerCommonUtils.readClasspathResourceInputStream(path);
        if (in == null) {
            throw new RuntimeException(new FileNotFoundException(path));
        }
        return InnerCommonUtils.readAll(in, "UTF-8");
    }

    private static InputStream readClasspathResourceInputStream(String path) {
        if (InnerCommonUtils.isBlank(path)) {
            return null;
        }
        boolean beginWithSlash = path.startsWith("/");
        String noSlash = beginWithSlash ? path.substring(1) : path;
        InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(noSlash);
        if (in != null) {
            return in;
        }
        String withSlash = beginWithSlash ? path : "/" + path;
        return Thread.currentThread().getContextClassLoader().getResourceAsStream(withSlash);
    }

    private static String readAll(InputStream in, String charset) {
        BufferedReader reader = null;
        try {
            String line;
            InputStreamReader inputStreamReader = new InputStreamReader(in, charset);
            reader = new BufferedReader(inputStreamReader);
            StringBuilder stringBuilder = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                stringBuilder.append(line);
                stringBuilder.append("\n");
            }
            String string = stringBuilder.toString();
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static String encodeBase64(byte[] bytes) {
        return Base64.getEncoder().encodeToString(bytes);
    }

    public static byte[] decodeBase64(String str) {
        return Base64.getDecoder().decode(str);
    }
}

