/*
 * Decompiled with CFR 0.152.
 */
package com.pugwoo.dbhelper.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamedParameterUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(NamedParameterUtils.class);

    /*
     * WARNING - void declaration
     */
    public static Map<String, Object> transParam(List<Object> params) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (params != null) {
            int currParamIndex = 1;
            for (Object object : params) {
                void var4_4;
                void var4_13;
                if (object != null && object.getClass().isArray()) {
                    ArrayList<Object> p = new ArrayList<Object>();
                    if (object instanceof char[]) {
                        for (char c : (char[])object) {
                            p.add(Character.valueOf(c));
                        }
                        ArrayList<Object> arrayList = p;
                    } else if (object instanceof short[]) {
                        for (short s : (short[])object) {
                            p.add(s);
                        }
                        ArrayList<Object> arrayList = p;
                    } else if (object instanceof int[]) {
                        for (int i : (int[])object) {
                            p.add(i);
                        }
                        ArrayList<Object> arrayList = p;
                    } else if (object instanceof long[]) {
                        for (long l : (long[])object) {
                            p.add(l);
                        }
                        ArrayList<Object> arrayList = p;
                    } else if (object instanceof float[]) {
                        for (float f : (float[])object) {
                            p.add(Float.valueOf(f));
                        }
                        ArrayList<Object> arrayList = p;
                    } else if (object instanceof double[]) {
                        for (double d : (double[])object) {
                            p.add(d);
                        }
                        ArrayList<Object> arrayList = p;
                    } else if (object instanceof Object[]) {
                        p.addAll(Arrays.asList((Object[])object));
                        ArrayList<Object> arrayList = p;
                    }
                }
                if (var4_13 instanceof List) {
                    if (((List)var4_13).isEmpty()) {
                        ArrayList<Object> list = new ArrayList<Object>(1);
                        list.add(null);
                        ArrayList<Object> arrayList = list;
                    }
                } else if (var4_13 instanceof Set && ((Set)var4_13).isEmpty()) {
                    HashSet<Object> set = new HashSet<Object>(1);
                    set.add(null);
                    HashSet<Object> hashSet = set;
                }
                map.put("param" + currParamIndex++, var4_4);
            }
        }
        return map;
    }

    public static String trans(String sql, List<Object> args) {
        if (sql == null || sql.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        boolean isInStr = false;
        boolean isInComment = false;
        int commentType = 0;
        boolean isPreBackSlash = false;
        boolean isPreHyphen = false;
        boolean isPreSlash = false;
        boolean isPreAsterisk = false;
        int currParamIndex = 1;
        for (char ch : sql.toCharArray()) {
            if (ch == '?' && !isInStr && !isInComment) {
                sb.append(":param").append(currParamIndex++);
                continue;
            }
            sb.append(ch);
            if (!isInComment && ch == '\'') {
                if (!isInStr) {
                    isInStr = true;
                } else if (!isPreBackSlash) {
                    isInStr = false;
                }
            }
            if (!isInStr) {
                if (!isInComment) {
                    if (isPreHyphen && ch == '-') {
                        isInComment = true;
                        commentType = 1;
                    } else if (isPreSlash && ch == '*') {
                        isInComment = true;
                        commentType = 2;
                    }
                } else if (commentType == 1 && ch == '\n') {
                    isInComment = false;
                    commentType = 0;
                } else if (commentType == 2 && isPreAsterisk && ch == '/') {
                    isInComment = false;
                    commentType = 0;
                }
            }
            isPreBackSlash = ch == '\\';
            isPreHyphen = ch == '-';
            isPreSlash = ch == '/';
            isPreAsterisk = ch == '*';
        }
        if (currParamIndex - 1 != args.size()) {
            LOGGER.error("SQL args not matched, provide args count:{}, expected:{}, SQL:{}", new Object[]{args.size(), currParamIndex - 1, sql});
        }
        return sb.toString();
    }
}

