/*
 * Decompiled with CFR 0.152.
 */
package com.pugwoo.dbhelper.utils;

import com.pugwoo.dbhelper.annotation.Column;
import com.pugwoo.dbhelper.annotation.Table;
import com.pugwoo.dbhelper.enums.ValueConditionEnum;
import com.pugwoo.dbhelper.impl.DBHelperContext;
import com.pugwoo.dbhelper.utils.DOInfoReader;
import com.pugwoo.dbhelper.utils.InnerCommonUtils;
import com.pugwoo.dbhelper.utils.ScriptUtils;
import java.lang.reflect.Field;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoLocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreHandleObject {
    private static final Logger LOGGER = LoggerFactory.getLogger(PreHandleObject.class);

    public static <T> void preHandleInsert(T t) {
        if (t == null) {
            return;
        }
        List<Field> fields = DOInfoReader.getColumns(t.getClass());
        if (fields.isEmpty()) {
            return;
        }
        Table table = DOInfoReader.getTable(t.getClass());
        Map<Class<?>, Object> defaultValueMap = DBHelperContext.getInsertDefaultValueMap(table.insertDefaultValueMap());
        boolean hasDefaultValueMap = defaultValueMap != null && !defaultValueMap.isEmpty();
        for (Field field : fields) {
            String value;
            Object defaultValue;
            String insertValueScript;
            Object delete;
            Column column = field.getAnnotation(Column.class);
            if (column.softDelete().length == 2 && InnerCommonUtils.isNotBlank(column.softDelete()[0]) && InnerCommonUtils.isNotBlank(column.softDelete()[1]) && (delete = DOInfoReader.getValue(field, t)) == null) {
                DOInfoReader.setValue(field, t, column.softDelete()[0]);
            }
            if (column.setTimeWhenInsert() && DOInfoReader.getValue(field, t) == null) {
                PreHandleObject.setNowDateTime(field, t);
            }
            if (column.setRandomStringWhenInsert() && DOInfoReader.getValue(field, t) == null) {
                DOInfoReader.setValue(field, t, UUID.randomUUID().toString().replace("-", "").substring(0, 32));
            }
            if (column.casVersion() && DOInfoReader.getValue(field, t) == null) {
                DOInfoReader.setValue(field, t, 1);
            }
            if (InnerCommonUtils.isNotBlank(insertValueScript = column.insertValueScript())) {
                ValueConditionEnum valueConditionEnum = table.insertValueCondition();
                Object value2 = DOInfoReader.getValue(field, t);
                if (valueConditionEnum == null || valueConditionEnum == ValueConditionEnum.WHEN_NULL) {
                    if (value2 == null) {
                        ScriptUtils.setValueFromScript(t, field, column.ignoreScriptError(), insertValueScript);
                    }
                } else if (valueConditionEnum == ValueConditionEnum.WHEN_EMPTY) {
                    if (value2 == null || value2 instanceof String && ((String)value2).isEmpty()) {
                        ScriptUtils.setValueFromScript(t, field, column.ignoreScriptError(), insertValueScript);
                    }
                } else if (valueConditionEnum == ValueConditionEnum.WHEN_BLANK && (value2 == null || value2 instanceof String && InnerCommonUtils.isBlank((String)value2))) {
                    ScriptUtils.setValueFromScript(t, field, column.ignoreScriptError(), insertValueScript);
                }
            }
            if (hasDefaultValueMap && !column.isKey() && (defaultValue = defaultValueMap.get(field.getType())) != null) {
                ValueConditionEnum valueConditionEnum = table.insertValueCondition();
                Object value3 = DOInfoReader.getValue(field, t);
                if (valueConditionEnum == null || valueConditionEnum == ValueConditionEnum.WHEN_NULL) {
                    if (value3 == null) {
                        DOInfoReader.setValue(field, t, defaultValue);
                    }
                } else if (valueConditionEnum == ValueConditionEnum.WHEN_EMPTY) {
                    if (value3 == null || value3 instanceof String && ((String)value3).isEmpty()) {
                        DOInfoReader.setValue(field, t, defaultValue);
                    }
                } else if (valueConditionEnum == ValueConditionEnum.WHEN_BLANK && (value3 == null || value3 instanceof String && InnerCommonUtils.isBlank((String)value3))) {
                    DOInfoReader.setValue(field, t, defaultValue);
                }
            }
            if ((column.autoTrimString() == 1 || column.autoTrimString() == -1 && table.autoTrimString() == 1) && String.class.equals(field.getType()) && (value = (String)DOInfoReader.getValue(field, t)) != null) {
                DOInfoReader.setValue(field, t, value.trim());
            }
            if (column.maxStringLength() < 0 || !String.class.equals(field.getType()) || (value = (String)DOInfoReader.getValue(field, t)) == null || value.length() <= column.maxStringLength()) continue;
            String newValue = value.substring(0, column.maxStringLength());
            DOInfoReader.setValue(field, t, newValue);
            LOGGER.warn("truncate class:{} field:{} value:{} to maxStringLength:{} newValue:{}", new Object[]{t.getClass().getName(), field.getName(), value, column.maxStringLength(), newValue});
        }
    }

    public static <T> void preHandleDelete(T t) {
        if (t == null) {
            return;
        }
        List<Field> notKeyFields = DOInfoReader.getNotKeyColumns(t.getClass());
        for (Field field : notKeyFields) {
            Column column = field.getAnnotation(Column.class);
            if (!InnerCommonUtils.isNotBlank(column.deleteValueScript())) continue;
            ScriptUtils.setValueFromScript(t, field, column.ignoreScriptError(), column.deleteValueScript());
        }
    }

    public static <T> void preHandleUpdate(T t) {
        if (t == null) {
            return;
        }
        List<Field> notKeyFields = DOInfoReader.getNotKeyColumns(t.getClass());
        Table table = DOInfoReader.getTable(t.getClass());
        for (Field field : notKeyFields) {
            String value;
            Object delete;
            Column column = field.getAnnotation(Column.class);
            if (column.setTimeWhenUpdate()) {
                PreHandleObject.setNowDateTime(field, t);
            }
            if (column.softDelete().length == 2 && InnerCommonUtils.isNotBlank(column.softDelete()[0]) && InnerCommonUtils.isNotBlank(column.softDelete()[1]) && (delete = DOInfoReader.getValue(field, t)) == null) {
                DOInfoReader.setValue(field, t, column.softDelete()[0]);
            }
            if (InnerCommonUtils.isNotBlank(column.updateValueScript())) {
                ScriptUtils.setValueFromScript(t, field, column.ignoreScriptError(), column.updateValueScript());
            }
            if ((column.autoTrimString() == 1 || column.autoTrimString() == -1 && table.autoTrimString() == 1) && String.class.equals(field.getType()) && (value = (String)DOInfoReader.getValue(field, t)) != null) {
                DOInfoReader.setValue(field, t, value.trim());
            }
            if (column.maxStringLength() < 0 || !String.class.equals(field.getType()) || (value = (String)DOInfoReader.getValue(field, t)) == null || value.length() <= column.maxStringLength()) continue;
            String newValue = value.substring(0, column.maxStringLength());
            DOInfoReader.setValue(field, t, newValue);
            LOGGER.warn("truncate class:{} field:{} value:{} to maxStringLength:{} newValue:{}", new Object[]{t.getClass().getName(), field.getName(), value, column.maxStringLength(), newValue});
        }
    }

    public static String getNowDateTime(Class<?> clazz) {
        if (clazz == java.util.Date.class || clazz == LocalDateTime.class || clazz == Date.class || clazz == Calendar.class || clazz == Instant.class || clazz == ZonedDateTime.class) {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new java.util.Date());
        }
        if (clazz == LocalDate.class) {
            return new SimpleDateFormat("yyyy-MM-dd").format(new java.util.Date());
        }
        if (clazz == Time.class || clazz == LocalTime.class) {
            return new SimpleDateFormat("HH:mm:ss").format(new java.util.Date());
        }
        if (clazz == Timestamp.class) {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new java.util.Date());
        }
        LOGGER.error("fail to get now date time for class:{}", clazz);
        return null;
    }

    private static void setNowDateTime(Field field, Object obj) {
        Class<?> clazz = field.getType();
        Comparable<ChronoLocalDateTime<?>> value = null;
        if (clazz == java.util.Date.class) {
            value = new java.util.Date(System.currentTimeMillis() / 1000L * 1000L);
        } else if (clazz == LocalDateTime.class) {
            value = LocalDateTime.now().truncatedTo(ChronoUnit.SECONDS);
        } else if (clazz == LocalDate.class) {
            value = LocalDate.now();
        } else if (clazz == Date.class) {
            value = new Date(System.currentTimeMillis() / 1000L * 1000L);
        } else if (clazz == Timestamp.class) {
            value = new Timestamp(System.currentTimeMillis());
        } else if (clazz == LocalTime.class) {
            value = LocalTime.now().truncatedTo(ChronoUnit.SECONDS);
        } else if (clazz == Time.class) {
            value = new Time(System.currentTimeMillis() / 1000L * 1000L);
        } else if (clazz == Calendar.class) {
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(System.currentTimeMillis() / 1000L * 1000L);
            value = cal;
        } else if (clazz == Instant.class) {
            value = Instant.now().truncatedTo(ChronoUnit.SECONDS);
        } else if (clazz == ZonedDateTime.class) {
            value = ZonedDateTime.now().truncatedTo(ChronoUnit.SECONDS);
        } else {
            LOGGER.error("fail to set now date time for class:{}", clazz);
        }
        if (value != null) {
            DOInfoReader.setValue(field, obj, value);
        }
    }
}

