/*
 * Decompiled with CFR 0.152.
 */
package com.pugwoo.dbhelper.utils;

import com.pugwoo.dbhelper.annotation.Column;
import com.pugwoo.dbhelper.enums.DatabaseTypeEnum;
import com.pugwoo.dbhelper.json.NimbleOrmDateUtils;
import com.pugwoo.dbhelper.json.NimbleOrmJSON;
import com.pugwoo.dbhelper.utils.InnerCommonUtils;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeAutoCast {
    private static final Logger LOGGER = LoggerFactory.getLogger(TypeAutoCast.class);

    public static Object getFromRS(ResultSet rs, String columnName, Field field, DatabaseTypeEnum databaseType) throws Exception {
        int columnIndex = rs.findColumn(columnName);
        Object result = rs.getObject(columnIndex);
        if (result == null) {
            return null;
        }
        Column column = field.getAnnotation(Column.class);
        if (column != null && column.isJSON()) {
            String valStr;
            String string = valStr = result instanceof String ? (String)result : rs.getString(columnIndex);
            if (InnerCommonUtils.isBlank(valStr)) {
                return null;
            }
            Type genericType = field.getGenericType();
            try {
                if (genericType instanceof Class) {
                    return NimbleOrmJSON.parse(valStr, field.getType());
                }
                return NimbleOrmJSON.parseGeneric(valStr, (ParameterizedType)genericType);
            }
            catch (Exception e) {
                LOGGER.error("parse column to JSON fail, json:{}, type:{}", new Object[]{valStr, genericType, e});
                return valStr;
            }
        }
        Class<?> clazz = field.getType();
        if (clazz == String.class) {
            return result instanceof String ? result : rs.getString(columnIndex);
        }
        if (clazz == Integer.class || clazz == Integer.TYPE) {
            return result instanceof Integer ? result : Integer.valueOf(rs.getInt(columnIndex));
        }
        if (clazz == Long.class || clazz == Long.TYPE) {
            return result instanceof Long ? result : Long.valueOf(rs.getLong(columnIndex));
        }
        if (clazz == Boolean.class || clazz == Boolean.TYPE) {
            return result instanceof Boolean ? result : Boolean.valueOf(rs.getBoolean(columnIndex));
        }
        if (clazz == Byte.class || clazz == Byte.TYPE) {
            return result instanceof Byte ? result : Byte.valueOf(rs.getByte(columnIndex));
        }
        if (clazz == byte[].class) {
            if (databaseType == DatabaseTypeEnum.CLICKHOUSE) {
                return InnerCommonUtils.decodeBase64(result instanceof String ? (String)result : rs.getString(columnIndex));
            }
            return result instanceof byte[] ? result : (Object)rs.getBytes(columnIndex);
        }
        if (clazz == Short.class || clazz == Short.TYPE) {
            return result instanceof Short ? result : Short.valueOf(rs.getShort(columnIndex));
        }
        if (clazz == Float.class || clazz == Float.TYPE) {
            return result instanceof Float ? result : Float.valueOf(rs.getFloat(columnIndex));
        }
        if (clazz == Double.class || clazz == Double.TYPE) {
            return result instanceof Double ? result : Double.valueOf(rs.getDouble(columnIndex));
        }
        if (clazz == BigDecimal.class) {
            return result instanceof BigDecimal ? result : rs.getBigDecimal(columnIndex);
        }
        if (clazz == java.util.Date.class) {
            if (Objects.equals(result.getClass(), java.util.Date.class)) {
                return result;
            }
            return TypeAutoCast.getDate(rs, columnIndex);
        }
        if (clazz == LocalDateTime.class) {
            if (result instanceof LocalDateTime) {
                return result;
            }
            java.util.Date date = TypeAutoCast.getDate(rs, columnIndex);
            if (date == null) {
                return null;
            }
            return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
        }
        if (clazz == LocalDate.class) {
            if (result instanceof LocalDate) {
                return result;
            }
            java.util.Date date = TypeAutoCast.getDate(rs, columnIndex);
            if (date == null) {
                return null;
            }
            return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        }
        if (clazz == LocalTime.class) {
            if (result instanceof LocalTime) {
                return result;
            }
            java.util.Date date = TypeAutoCast.getDate(rs, columnIndex);
            if (date == null) {
                return null;
            }
            return date.toInstant().atZone(ZoneId.systemDefault()).toLocalTime();
        }
        if (clazz == Date.class) {
            return result instanceof Date ? result : rs.getDate(columnIndex);
        }
        if (clazz == Time.class) {
            return result instanceof Time ? result : rs.getDate(columnIndex);
        }
        if (clazz == Timestamp.class) {
            return result instanceof Timestamp ? result : rs.getTimestamp(columnIndex);
        }
        return result;
    }

    private static java.util.Date getDate(ResultSet rs, int columnIndex) throws Exception {
        try {
            Timestamp timestamp = rs.getTimestamp(columnIndex);
            if (timestamp == null) {
                return null;
            }
            return new java.util.Date(timestamp.getTime());
        }
        catch (Exception e) {
            String str = rs.getString(columnIndex);
            if (InnerCommonUtils.isBlank(str)) {
                return null;
            }
            return NimbleOrmDateUtils.parseThrowException(str.trim());
        }
    }

    public static BasicTypeResult transBasicType(Class<?> clazz, ResultSet rs) throws Exception {
        java.util.Date date;
        BasicTypeResult result = new BasicTypeResult();
        if (clazz == String.class) {
            result.setBasicType(true);
            result.setValue(rs.getString(1));
        }
        if (clazz == Integer.class || clazz == Integer.TYPE) {
            result.setBasicType(true);
            result.setValue(rs.getInt(1));
        }
        if (clazz == Long.class || clazz == Long.TYPE) {
            result.setBasicType(true);
            result.setValue(rs.getLong(1));
        }
        if (clazz == Boolean.class || clazz == Boolean.TYPE) {
            result.setBasicType(true);
            result.setValue(rs.getBoolean(1));
        }
        if (clazz == Byte.class || clazz == Byte.TYPE) {
            result.setBasicType(true);
            result.setValue(rs.getByte(1));
        }
        if (clazz == byte[].class) {
            result.setBasicType(true);
            result.setValue(rs.getBytes(1));
        }
        if (clazz == Short.class || clazz == Short.TYPE) {
            result.setBasicType(true);
            result.setValue(rs.getShort(1));
        }
        if (clazz == Float.class || clazz == Float.TYPE) {
            result.setBasicType(true);
            result.setValue(Float.valueOf(rs.getFloat(1)));
        }
        if (clazz == Double.class || clazz == Double.TYPE) {
            result.setBasicType(true);
            result.setValue(rs.getDouble(1));
        }
        if (clazz == BigDecimal.class) {
            result.setBasicType(true);
            result.setValue(rs.getBigDecimal(1));
        }
        if (clazz == java.util.Date.class) {
            result.setBasicType(true);
            date = TypeAutoCast.getDate(rs, 1);
            result.setValue(date);
        }
        if (clazz == LocalDateTime.class) {
            result.setBasicType(true);
            date = TypeAutoCast.getDate(rs, 1);
            if (date == null) {
                result.setValue(null);
            } else {
                result.setValue(date.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime());
            }
        }
        if (clazz == LocalDate.class) {
            result.setBasicType(true);
            date = TypeAutoCast.getDate(rs, 1);
            if (date == null) {
                result.setValue(null);
            } else {
                result.setValue(date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate());
            }
        }
        if (clazz == LocalTime.class) {
            result.setBasicType(true);
            date = TypeAutoCast.getDate(rs, 1);
            if (date == null) {
                result.setValue(null);
            } else {
                result.setValue(date.toInstant().atZone(ZoneId.systemDefault()).toLocalTime());
            }
        }
        if (clazz == Date.class) {
            result.setBasicType(true);
            result.setValue(rs.getDate(1));
        }
        if (clazz == Time.class) {
            result.setBasicType(true);
            result.setValue(rs.getDate(1));
        }
        if (clazz == Timestamp.class) {
            result.setBasicType(true);
            result.setValue(rs.getTimestamp(1));
        }
        if (clazz == Map.class) {
            result.setBasicType(true);
            ResultSetMetaData md = rs.getMetaData();
            int columns = md.getColumnCount();
            HashMap<String, Object> map = new HashMap<String, Object>(columns);
            for (int i = 1; i <= columns; ++i) {
                map.put(md.getColumnLabel(i), rs.getObject(i));
            }
            result.setValue(map);
        }
        return result;
    }

    public static <T> T cast(Object obj, Class<T> clazz) {
        if (clazz.isInstance(obj)) {
            return (T)obj;
        }
        if (clazz == Integer.class || clazz == Integer.TYPE) {
            if (obj == null) {
                return (T)(clazz == Integer.TYPE ? Integer.valueOf(0) : null);
            }
            if (obj instanceof Integer) {
                return (T)obj;
            }
            return (T)Integer.valueOf(obj.toString());
        }
        if (clazz == Long.class || clazz == Long.TYPE) {
            if (obj == null) {
                return (T)(clazz == Long.TYPE ? Long.valueOf(0L) : null);
            }
            if (obj instanceof Long) {
                return (T)obj;
            }
            return (T)Long.valueOf(obj.toString());
        }
        if (clazz == Byte.class || clazz == Byte.TYPE) {
            if (obj == null) {
                return (T)(clazz == Byte.TYPE ? Byte.valueOf((byte)0) : null);
            }
            if (obj instanceof Byte) {
                return (T)obj;
            }
            return (T)Byte.valueOf(obj.toString());
        }
        if (clazz == Character.class || clazz == Character.TYPE) {
            if (obj == null) {
                return (T)(clazz == Character.TYPE ? Character.valueOf('\u0000') : null);
            }
            if (obj instanceof Character) {
                return (T)obj;
            }
            return (T)Character.valueOf('\u0000');
        }
        if (clazz == Short.class || clazz == Short.TYPE) {
            if (obj == null) {
                return (T)(clazz == Short.TYPE ? Short.valueOf((short)0) : null);
            }
            if (obj instanceof Short) {
                return (T)obj;
            }
            return (T)Short.valueOf(obj.toString());
        }
        if (clazz == Boolean.class || clazz == Boolean.TYPE) {
            if (obj == null) {
                return (T)(clazz == Boolean.TYPE ? Boolean.FALSE : null);
            }
            if (obj instanceof Boolean) {
                return (T)obj;
            }
            if (obj instanceof Number) {
                return (T)Boolean.valueOf(((Number)obj).intValue() != 0);
            }
            return (T)Boolean.valueOf(obj.toString());
        }
        if (clazz == Float.class || clazz == Float.TYPE) {
            if (obj == null) {
                return (T)(clazz == Float.TYPE ? Float.valueOf(0.0f) : null);
            }
            if (obj instanceof Float) {
                return (T)obj;
            }
            return (T)Float.valueOf(obj.toString());
        }
        if (clazz == Double.class || clazz == Double.TYPE) {
            if (obj == null) {
                return (T)(clazz == Double.TYPE ? Double.valueOf(0.0) : null);
            }
            if (obj instanceof Double) {
                return (T)obj;
            }
            return (T)Double.valueOf(obj.toString());
        }
        if (obj == null) {
            return null;
        }
        if (clazz == String.class) {
            return (T)obj.toString();
        }
        if (clazz == BigDecimal.class) {
            return (T)new BigDecimal(obj.toString());
        }
        if (clazz == Date.class && obj instanceof java.util.Date) {
            return (T)new Date(((java.util.Date)obj).getTime());
        }
        if (clazz == Time.class && obj instanceof java.util.Date) {
            return (T)new Time(((java.util.Date)obj).getTime());
        }
        return (T)obj;
    }

    public static String toSqlValueStr(Object object) {
        if (object == null) {
            return "''";
        }
        if (object instanceof java.util.Date) {
            return "'" + NimbleOrmDateUtils.formatWithMs((java.util.Date)object) + "'";
        }
        return "'" + object.toString().replace("'", "\\'") + "'";
    }

    public static class BasicTypeResult {
        private Object value;
        private boolean isBasicType;

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public boolean isBasicType() {
            return this.isBasicType;
        }

        public void setBasicType(boolean basicType) {
            this.isBasicType = basicType;
        }
    }
}

