/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.apigateway.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class StageCanarySettings {
    @Nullable
    private Double percentTraffic;
    @Nullable
    private Map<String, String> stageVariableOverrides;
    @Nullable
    private Boolean useStageCache;

    private StageCanarySettings() {
    }

    public Optional<Double> percentTraffic() {
        return Optional.ofNullable(this.percentTraffic);
    }

    public Map<String, String> stageVariableOverrides() {
        return this.stageVariableOverrides == null ? Map.of() : this.stageVariableOverrides;
    }

    public Optional<Boolean> useStageCache() {
        return Optional.ofNullable(this.useStageCache);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(StageCanarySettings defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private Double percentTraffic;
        @Nullable
        private Map<String, String> stageVariableOverrides;
        @Nullable
        private Boolean useStageCache;

        public Builder() {
        }

        public Builder(StageCanarySettings defaults) {
            Objects.requireNonNull(defaults);
            this.percentTraffic = defaults.percentTraffic;
            this.stageVariableOverrides = defaults.stageVariableOverrides;
            this.useStageCache = defaults.useStageCache;
        }

        @CustomType.Setter
        public Builder percentTraffic(@Nullable Double percentTraffic) {
            this.percentTraffic = percentTraffic;
            return this;
        }

        @CustomType.Setter
        public Builder stageVariableOverrides(@Nullable Map<String, String> stageVariableOverrides) {
            this.stageVariableOverrides = stageVariableOverrides;
            return this;
        }

        @CustomType.Setter
        public Builder useStageCache(@Nullable Boolean useStageCache) {
            this.useStageCache = useStageCache;
            return this;
        }

        public StageCanarySettings build() {
            StageCanarySettings o = new StageCanarySettings();
            o.percentTraffic = this.percentTraffic;
            o.stageVariableOverrides = this.stageVariableOverrides;
            o.useStageCache = this.useStageCache;
            return o;
        }
    }
}

