/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.apigatewayv2;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import com.pulumi.resources.ResourceArgs;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public final class IntegrationResponseArgs
extends ResourceArgs {
    public static final IntegrationResponseArgs Empty = new IntegrationResponseArgs();
    @Import(name="apiId", required=true)
    private Output<String> apiId;
    @Import(name="contentHandlingStrategy")
    @Nullable
    private Output<String> contentHandlingStrategy;
    @Import(name="integrationId", required=true)
    private Output<String> integrationId;
    @Import(name="integrationResponseKey", required=true)
    private Output<String> integrationResponseKey;
    @Import(name="responseTemplates")
    @Nullable
    private Output<Map<String, String>> responseTemplates;
    @Import(name="templateSelectionExpression")
    @Nullable
    private Output<String> templateSelectionExpression;

    public Output<String> apiId() {
        return this.apiId;
    }

    public Optional<Output<String>> contentHandlingStrategy() {
        return Optional.ofNullable(this.contentHandlingStrategy);
    }

    public Output<String> integrationId() {
        return this.integrationId;
    }

    public Output<String> integrationResponseKey() {
        return this.integrationResponseKey;
    }

    public Optional<Output<Map<String, String>>> responseTemplates() {
        return Optional.ofNullable(this.responseTemplates);
    }

    public Optional<Output<String>> templateSelectionExpression() {
        return Optional.ofNullable(this.templateSelectionExpression);
    }

    private IntegrationResponseArgs() {
    }

    private IntegrationResponseArgs(IntegrationResponseArgs $) {
        this.apiId = $.apiId;
        this.contentHandlingStrategy = $.contentHandlingStrategy;
        this.integrationId = $.integrationId;
        this.integrationResponseKey = $.integrationResponseKey;
        this.responseTemplates = $.responseTemplates;
        this.templateSelectionExpression = $.templateSelectionExpression;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(IntegrationResponseArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private IntegrationResponseArgs $;

        public Builder() {
            this.$ = new IntegrationResponseArgs();
        }

        public Builder(IntegrationResponseArgs defaults) {
            this.$ = new IntegrationResponseArgs(Objects.requireNonNull(defaults));
        }

        public Builder apiId(Output<String> apiId) {
            this.$.apiId = apiId;
            return this;
        }

        public Builder apiId(String apiId) {
            return this.apiId((Output<String>)Output.of((Object)apiId));
        }

        public Builder contentHandlingStrategy(@Nullable Output<String> contentHandlingStrategy) {
            this.$.contentHandlingStrategy = contentHandlingStrategy;
            return this;
        }

        public Builder contentHandlingStrategy(String contentHandlingStrategy) {
            return this.contentHandlingStrategy((Output<String>)Output.of((Object)contentHandlingStrategy));
        }

        public Builder integrationId(Output<String> integrationId) {
            this.$.integrationId = integrationId;
            return this;
        }

        public Builder integrationId(String integrationId) {
            return this.integrationId((Output<String>)Output.of((Object)integrationId));
        }

        public Builder integrationResponseKey(Output<String> integrationResponseKey) {
            this.$.integrationResponseKey = integrationResponseKey;
            return this;
        }

        public Builder integrationResponseKey(String integrationResponseKey) {
            return this.integrationResponseKey((Output<String>)Output.of((Object)integrationResponseKey));
        }

        public Builder responseTemplates(@Nullable Output<Map<String, String>> responseTemplates) {
            this.$.responseTemplates = responseTemplates;
            return this;
        }

        public Builder responseTemplates(Map<String, String> responseTemplates) {
            return this.responseTemplates((Output<Map<String, String>>)Output.of(responseTemplates));
        }

        public Builder templateSelectionExpression(@Nullable Output<String> templateSelectionExpression) {
            this.$.templateSelectionExpression = templateSelectionExpression;
            return this;
        }

        public Builder templateSelectionExpression(String templateSelectionExpression) {
            return this.templateSelectionExpression((Output<String>)Output.of((Object)templateSelectionExpression));
        }

        public IntegrationResponseArgs build() {
            this.$.apiId = Objects.requireNonNull(this.$.apiId, "expected parameter 'apiId' to be non-null");
            this.$.integrationId = Objects.requireNonNull(this.$.integrationId, "expected parameter 'integrationId' to be non-null");
            this.$.integrationResponseKey = Objects.requireNonNull(this.$.integrationResponseKey, "expected parameter 'integrationResponseKey' to be non-null");
            return this.$;
        }
    }
}

