/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.apigatewayv2.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class AuthorizerJwtConfiguration {
    @Nullable
    private List<String> audiences;
    @Nullable
    private String issuer;

    private AuthorizerJwtConfiguration() {
    }

    public List<String> audiences() {
        return this.audiences == null ? List.of() : this.audiences;
    }

    public Optional<String> issuer() {
        return Optional.ofNullable(this.issuer);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(AuthorizerJwtConfiguration defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private List<String> audiences;
        @Nullable
        private String issuer;

        public Builder() {
        }

        public Builder(AuthorizerJwtConfiguration defaults) {
            Objects.requireNonNull(defaults);
            this.audiences = defaults.audiences;
            this.issuer = defaults.issuer;
        }

        @CustomType.Setter
        public Builder audiences(@Nullable List<String> audiences) {
            this.audiences = audiences;
            return this;
        }

        public Builder audiences(String ... audiences) {
            return this.audiences(List.of(audiences));
        }

        @CustomType.Setter
        public Builder issuer(@Nullable String issuer) {
            this.issuer = issuer;
            return this;
        }

        public AuthorizerJwtConfiguration build() {
            AuthorizerJwtConfiguration o = new AuthorizerJwtConfiguration();
            o.audiences = this.audiences;
            o.issuer = this.issuer;
            return o;
        }
    }
}

