/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.appflow.outputs;

import com.pulumi.aws.appflow.outputs.FlowTaskConnectorOperator;
import com.pulumi.core.annotations.CustomType;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class FlowTask {
    @Nullable
    private List<FlowTaskConnectorOperator> connectorOperators;
    @Nullable
    private String destinationField;
    private List<String> sourceFields;
    @Nullable
    private Map<String, String> taskProperties;
    private String taskType;

    private FlowTask() {
    }

    public List<FlowTaskConnectorOperator> connectorOperators() {
        return this.connectorOperators == null ? List.of() : this.connectorOperators;
    }

    public Optional<String> destinationField() {
        return Optional.ofNullable(this.destinationField);
    }

    public List<String> sourceFields() {
        return this.sourceFields;
    }

    public Map<String, String> taskProperties() {
        return this.taskProperties == null ? Map.of() : this.taskProperties;
    }

    public String taskType() {
        return this.taskType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(FlowTask defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private List<FlowTaskConnectorOperator> connectorOperators;
        @Nullable
        private String destinationField;
        private List<String> sourceFields;
        @Nullable
        private Map<String, String> taskProperties;
        private String taskType;

        public Builder() {
        }

        public Builder(FlowTask defaults) {
            Objects.requireNonNull(defaults);
            this.connectorOperators = defaults.connectorOperators;
            this.destinationField = defaults.destinationField;
            this.sourceFields = defaults.sourceFields;
            this.taskProperties = defaults.taskProperties;
            this.taskType = defaults.taskType;
        }

        @CustomType.Setter
        public Builder connectorOperators(@Nullable List<FlowTaskConnectorOperator> connectorOperators) {
            this.connectorOperators = connectorOperators;
            return this;
        }

        public Builder connectorOperators(FlowTaskConnectorOperator ... connectorOperators) {
            return this.connectorOperators(List.of(connectorOperators));
        }

        @CustomType.Setter
        public Builder destinationField(@Nullable String destinationField) {
            this.destinationField = destinationField;
            return this;
        }

        @CustomType.Setter
        public Builder sourceFields(List<String> sourceFields) {
            this.sourceFields = Objects.requireNonNull(sourceFields);
            return this;
        }

        public Builder sourceFields(String ... sourceFields) {
            return this.sourceFields(List.of(sourceFields));
        }

        @CustomType.Setter
        public Builder taskProperties(@Nullable Map<String, String> taskProperties) {
            this.taskProperties = taskProperties;
            return this;
        }

        @CustomType.Setter
        public Builder taskType(String taskType) {
            this.taskType = Objects.requireNonNull(taskType);
            return this;
        }

        public FlowTask build() {
            FlowTask o = new FlowTask();
            o.connectorOperators = this.connectorOperators;
            o.destinationField = this.destinationField;
            o.sourceFields = this.sourceFields;
            o.taskProperties = this.taskProperties;
            o.taskType = this.taskType;
            return o;
        }
    }
}

