/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.apprunner.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class ServiceInstanceConfiguration {
    @Nullable
    private String cpu;
    @Nullable
    private String instanceRoleArn;
    @Nullable
    private String memory;

    private ServiceInstanceConfiguration() {
    }

    public Optional<String> cpu() {
        return Optional.ofNullable(this.cpu);
    }

    public Optional<String> instanceRoleArn() {
        return Optional.ofNullable(this.instanceRoleArn);
    }

    public Optional<String> memory() {
        return Optional.ofNullable(this.memory);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ServiceInstanceConfiguration defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private String cpu;
        @Nullable
        private String instanceRoleArn;
        @Nullable
        private String memory;

        public Builder() {
        }

        public Builder(ServiceInstanceConfiguration defaults) {
            Objects.requireNonNull(defaults);
            this.cpu = defaults.cpu;
            this.instanceRoleArn = defaults.instanceRoleArn;
            this.memory = defaults.memory;
        }

        @CustomType.Setter
        public Builder cpu(@Nullable String cpu) {
            this.cpu = cpu;
            return this;
        }

        @CustomType.Setter
        public Builder instanceRoleArn(@Nullable String instanceRoleArn) {
            this.instanceRoleArn = instanceRoleArn;
            return this;
        }

        @CustomType.Setter
        public Builder memory(@Nullable String memory) {
            this.memory = memory;
            return this;
        }

        public ServiceInstanceConfiguration build() {
            ServiceInstanceConfiguration o = new ServiceInstanceConfiguration();
            o.cpu = this.cpu;
            o.instanceRoleArn = this.instanceRoleArn;
            o.memory = this.memory;
            return o;
        }
    }
}

