/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.appsync.outputs;

import com.pulumi.aws.appsync.outputs.DataSourceHttpConfigAuthorizationConfig;
import com.pulumi.core.annotations.CustomType;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class DataSourceHttpConfig {
    @Nullable
    private DataSourceHttpConfigAuthorizationConfig authorizationConfig;
    private String endpoint;

    private DataSourceHttpConfig() {
    }

    public Optional<DataSourceHttpConfigAuthorizationConfig> authorizationConfig() {
        return Optional.ofNullable(this.authorizationConfig);
    }

    public String endpoint() {
        return this.endpoint;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(DataSourceHttpConfig defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private DataSourceHttpConfigAuthorizationConfig authorizationConfig;
        private String endpoint;

        public Builder() {
        }

        public Builder(DataSourceHttpConfig defaults) {
            Objects.requireNonNull(defaults);
            this.authorizationConfig = defaults.authorizationConfig;
            this.endpoint = defaults.endpoint;
        }

        @CustomType.Setter
        public Builder authorizationConfig(@Nullable DataSourceHttpConfigAuthorizationConfig authorizationConfig) {
            this.authorizationConfig = authorizationConfig;
            return this;
        }

        @CustomType.Setter
        public Builder endpoint(String endpoint) {
            this.endpoint = Objects.requireNonNull(endpoint);
            return this;
        }

        public DataSourceHttpConfig build() {
            DataSourceHttpConfig o = new DataSourceHttpConfig();
            o.authorizationConfig = this.authorizationConfig;
            o.endpoint = this.endpoint;
            return o;
        }
    }
}

