/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.athena.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class DatabaseEncryptionConfiguration {
    private String encryptionOption;
    @Nullable
    private String kmsKey;

    private DatabaseEncryptionConfiguration() {
    }

    public String encryptionOption() {
        return this.encryptionOption;
    }

    public Optional<String> kmsKey() {
        return Optional.ofNullable(this.kmsKey);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(DatabaseEncryptionConfiguration defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        private String encryptionOption;
        @Nullable
        private String kmsKey;

        public Builder() {
        }

        public Builder(DatabaseEncryptionConfiguration defaults) {
            Objects.requireNonNull(defaults);
            this.encryptionOption = defaults.encryptionOption;
            this.kmsKey = defaults.kmsKey;
        }

        @CustomType.Setter
        public Builder encryptionOption(String encryptionOption) {
            this.encryptionOption = Objects.requireNonNull(encryptionOption);
            return this;
        }

        @CustomType.Setter
        public Builder kmsKey(@Nullable String kmsKey) {
            this.kmsKey = kmsKey;
            return this;
        }

        public DatabaseEncryptionConfiguration build() {
            DatabaseEncryptionConfiguration o = new DatabaseEncryptionConfiguration();
            o.encryptionOption = this.encryptionOption;
            o.kmsKey = this.kmsKey;
            return o;
        }
    }
}

